/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.modules.ipn.server.bean;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Vector;
import ru.bitel.bgbilling.modules.ipn.server.bean.PatternRule;

public class PatternRuleManager {
    private Connection con;
    private int mid;

    public PatternRuleManager(Connection con, int mid) {
        this.con = con;
        this.mid = mid;
    }

    public void updatePatternRule(String id, PatternRule pr) {
        String query = null;
        PreparedStatement ps = null;
        try {
            if ("new".equals(id)) {
                query = "INSERT INTO ipn_rule_pattern_" + this.mid + " ( title, pattern ) VALUES ( ?, ? )";
                ps = this.con.prepareStatement(query);
                ps.setString(1, pr.getTitle());
                ps.setString(2, pr.getPattern());
                ps.executeUpdate();
            } else {
                query = "UPDATE ipn_rule_pattern_" + this.mid + " SET title=?, pattern=? WHERE id=?";
                ps = this.con.prepareStatement(query);
                ps.setString(1, pr.getTitle());
                ps.setString(2, pr.getPattern());
                ps.setString(3, id);
                ps.executeUpdate();
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    public Vector<PatternRule> patternRuleList() {
        Vector<PatternRule> result = new Vector<PatternRule>();
        String query = null;
        PreparedStatement ps = null;
        try {
            query = "SELECT * FROM ipn_rule_pattern_" + this.mid + " ORDER BY title";
            ps = this.con.prepareStatement(query);
            ResultSet rs = ps.executeQuery();
            while (rs.next()) {
                PatternRule pr = new PatternRule();
                this.loadFromResultSet(rs, pr);
                result.add(pr);
            }
            rs.close();
            ps.close();
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        return result;
    }

    private void loadFromResultSet(ResultSet rs, PatternRule pr) throws SQLException {
        pr.setId(rs.getInt("id"));
        pr.setTitle(rs.getString("title"));
        pr.setPattern(rs.getString("pattern"));
        pr.setComment(rs.getString("comment"));
    }

    public PatternRule getPatternRuleById(int id) {
        PatternRule result = null;
        String query = "SELECT * FROM ipn_rule_pattern_" + this.mid + " WHERE id=?";
        try (PreparedStatement ps = this.con.prepareStatement(query);){
            ps.setInt(1, id);
            ResultSet rs = ps.executeQuery();
            if (rs.next()) {
                result = new PatternRule();
                this.loadFromResultSet(rs, result);
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        return result;
    }

    @Deprecated
    public PatternRule getPatternRuleByID(int id) {
        return this.getPatternRuleById(id);
    }

    public void deletePatternRule(int id) {
        String query = null;
        PreparedStatement ps = null;
        try {
            query = "DELETE FROM ipn_rule_pattern_" + this.mid + " WHERE id=?";
            ps = this.con.prepareStatement(query);
            ps.setInt(1, id);
            ps.executeUpdate();
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }
}

