/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.modules.inet.client.contract;

import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.swing.Icon;
import javax.swing.JLabel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableModel;
import ru.bitel.bgbilling.client.common.BGDialogToolBar;
import ru.bitel.bgbilling.client.common.BGEditorDialog;
import ru.bitel.bgbilling.client.common.BGTextField;
import ru.bitel.bgbilling.client.common.BGUPanel;
import ru.bitel.bgbilling.client.common.BGUTable;
import ru.bitel.bgbilling.client.common.ClientContext;
import ru.bitel.bgbilling.client.common.table.renderer.HorizontalAlignmentTableCellRenderer;
import ru.bitel.bgbilling.client.util.ClientUtils;
import ru.bitel.bgbilling.common.model.KeyValue;
import ru.bitel.common.ParameterMap;
import ru.bitel.common.Preferences;
import ru.bitel.common.Utils;
import ru.bitel.common.client.AbstractBGUPanel;
import ru.bitel.common.client.BGSwingUtilites;
import ru.bitel.common.client.BGUComboBox;
import ru.bitel.common.client.table.BGTableModel;

public class AdditionalParamsPanel
extends BGUPanel {
    private BGUTable table;
    private ParamTableModel model = new ParamTableModel();
    private BGUComboBox<KeyValue> keyCombo = new BGUComboBox();
    private static final Comparator<Param> COMPARATOR = new Comparator<Param>(){

        @Override
        public int compare(Param o1, Param o2) {
            int result = o1.title.compareTo(o2.title);
            if (result != 0) {
                return result;
            }
            return o1.key.compareTo(o2.key);
        }
    };

    public AdditionalParamsPanel(ClientContext context) {
        super(context);
    }

    protected void jbInit() {
        this.table = new BGUTable((TableModel)((Object)this.model));
        BGDialogToolBar toolBar = new BGDialogToolBar();
        toolBar.addButton(this.getActionMap().get("new"));
        toolBar.addButton(this.getActionMap().get("edit"));
        toolBar.addButton(this.getActionMap().get("delete"));
        toolBar.compact();
        BGSwingUtilites.handleEdit((JTable)this.table, (AbstractBGUPanel)this);
        this.setLayout(new GridBagLayout());
        this.add((Component)toolBar, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 0, 0, 0), 0, 0));
        this.add(new JScrollPane((Component)this.table), new GridBagConstraints(0, 1, 1, 1, 1.0, 1.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
    }

    public void setData(String servTypeConfigString, String configString) {
        ArrayList<KeyValue> typeList = new ArrayList<KeyValue>();
        Preferences servTypeConfig = new Preferences(Utils.maskNull((String)servTypeConfigString), "\n");
        for (Map.Entry e : servTypeConfig.subKeyed("param.").entrySet()) {
            String key = (String)e.getKey();
            ParameterMap param = (ParameterMap)e.getValue();
            typeList.add(new KeyValue(key, param.get("title", "")));
        }
        this.keyCombo.setData(typeList);
        ArrayList<Param> data = new ArrayList<Param>();
        Pattern pattern = Pattern.compile("\\A(.+)\\.(\\d+)\\z");
        Preferences config = new Preferences(Utils.maskNull((String)configString), "\n");
        for (Map.Entry e : config.entrySet()) {
            int index;
            String key = (String)e.getKey();
            Matcher m = pattern.matcher(key);
            if (m.find()) {
                key = m.group(1);
                index = Utils.parseInt((String)m.group(2));
            } else {
                index = 0;
            }
            data.add(new Param(key, index, servTypeConfig.get("param." + key + ".title", ""), (String)e.getValue()));
        }
        Collections.sort(data, COMPARATOR);
        this.model.setData(data);
    }

    public String getData() {
        StringBuilder sb = new StringBuilder(30);
        HashMap<String, int[]> counters = new HashMap<String, int[]>();
        for (Param val : this.model.getRows()) {
            if (!Utils.notBlankString((String)val.key) || !Utils.notBlankString((String)val.value)) continue;
            sb.append(val.key);
            int[] idx = (int[])counters.get(val.key);
            if (idx == null) {
                idx = new int[1];
                counters.put(val.key, idx);
            }
            idx[0] = idx[0] + 1;
            sb.append('.').append(idx[0]);
            sb.append('=').append(val.value).append('\n');
        }
        if (sb.length() > 0) {
            sb.setLength(sb.length() - 1);
        }
        return sb.toString();
    }

    protected void initActions() {
        new AbstractBGUPanel.BGActionNew((AbstractBGUPanel)this, e -> new ParamEditor("\u0414\u043e\u0431\u0430\u0432\u0438\u0442\u044c \u043f\u0430\u0440\u0430\u043c\u0435\u0442\u0440", new Param("", ""), false).open()).setIcon((Icon)ClientUtils.getIcon((String)"item_add"));
        new AbstractBGUPanel.BGActionEdit((AbstractBGUPanel)this, e -> this.model.optSelectedRow().ifPresentOrElse(param -> new ParamEditor("\u0420\u0435\u0434\u0430\u043a\u0442\u043e\u0440 \u043f\u0430\u0440\u0430\u043c\u0435\u0442\u0440\u0430", (Param)param, true).open(), () -> ClientUtils.showErrorMessageDialog((String)"\u0412\u044b\u0431\u0435\u0440\u0438\u0442\u0435 \u043f\u0430\u0440\u0430\u043c\u0435\u0442\u0440"))).setIcon((Icon)ClientUtils.getIcon((String)"item_edit"));
        new AbstractBGUPanel.BGActionDelete((AbstractBGUPanel)this, e -> {
            Param current = (Param)this.model.getSelectedRow();
            if (current != null) {
                this.model.deleteSelectedRows();
            }
        }).setIcon((Icon)ClientUtils.getIcon((String)"item_delete"));
    }

    class ParamTableModel
    extends BGTableModel<Param> {
        public ParamTableModel() {
            super(ParamTableModel.class.getName());
        }

        protected void initColumns() {
            this.addColumn("\u041a\u043b\u044e\u0447", 150, 250, 400, "key", true, (TableCellRenderer)HorizontalAlignmentTableCellRenderer.LEFT());
            this.addColumn("\u041f\u0430\u0440\u0430\u043c\u0435\u0442\u0440", 150, 150, -1, "title", true, (TableCellRenderer)HorizontalAlignmentTableCellRenderer.LEFT());
            this.addColumn("\u0417\u043d\u0430\u0447\u0435\u043d\u0438\u0435", 150, 150, -1, "value", false, (TableCellRenderer)HorizontalAlignmentTableCellRenderer.LEFT());
        }
    }

    public static class Param {
        public String key;
        public int index;
        public String title;
        public String value;

        public Param(String key, int index, String title, String value) {
            this.key = key;
            this.title = title;
            this.value = value;
            this.index = index;
        }

        public Param(String key, String title) {
            this.key = key;
            this.title = title;
        }

        public String getKey() {
            return this.key;
        }

        public int getIndex() {
            return this.index;
        }

        public String getTitle() {
            return this.title;
        }

        public String getValue() {
            return this.value;
        }
    }

    class ParamEditor
    extends BGEditorDialog<Param> {
        private boolean edit;
        private BGTextField value;

        public ParamEditor(String title, Param data, boolean edit) {
            super(title, (Object)data);
            this.value = new BGTextField(50);
            this.edit = edit;
        }

        public void doDialogPanel() {
            this.panel.add((Component)new JLabel("\u041f\u0430\u0440\u0430\u043c\u0435\u0442\u0440:"), new GridBagConstraints(0, -1, 1, 1, 0.0, 0.0, 17, 2, new Insets(0, 5, 0, 0), 0, 0));
            this.panel.add((Component)AdditionalParamsPanel.this.keyCombo, new GridBagConstraints(0, -1, 1, 1, 1.0, 0.0, 17, 2, new Insets(2, 0, 0, 0), 0, 0));
            this.panel.add((Component)new JLabel("\u0417\u043d\u0430\u0447\u0435\u043d\u0438\u0435:"), new GridBagConstraints(0, -1, 1, 1, 0.0, 0.0, 17, 2, new Insets(10, 5, 0, 0), 0, 0));
            this.panel.add((Component)this.value, new GridBagConstraints(0, -1, 1, 1, 1.0, 0.0, 10, 2, new Insets(2, 0, 0, 0), 0, 0));
            AdditionalParamsPanel.this.keyCombo.setSelectedItem((Object)((Param)this.data).key);
            AdditionalParamsPanel.this.keyCombo.setEnabled(Utils.isEmptyString((String)((Param)this.data).getKey()));
            this.value.setText(((Param)this.data).getValue());
        }

        public boolean doApply() throws Exception {
            KeyValue key = (KeyValue)AdditionalParamsPanel.this.keyCombo.getSelectedItem();
            if (key == null) {
                return false;
            }
            ((Param)this.data).key = key.getKey();
            ((Param)this.data).title = key.getValue();
            ((Param)this.data).value = this.value.getText();
            if (!this.edit) {
                int index = 0;
                for (Param p : AdditionalParamsPanel.this.model.getRows()) {
                    if (!p.key.equals(((Param)this.data).key)) continue;
                    index = Math.max(index, ((Param)this.data).index);
                }
                ((Param)this.data).index = index + 1;
                AdditionalParamsPanel.this.model.addRow((Param)this.data);
            }
            AdditionalParamsPanel.this.model.fireTableDataChanged();
            return true;
        }
    }

    class ParamForm
    extends BGUPanel {
        public ParamForm(ClientContext context) {
            super((LayoutManager)new GridBagLayout(), context);
        }

        protected void jbInit() {
        }
    }
}

