/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.modules.hd.server.bean;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.util.ArrayList;
import java.util.List;
import ru.bitel.bgbilling.modules.hd.server.bean.CPNs;

public class CPNsManager {
    private Connection con;
    private String tableName;

    public CPNsManager(Connection con, int mid) {
        this.con = con;
        this.tableName = "hd_cp_ns_" + mid;
    }

    public void deletePackageNs(int cpid) {
        try {
            String query = "DELETE FROM " + this.tableName + " WHERE cpid=?";
            PreparedStatement ps = this.con.prepareStatement(query);
            ps.setInt(1, cpid);
            ps.executeUpdate();
            ps.close();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void updatePackageNs(int cpid, List<CPNs> packageNsList) {
        try {
            this.deletePackageNs(cpid);
            int pos = 0;
            String query = "INSERT INTO " + this.tableName + " (cpid, pos, id, name ) VALUES (?, ?, ?, ?)";
            PreparedStatement ps = this.con.prepareStatement(query);
            ps.setInt(1, cpid);
            for (CPNs ns : packageNsList) {
                ps.setInt(2, pos++);
                ps.setInt(3, ns.getId());
                ps.setString(4, ns.getName());
                ps.executeUpdate();
            }
            ps.close();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public List<CPNs> getPackageNsList(int contractPackageId) {
        ArrayList<CPNs> result = new ArrayList<CPNs>();
        try {
            String query = "SELECT * FROM " + this.tableName + " WHERE cpid=? ORDER BY pos";
            PreparedStatement ps = this.con.prepareStatement(query);
            ps.setInt(1, contractPackageId);
            ResultSet rs = ps.executeQuery();
            while (rs.next()) {
                result.add(this.getNsFromRs(rs));
            }
            ps.close();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return result;
    }

    private CPNs getNsFromRs(ResultSet rs) throws Exception {
        CPNs result = new CPNs();
        result.setContractPackageId(rs.getInt("cpid"));
        result.setPos(rs.getInt("pos"));
        result.setId(rs.getInt("id"));
        result.setName(rs.getString("name"));
        return result;
    }
}

