/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.plugins.crm.server.action;

import bitel.billing.server.contract.bean.Contract;
import bitel.billing.server.contract.bean.ContractManager;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.util.Date;
import java.util.List;
import java.util.Map;
import javax.xml.transform.Source;
import javax.xml.transform.dom.DOMSource;
import org.w3c.dom.Element;
import ru.bitel.bgbilling.common.BGMessageException;
import ru.bitel.bgbilling.kernel.container.web.action.XSLManager;
import ru.bitel.bgbilling.kernel.event.common.Event;
import ru.bitel.bgbilling.plugins.crm.common.model.RegisterCall;
import ru.bitel.bgbilling.plugins.crm.common.model.RegisterProblem;
import ru.bitel.bgbilling.plugins.crm.server.action.ActionBase;
import ru.bitel.bgbilling.plugins.crm.server.bean.event.ProblemOrCallChangedEvent;
import ru.bitel.bgbilling.plugins.crm.server.dao.RegisterProblemManager;
import ru.bitel.common.Utils;

public class ActionUpdateRegisterProblem
extends ActionBase {
    public void doAction() throws Exception {
        String id = this.getParameter("id");
        String comment = this.checkString(this.getParameter("comment", ""));
        String resolution = this.checkString(this.getParameter("resolution", ""));
        String executors = this.getParameter("executors", "");
        int group = this.getIntParameter("group", 0);
        int urgency = this.getIntParameter("urgency", 0);
        int category = this.getIntParameter("category", 0);
        int status = this.getIntParameter("status", 0);
        RegisterProblemManager problemManager = new RegisterProblemManager(this.con);
        RegisterProblem problem = null;
        boolean addGroup = false;
        if (id.equals("-1")) {
            problem = new RegisterProblem();
            this.statusChanged(problem, this.plugin.getSetup().getInt("register.problem.status.default", 0));
            addGroup = true;
        } else {
            problem = problemManager.getProblemByID(Utils.parseInt((String)id, (int)0));
            if (problem != null && problem.getStatus() != status) {
                this.statusChanged(problem, status);
            }
            if (problem.getGroupId() != group) {
                addGroup = true;
            }
        }
        if (problem != null) {
            problem.setComment(comment);
            problem.setResolution(resolution);
            problem.setStatus(status);
            problem.setGroupId(group);
            problem.setCategoryId(category);
            problem.setUrgency(urgency);
            problem.setExecutors(Utils.toList((String)executors));
            problemManager.updateProblem(problem, this.userId);
            problemManager.updateProblemExecutors(problem, this.getGroupsExecutors(String.valueOf(problem.getGroupId())));
            if (addGroup) {
                problemManager.addGroup(problem.getId(), group);
            }
        }
        if (problem != null && this.getParameter("send.mail") != null) {
            this.sendRegisterEmail(problem, this.plugin.getSetup().get("register.problem.mail.subject", this.setup.get("register.problem.mail.subject", "\u041e\u0442\u0447\u0435\u0442 \u043f\u043e \u043f\u0440\u043e\u0431\u043b\u0435\u043c\u0435")));
        }
        Element problemElement = this.createElement(this.rootNode, "problem");
        problemElement.setAttribute("id", String.valueOf(problem.getId()));
        int eventContractId = this.plugin.getSetup().getInt("event.contract.id", 0);
        if (eventContractId > 0) {
            this.context.publishAfterCommit((Event)new ProblemOrCallChangedEvent(this.plugin.getPluginUID(), eventContractId, "new".equals(id), null, problem));
        }
    }

    private void statusChanged(RegisterProblem problem, int newStatus) {
        problem.setStatusTime(new Date());
        problem.setStatusUserId(this.userId.intValue());
        if (newStatus == this.plugin.getSetup().getInt("register.problem.status.default", 0)) {
            problem.setOpenTime(new Date());
            problem.setOpenUserId(this.userId.intValue());
        } else if (newStatus == this.plugin.getSetup().getInt("register.problem.status.close", 2)) {
            problem.setCloseTime(new Date());
            problem.setCloseUserId(this.userId.intValue());
        }
    }

    protected void sendRegisterEmail(RegisterProblem problem, String subject) throws Exception {
        ResultSet rs;
        PreparedStatement ps;
        Object query;
        String email = this.getGroupEmail(problem.getGroupId());
        if (email == null) {
            throw new BGMessageException("\u0423 \u0433\u0440\u0443\u043f\u043f\u044b \u043d\u0435\u0442 \u043f\u043e\u0447\u0442\u043e\u0432\u043e\u0433\u043e \u0430\u0434\u0440\u0435\u0441\u0430!");
        }
        ContractManager cm = new ContractManager(this.con);
        RegisterProblemManager problemManager = new RegisterProblemManager(this.con);
        String statusList = this.plugin.getSetup().get("register.problem.status.list", "0:\u043e\u0442\u043a\u0440\u044b\u0442\u0430;1:\u043f\u0440\u0438\u043d\u044f\u0442\u0430;2:\u0437\u0430\u043a\u0440\u044b\u0442\u0430");
        Map<Integer, String> statusMap = RegisterProblemManager.getStatusMap(statusList);
        Element header = this.createElement(this.rootNode, "header");
        header.setAttribute("id", String.valueOf(problem.getId()));
        header.setAttribute("status", statusMap.get(problem.getStatus()));
        header.setAttribute("urgency", String.valueOf(problem.getUrgency()));
        this.addUserData(problem.getOpenUserId(), problem.getOpenTime(), "dd.MM.yyyy HH:mm", header, "open");
        this.addUserData(problem.getStatusUserId(), problem.getStatusTime(), "dd.MM.yyyy HH:mm", header, "accept");
        this.addUserData(problem.getCloseUserId(), problem.getCloseTime(), "dd.MM.yyyy HH:mm", header, "close");
        if (problem.getCategoryId() > 0) {
            query = "SELECT title FROM register_category WHERE id=?";
            ps = this.con.prepareStatement((String)query);
            ps.setInt(1, problem.getCategoryId());
            rs = ps.executeQuery();
            if (rs.next()) {
                header.setAttribute("category", rs.getString(1));
            }
            rs.close();
            ps.close();
        }
        query = "SELECT title FROM register_group WHERE id=?";
        ps = this.con.prepareStatement((String)query);
        ps.setInt(1, problem.getGroupId());
        rs = ps.executeQuery();
        if (rs.next()) {
            header.setAttribute("group", rs.getString(1));
        }
        rs.close();
        ps.close();
        Element executors = this.createElement(this.rootNode, "executors");
        List executorsList = problem.getExecutors();
        if (executorsList.size() > 0) {
            query = "SELECT id, title FROM register_executor WHERE id IN ( " + Utils.toString((Iterable)executorsList) + " )";
            ps = this.con.prepareStatement((String)query);
            rs = ps.executeQuery();
            Element item = null;
            while (rs.next()) {
                item = this.createElement(executors, "item");
                item.setAttribute("id", rs.getString(1));
                item.setAttribute("title", rs.getString(2));
            }
            rs.close();
            ps.close();
        }
        Element groups = this.createElement(this.rootNode, "groups");
        for (String userGroup : problemManager.getProblemUsedGroups(problem.getId())) {
            this.addListItem(groups, "", userGroup);
        }
        Element comment = this.createElement(this.rootNode, "comment");
        this.stringToLines(comment, problem.getComment());
        Element resolution = this.createElement(this.rootNode, "resolution");
        this.stringToLines(resolution, problem.getResolution());
        Element calls = this.createElement(this.rootNode, "calls");
        List callList = problem.getCalls();
        if (callList != null) {
            for (RegisterCall call : callList) {
                Contract contract = cm.getContractById(call.getContractId());
                if (contract == null) continue;
                Element item = this.createElement(calls, "item");
                item.setAttribute("id", String.valueOf(call.getId()));
                item.setAttribute("contract_title", contract.getTitle());
                item.setAttribute("contract_comment", contract.getComment());
            }
        }
        XSLManager.getInstance().transformAndSend("crm_register_problem.xsl", (Source)new DOMSource(this.rootNode.getOwnerDocument()), null, "text/html", null, false, email, subject);
    }

    private String checkString(String inString) {
        String result = null;
        if (inString != null) {
            StringBuilder outString = new StringBuilder();
            for (int index = 0; index < inString.length(); ++index) {
                char ch = inString.charAt(index);
                if (ch == '\u0000') continue;
                outString.append(ch);
            }
            result = outString.toString();
        }
        return result;
    }
}

