/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.modules.buyemoney.server.action.web;

import java.util.Calendar;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.List;
import org.w3c.dom.Element;
import ru.bitel.bgbilling.common.BGException;
import ru.bitel.bgbilling.common.BGIllegalArgumentException;
import ru.bitel.bgbilling.kernel.contract.api.server.bean.ContractDao;
import ru.bitel.bgbilling.modules.buyemoney.server.action.ActionBase;
import ru.bitel.bgbilling.modules.buyemoney.server.bean.BuyemoneyManager;
import ru.bitel.bgbilling.modules.buyemoney.server.bean.BuyemoneyPayment;
import ru.bitel.bgbilling.modules.buyemoney.server.bean.CurrencyRate;
import ru.bitel.bgbilling.modules.buyemoney.server.protocols.ProtocolCurrency;
import ru.bitel.bgbilling.modules.buyemoney.server.protocols.ProtocolManager;
import ru.bitel.common.ParameterMap;
import ru.bitel.common.TimeUtils;
import ru.bitel.common.Utils;
import ru.bitel.common.model.Period;

public class ActionPayList
extends ActionBase {
    public void doAction() throws Exception {
        int firstYear;
        if (this.cid <= 0 && this.mid <= 0) {
            throw new BGIllegalArgumentException();
        }
        Calendar now = Calendar.getInstance();
        int mm = this.getIntParameter("month", now.get(2) + 1);
        int yy = this.getIntParameter("year", now.get(1));
        BuyemoneyManager manager = new BuyemoneyManager(this.con, this.mid);
        GregorianCalendar from = new GregorianCalendar(yy, mm - 1, 1);
        Calendar until = (Calendar)((Calendar)from).clone();
        until.add(2, 1);
        List<BuyemoneyPayment> paymentList = manager.getPaymentList(this.cid, new Period(from.getTime(), until.getTime()), -1, null, null);
        Element buyemoneyEl = this.createElement(this.rootNode, "buyemoney");
        for (BuyemoneyPayment payment : paymentList) {
            Element paymentEl = this.createElement(buyemoneyEl, "payment");
            paymentEl.setAttribute("id", String.valueOf(payment.getId()));
            paymentEl.setAttribute("date", TimeUtils.format((Date)payment.getDate(), (String)"dd.MM.yyyy HH:mm:ss"));
            paymentEl.setAttribute("sumcur", payment.getSumcur().toString());
            paymentEl.setAttribute("sumtotal", payment.getSumtotal().toString());
            paymentEl.setAttribute("currency", this.getProtocolCurrencyTitle(payment.getRate().getProtocolCurrency(), "code"));
            paymentEl.setAttribute("price", payment.getRate().getPrice().toString());
            paymentEl.setAttribute("status", payment.getStatus().toString());
            paymentEl.setAttribute("comment", payment.getComment());
            paymentEl.setAttribute("purse", payment.getPurse());
        }
        Element date = this.createElement(this.rootNode, "date");
        date.setAttribute("year", String.valueOf(yy));
        date.setAttribute("month", String.valueOf(mm));
        int lastYear = now.get(1);
        for (int i = firstYear = manager.getFirstYear(this.cid); i <= lastYear; ++i) {
            Element yearElement = this.createElement(date, "year");
            yearElement.setAttribute("year", String.valueOf(i));
            yearElement.setAttribute("value", String.valueOf(i));
        }
        List<CurrencyRate> rateList = manager.getCurrencyRateList(new Date(), true);
        Element currenciesEl = this.createElement(this.rootNode, "currencies");
        for (CurrencyRate rate : rateList) {
            int pursePid;
            ContractDao contractDao;
            Element currencyElement = this.createElement(currenciesEl, "currency");
            currencyElement.setAttribute("id", String.valueOf(rate.getId()));
            currencyElement.setAttribute("title", this.getProtocolCurrencyTitle(rate.getProtocolCurrency(), "title"));
            currencyElement.setAttribute("code", this.getProtocolCurrencyTitle(rate.getProtocolCurrency(), "code"));
            currencyElement.setAttribute("price", rate.getPrice().toString());
            ProtocolManager protocolManager = new ProtocolManager((ParameterMap)this.moduleSetup);
            ProtocolCurrency pcurrency = protocolManager.getProtocols().get(rate.getProtocolCurrency());
            int purseMode = Utils.parseInt((String)pcurrency.getProtocolParameter("purseMode"));
            if (purseMode == 1) {
                contractDao = new ContractDao(this.con, this.userId.intValue());
                try {
                    pursePid = Utils.parseInt((String)pcurrency.getProtocolParameter("pursePid"));
                    currencyElement.setAttribute("purseInput", contractDao.getContractParameterTextAsString(this.cid, pursePid).orElse("\u041a\u043e\u0448\u0435\u043b\u0451\u043a \u043f\u0440\u043e\u043f\u0438\u0441\u044b\u0432\u0430\u0435\u0442\u0441\u044f \u0443 \u043e\u043f\u0435\u0440\u0430\u0442\u043e\u0440\u0430"));
                    continue;
                }
                finally {
                    contractDao.close();
                    continue;
                }
            }
            if (purseMode == 2) continue;
            if (purseMode == 3) {
                contractDao = new ContractDao(this.con, this.userId.intValue());
                try {
                    pursePid = Utils.parseInt((String)pcurrency.getProtocolParameter("pursePid"));
                    String purse = contractDao.getContractParameterTextAsString(this.cid, pursePid).orElse(null);
                    if (Utils.isBlankString((String)purse)) {
                        currencyElement.setAttribute("purseInputWarning", "on");
                        continue;
                    }
                    currencyElement.setAttribute("purseInput", purse);
                    continue;
                }
                finally {
                    contractDao.close();
                    continue;
                }
            }
            throw new BGException("\u041d\u0435\u0432\u0435\u0440\u043d\u043e \u0441\u043a\u043e\u043d\u0444\u0438\u0433\u0443\u0440\u0438\u0440\u043e\u0432\u0430\u043d \u043c\u043e\u0434\u0443\u043b\u044c (\u043d\u0435\u0438\u0437\u0432\u0435\u0441\u0442\u043d\u044b\u0439 'purseMode')");
        }
    }
}

