/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.modules.npay.client;

import bitel.billing.module.common.BGTextArea;
import bitel.billing.module.services.ServiceConfigTabbedPanel;
import java.awt.Color;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionListener;
import java.io.InputStream;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Enumeration;
import java.util.List;
import javax.swing.AbstractButton;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.JToggleButton;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableModel;
import org.json.JSONArray;
import org.json.JSONObject;
import ru.bitel.bgbilling.client.common.BGEditorDialog;
import ru.bitel.bgbilling.client.common.BGEditorDialogVPanel;
import ru.bitel.bgbilling.client.common.BGTextField;
import ru.bitel.bgbilling.client.common.BGUTable;
import ru.bitel.bgbilling.client.common.table.renderer.HorizontalAlignmentTableCellRenderer;
import ru.bitel.bgbilling.client.util.ClientUtils;
import ru.bitel.bgbilling.common.BGException;
import ru.bitel.bgbilling.common.model.KeyValue;
import ru.bitel.bgbilling.modules.npay.common.service.NPayService;
import ru.bitel.common.Utils;
import ru.bitel.common.client.BGSwingUtilites;
import ru.bitel.common.client.table.BGTableModel;
import ru.bitel.common.model.RowData;

public class NPayServiceConfigDebet
extends ServiceConfigTabbedPanel {
    private static final String KEY_STATUS_MANAGE = "debet.npay.status.manage";
    private static final String KEY_KEYS = "debet.npay.keys";
    private JSONObject keysJson = new JSONObject("{ \"key\": \"debet.npay.keys\", \"title\": \"\u041a\u043b\u044e\u0447\u0438 \u043a\u043e\u043d\u0444\u0438\u0433\u0443\u0440\u0430\u0446\u0438\u0439 (\u0447\u0435\u0440\u0435\u0437 \u0437\u0430\u043f\u044f\u0442\u0443\u044e)\" }");
    private ButtonGroup modeButtonGroup = new ButtonGroup();
    private JTextField debetConfigSetKey = new JTextField(50);
    private DebetTableModel debetTableModel = new DebetTableModel();

    public NPayServiceConfigDebet() {
        BGUTable table = new BGUTable((TableModel)((Object)this.debetTableModel));
        table.setSelectionMode(0);
        this.setLayout(new GridBagLayout());
        this.add(this.getTopPanel(), new GridBagConstraints(0, -1, 1, 1, 1.0, 0.0, 10, 2, new Insets(5, 5, 0, 5), 0, 0));
        this.add(new JScrollPane((Component)table), new GridBagConstraints(0, -1, 1, 1, 1.0, 1.0, 10, 1, new Insets(5, 0, 0, 0), 0, 0));
        BGSwingUtilites.handleLDMouseClicked((Component)table, e -> this.editItem());
    }

    private JPanel getTopPanel() {
        ActionListener modeActionListener = e -> this.setDebetMode();
        JToggleButton onButton = new JToggleButton("\u0412\u041a\u041b");
        onButton.setActionCommand("1");
        onButton.addActionListener(modeActionListener);
        JToggleButton offButton = new JToggleButton("\u0412\u042b\u041a\u041b", true);
        offButton.setActionCommand("0");
        offButton.addActionListener(modeActionListener);
        this.modeButtonGroup.add(onButton);
        this.modeButtonGroup.add(offButton);
        Color bgColor = this.debetConfigSetKey.getBackground();
        this.debetConfigSetKey.setHorizontalAlignment(0);
        this.debetConfigSetKey.setEditable(false);
        this.debetConfigSetKey.setBackground(bgColor);
        JButton editButton = new JButton(ClientUtils.getIcon((String)"edit"));
        editButton.addActionListener(e -> {
            new DebetKeyValueEditorDialog("\u0420\u0435\u0434\u0430\u043a\u0442\u043e\u0440 \u043f\u0430\u0440\u0430\u043c\u0435\u0442\u0440\u0430", new RowData(this.keysJson)).open();
            this.setData();
        });
        JPanel panel = new JPanel(new GridBagLayout());
        panel.add((Component)new JLabel("\u0414\u0435\u0431\u0435\u0442\u043e\u0432\u044b\u0439 \u0440\u0435\u0436\u0438\u043c: "), new GridBagConstraints(-1, 0, 1, 1, 0.0, 0.0, 10, 2, new Insets(0, 0, 0, 0), 0, 0));
        panel.add((Component)onButton, new GridBagConstraints(-1, 0, 1, 1, 0.0, 0.0, 10, 2, new Insets(0, 0, 0, 0), 0, 0));
        panel.add((Component)offButton, new GridBagConstraints(-1, 0, 1, 1, 0.0, 0.0, 10, 2, new Insets(0, 0, 0, 0), 0, 0));
        panel.add((Component)new JLabel("\u041a\u043b\u044e\u0447\u0438 \u043a\u043e\u043d\u0444\u0438\u0433\u0443\u0440\u0430\u0446\u0438\u0439 (\u0447\u0435\u0440\u0435\u0437 \u0437\u0430\u043f\u044f\u0442\u0443\u044e): "), new GridBagConstraints(-1, 0, 1, 1, 0.0, 0.0, 10, 2, new Insets(0, 30, 0, 0), 0, 0));
        panel.add((Component)this.debetConfigSetKey, new GridBagConstraints(-1, 0, 1, 1, 0.0, 0.0, 10, 2, new Insets(0, 0, 0, 0), 0, 0));
        panel.add((Component)editButton, new GridBagConstraints(-1, 0, 1, 1, 1.0, 0.0, 17, 0, new Insets(0, 5, 0, 0), 0, 0));
        return panel;
    }

    private void setDebetMode() {
        this.tryCall(() -> ((NPayService)this.getContext().getWebService(NPayService.class, this.getModuleId())).configValueUpdate(Arrays.asList(new KeyValue(KEY_STATUS_MANAGE, this.modeButtonGroup.getSelection().getActionCommand()))));
    }

    public void setData() {
        ArrayList<RowData> data = new ArrayList<RowData>();
        try {
            List keyValues = ((NPayService)this.getContext().getWebService(NPayService.class, this.getModuleId())).configValueList();
            KeyValue debetMode = keyValues.stream().filter(a -> KEY_STATUS_MANAGE.equals(a.getKey())).findFirst().orElse(null);
            if (debetMode != null) {
                Enumeration<AbstractButton> buttons = this.modeButtonGroup.getElements();
                while (buttons.hasMoreElements()) {
                    AbstractButton button = buttons.nextElement();
                    if (!button.getActionCommand().equals(debetMode.getValue())) continue;
                    button.setSelected(true);
                    break;
                }
            }
            keyValues.stream().filter(a -> KEY_KEYS.equals(a.getKey())).findFirst().ifPresent(a -> {
                this.keysJson.put("value", (Object)a.getValue());
                this.debetConfigSetKey.setText(a.getValue());
            });
            List configKeys = Utils.toList((String)this.keysJson.optString("value"));
            if (configKeys.isEmpty()) {
                configKeys.add("");
            }
            InputStream inputStream = NPayServiceConfigDebet.class.getResourceAsStream("debet.json");
            String debetJsonString = new String(Utils.readByBlock((InputStream)inputStream), StandardCharsets.UTF_8);
            for (String configKey : configKeys) {
                JSONObject debetJson = new JSONObject(debetJsonString);
                JSONArray keys = debetJson.optJSONArray("keys");
                int len = keys.length();
                for (int index = 0; index < len; ++index) {
                    JSONObject jsonObject = keys.getJSONObject(index);
                    data.add(new RowData(jsonObject));
                    String key = jsonObject.optString("key");
                    if (!configKey.isEmpty()) {
                        jsonObject.put("key", (Object)("debet.npay." + configKey + key.substring(10)));
                    }
                    if (!Utils.notBlankString((String)key)) continue;
                    jsonObject.put("value", (Object)keyValues.stream().filter(a -> a.getKey().equals(jsonObject.opt("key"))).map(a -> a.getValue()).findFirst().orElse(""));
                }
            }
        }
        catch (Exception e) {
            ClientUtils.showErrorMessageDialog((Throwable)e);
        }
        this.debetTableModel.setData(data);
    }

    public void editItem() {
        this.debetTableModel.optSelectedRow().ifPresentOrElse(data -> new DebetKeyValueEditorDialog("\u0420\u0435\u0434\u0430\u043a\u0442\u043e\u0440 \u043f\u0430\u0440\u0430\u043c\u0435\u0442\u0440\u0430", (RowData)data).open(), () -> ClientUtils.showErrorMessageDialog((String)"\u0412\u044b\u0431\u0435\u0440\u0438\u0442\u0435 \u043f\u0430\u0440\u0430\u043c\u0435\u0442\u0440"));
    }

    class DebetTableModel
    extends BGTableModel<RowData> {
        public DebetTableModel() {
            super(DebetTableModel.class.getName());
        }

        protected void initColumns() {
            this.addColumn("\u041a\u043b\u044e\u0447", 300, 300, 300, "key", true, (TableCellRenderer)HorizontalAlignmentTableCellRenderer.LEFT());
            this.addColumn("\u041f\u0430\u0440\u0430\u043c\u0435\u0442\u0440", 300, -1, -1, "title", true, (TableCellRenderer)HorizontalAlignmentTableCellRenderer.LEFT());
            this.addColumn("\u0417\u043d\u0430\u0447\u0435\u043d\u0438\u0435", 300, -1, 300, "value", true, (TableCellRenderer)HorizontalAlignmentTableCellRenderer.LEFT());
        }

        public Object getValue(RowData val, int column) throws BGException {
            return val.getJson().optString(this.getIdentifier(column));
        }
    }

    class DebetKeyValueEditorDialog
    extends BGEditorDialog<RowData> {
        private BGTextField key;
        private BGTextArea title;
        private BGTextField value;

        public DebetKeyValueEditorDialog(String title, RowData data) {
            super(title, (Object)data);
            this.key = new BGTextField(40);
            this.title = new BGTextArea(3, 40);
            this.value = new BGTextField(40);
        }

        public void doDialogPanel() {
            Color bgColor = this.key.getBackground();
            this.key.setEditable(false);
            this.key.setBackground(bgColor);
            this.title.setEditable(false);
            this.title.setBackground(bgColor);
            this.value.setHorizontalAlignment(0);
            GridBagConstraints gridBagConstraints = new GridBagConstraints(0, -1, 1, 1, 1.0, 1.0, 10, 1, new Insets(5, 0, 0, 0), 0, 0);
            this.panel.add((Component)new BGEditorDialogVPanel("\u041a\u043b\u044e\u0447", (Component)this.key), gridBagConstraints);
            this.panel.add((Component)new BGEditorDialogVPanel("\u041e\u043f\u0438\u0441\u0430\u043d\u0438\u0435", (Component)new JScrollPane((Component)this.title)), gridBagConstraints);
            this.panel.add((Component)new BGEditorDialogVPanel("\u0417\u043d\u0430\u0447\u0435\u043d\u0438\u0435", (Component)this.value), gridBagConstraints);
            this.key.setText(((RowData)this.data).getJson().optString("key"));
            this.title.setText(((RowData)this.data).getJson().optString("title"));
            this.value.setText(((RowData)this.data).getJson().optString("value"));
        }

        public boolean doApply() throws Exception {
            ((NPayService)NPayServiceConfigDebet.this.getContext().getWebService(NPayService.class, NPayServiceConfigDebet.this.getModuleId())).configValueUpdate(Arrays.asList(new KeyValue(this.key.getText(), this.value.getText())));
            ((RowData)this.data).getJson().put("value", (Object)this.value.getText());
            NPayServiceConfigDebet.this.debetTableModel.fireTableDataChanged();
            return true;
        }
    }
}

