/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.modules.ipn.common;

import java.util.StringTokenizer;
import ru.bitel.common.Utils;

public class CiscoRuleOptions {
    public static final String START_PARAMS = "$PARAMS$";
    public static final String ACL_KEY = "ACL";
    public static final String FROM_POS_KEY = "FROM_POS";
    public int aclId;
    public int fromPos;

    public static final CiscoRuleOptions extractParams(String rule) {
        CiscoRuleOptions result = new CiscoRuleOptions();
        int pos = rule.indexOf(START_PARAMS);
        if (pos >= 0) {
            String paramsBlock = rule.substring(pos + START_PARAMS.length());
            StringTokenizer st = new StringTokenizer(paramsBlock, ";");
            while (st.hasMoreTokens()) {
                String token = st.nextToken();
                String[] pair = token.split(":");
                if (pair.length != 2) continue;
                if (pair[0].equals(ACL_KEY)) {
                    result.aclId = Utils.parseInt((String)pair[1], (int)0);
                    continue;
                }
                if (!pair[0].equals(FROM_POS_KEY)) continue;
                result.fromPos = Utils.parseInt((String)pair[1].trim(), (int)0);
            }
        }
        return result;
    }

    public static final String addParams(String rule, CiscoRuleOptions options) {
        StringBuilder result = new StringBuilder(rule);
        result.append(START_PARAMS);
        result.append(ACL_KEY);
        result.append(":");
        result.append(options.aclId);
        result.append(";");
        result.append(FROM_POS_KEY);
        result.append(":");
        result.append(options.fromPos);
        return result.toString();
    }

    public static final String clearFromParams(String rule) {
        int pos = rule.indexOf(START_PARAMS);
        if (pos > 0) {
            rule = rule.substring(0, pos);
        }
        return rule;
    }
}

