/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.modules.sorm.server.upload;

import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.List;
import org.apache.commons.net.ftp.FTPClient;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import ru.bitel.bgbilling.common.BGException;
import ru.bitel.bgbilling.common.BGMessageException;
import ru.bitel.bgbilling.modules.sorm.server.upload.Upload;
import ru.bitel.bgbilling.modules.sorm.server.upload.UploadFiles;
import ru.bitel.bgbilling.modules.sorm.server.upload.norsitrans.NorsiTransFileTitle;
import ru.bitel.bgbilling.modules.sorm.server.upload.norsitrans.NorsiTransUpload;
import ru.bitel.bgbilling.modules.sorm.server.upload.signaltek.SignaltekFileTitle;
import ru.bitel.bgbilling.modules.sorm.server.upload.signaltek.SignaltekUpload;
import ru.bitel.bgbilling.modules.sorm.server.upload.vasexpert.VasexpertFileTitle;
import ru.bitel.bgbilling.modules.sorm.server.upload.vasexpert.VasexpertUpload;
import ru.bitel.bgbilling.modules.sorm.server.upload.vasexpertV3.VasexpertV3FileTitle;
import ru.bitel.bgbilling.modules.sorm.server.upload.vasexpertV3.VasexpertV3Upload;
import ru.bitel.bgbilling.modules.sorm.server.utils.SormUtils;
import ru.bitel.bgbilling.server.util.ServerUtils;
import ru.bitel.bgbilling.server.util.Setup;
import ru.bitel.common.Preferences;
import ru.bitel.common.Utils;

public class UploadToFTP {
    private final Logger logger = LogManager.getLogger();

    public UploadToFTP(UploadFiles uploadFiles, Preferences config, Upload versionUpload) throws BGException {
        this.startUpload(this.getFTPConnect(config), uploadFiles, versionUpload, config);
    }

    private FTPClient getFTPConnect(Preferences config) throws BGException {
        String login = config.get("sorm.ftp.login");
        String password = config.get("sorm.ftp.password");
        String host = config.get("sorm.ftp.host");
        String port = config.get("sorm.ftp.port");
        if (Utils.isBlankString((String)login) || Utils.isBlankString((String)password) || Utils.isBlankString((String)host)) {
            throw new BGMessageException("\u041e\u0442\u0441\u0443\u0442\u0441\u0442\u0432\u0443\u044e\u0442 \u043e\u0431\u044f\u0437\u0430\u0442\u0435\u043b\u044c\u043d\u044b\u0435 \u043f\u043e\u043b\u044f \u0434\u043b\u044f \u043f\u043e\u0434\u043a\u043b\u044e\u0447\u0435\u043d\u0438\u044f \u043a FTP");
        }
        FTPClient ftpClient = new FTPClient();
        try {
            int timeout = 7000;
            ftpClient.setConnectTimeout(timeout);
            ftpClient.setDataTimeout(timeout);
            ftpClient.setDefaultTimeout(timeout);
            ftpClient.connect(host, Utils.parseInt((String)port, (int)21));
            ftpClient.setSoTimeout(timeout);
            int mode = Utils.parseInt((String)config.get("sorm.ftp.mode"), (int)0);
            if (mode == 1) {
                ftpClient.enterLocalActiveMode();
            } else {
                ftpClient.enterLocalPassiveMode();
            }
            ftpClient.login(login, password);
            ftpClient.setFileType(2);
        }
        catch (IOException ex) {
            String text = "\u041e\u0448\u0438\u0431\u043a\u0430 \u043f\u0440\u0438 \u0443\u0441\u0442\u0430\u043d\u043e\u0432\u043a\u0438 \u0441\u043e\u0435\u0434\u0438\u043d\u0435\u043d\u0438\u044f \u0441 FTP \u0441\u0435\u0440\u0432\u0435\u0440\u043e\u043c \u0421\u041e\u0420\u041c: " + ex.getMessage() + "\n \u041b\u043e\u0433\u0438\u043d: " + login + " \u0425\u043e\u0441\u0442: " + host + " \u041f\u043e\u0440\u0442: " + port;
            this.logger.error(text);
            SormUtils.sendErrorToEmail(Setup.getSetup(), ex, text);
            throw new BGException(text);
        }
        return ftpClient;
    }

    private void startUpload(FTPClient ftpConnect, UploadFiles uploadFiles, Upload versionUpload, Preferences config) throws BGException {
        try {
            List<Path> files = uploadFiles.getFiles();
            for (Path file : files) {
                this.logger.info("\u0412\u044b\u0433\u0440\u0443\u0437\u043a\u0430 \u043d\u0430 FTP \u0444\u0430\u0439\u043b\u0430: " + file.getFileName());
                String pathOnFTP = uploadFiles.getPath(file);
                if (Utils.isBlankString((String)pathOnFTP)) {
                    pathOnFTP = config.get("sorm.ftp.catalog");
                }
                if (Utils.isBlankString((String)pathOnFTP)) {
                    pathOnFTP = this.getPathForFileOnFTP(file, versionUpload);
                }
                ServerUtils.createDirectoriesOnFTP((FTPClient)ftpConnect, (String)pathOnFTP);
                if (this.logger.isDebugEnabled()) {
                    this.logger.debug("\u0414\u0438\u0440\u0435\u043a\u0442\u043e\u0440\u0438\u044f \u043d\u0430 FTP \u0434\u043b\u044f \u0444\u0430\u0439\u043b\u0430: " + pathOnFTP);
                }
                InputStream is = Files.newInputStream(file, new OpenOption[0]);
                try {
                    boolean result = ftpConnect.storeFile(file.getFileName().toString(), is);
                    this.logger.debug(String.format("\u0424\u0430\u0439\u043b=%s, \u0440\u0435\u0437\u0443\u043b\u044c\u0442\u0430\u0442 \u043f\u0435\u0440\u0435\u0434\u0430\u0447\u0438 \u043d\u0430 FTP=%s", file, result));
                }
                finally {
                    if (is == null) continue;
                    is.close();
                }
            }
            ftpConnect.logout();
        }
        catch (IOException ex) {
            String text = "\u041e\u0448\u0438\u0431\u043a\u0430 \u043f\u0440\u0438 \u0432\u044b\u0433\u0440\u0443\u0437\u043a\u0435 \u0444\u0430\u0439\u043b\u043e\u0432 \u043d\u0430 FTP \u0441\u0435\u0440\u0432\u0435\u0440 \u0421\u041e\u0420\u041c";
            this.logger.error(text, (Throwable)ex);
            throw new BGException(text);
        }
        finally {
            try {
                if (ftpConnect != null && ftpConnect.isConnected()) {
                    ftpConnect.disconnect();
                }
            }
            catch (IOException ex) {
                this.logger.error((Object)ex);
            }
        }
    }

    private String getPathForFileOnFTP(Path uploadFile, Upload versionUpload) {
        String fileName = uploadFile.getFileName().toString();
        String fileTitle = fileName.contains("_") ? fileName.substring(0, fileName.lastIndexOf("_")) : fileName;
        String pathToFile = null;
        if (versionUpload instanceof NorsiTransUpload) {
            pathToFile = NorsiTransFileTitle.getFTPDirectory(fileTitle);
        } else if (versionUpload instanceof VasexpertV3Upload) {
            pathToFile = VasexpertV3FileTitle.getFTPDirectory(fileTitle);
        } else if (versionUpload instanceof VasexpertUpload) {
            pathToFile = VasexpertFileTitle.getFTPDirectory(fileTitle);
        } else if (versionUpload instanceof SignaltekUpload) {
            pathToFile = SignaltekFileTitle.getFTPDirectory(fileTitle);
        }
        return Utils.isBlankString((String)pathToFile) ? "/" : pathToFile;
    }
}

