<?xml version="1.0" encoding="UTF-8"?>
<xsl:stylesheet version="1.0"
      xmlns:xsl="http://www.w3.org/1999/XSL/Transform"
      xmlns:fo="http://www.w3.org/1999/XSL/Format">
  <xsl:output method="xml" indent="yes"/>
  <xsl:template match="data">
  	
    <fo:root>
      <fo:layout-master-set>
        <fo:simple-page-master master-name="A4-portrait"
              page-height="10cm" page-width="10.0cm" margin="0.5cm">
          <fo:region-body/>
        </fo:simple-page-master>
      </fo:layout-master-set>
      <fo:page-sequence master-reference="A4-portrait">
        <fo:flow flow-name="xsl-region-body">
          <fo:block text-align="center"><xsl:value-of select="@org_header"/></fo:block>
		  <fo:block text-align="center"><xsl:value-of select="@org_inn"/></fo:block>
		  <fo:block text-align="center"><xsl:value-of select="@org_address"/></fo:block>
		  <fo:block text-align="center"><xsl:value-of select="@org_phone"/></fo:block>

		  <fo:block text-align="center" 
		  			padding-top="10pt" 
		  			padding-bottom="10pt"><xsl:value-of select="@title"/></fo:block>

          <fo:table>
            <fo:table-column text-align="center"/>
			<fo:table-column text-align="center"/>
				
            <fo:table-body>
                <fo:table-row>
                  	<fo:table-cell>
                        <fo:block>Платеж №</fo:block>
                    </fo:table-cell>
                    <fo:table-cell>
                        <fo:block font-weight="bold"><xsl:value-of select="@trans_id"/></fo:block>
                    </fo:table-cell>
				</fo:table-row>
				
				<fo:table-row>
                  	<fo:table-cell>
                        <fo:block>Дата платежа</fo:block>
                    </fo:table-cell>
                    <fo:table-cell>
                        <fo:block><xsl:value-of select="@date"/></fo:block>
                    </fo:table-cell>
				</fo:table-row>
				
				<fo:table-row>
                  	<fo:table-cell>
                        <fo:block>Время платежа</fo:block>
                    </fo:table-cell>
                    <fo:table-cell>
                        <fo:block><xsl:value-of select="@time"/></fo:block>
                    </fo:table-cell>
				</fo:table-row>
				
				<fo:table-row>
                  	<fo:table-cell>
                        <fo:block>Код авторизации</fo:block>
                    </fo:table-cell>
                    <fo:table-cell>
                        <fo:block><xsl:value-of select="@order_id"/></fo:block>
                    </fo:table-cell>
				</fo:table-row>
				
				<fo:table-row>
                  	<fo:table-cell>
                        <fo:block>Договор №</fo:block>
                    </fo:table-cell>
                    <fo:table-cell>
                        <fo:block font-weight="bold"><xsl:value-of select="@contract"/></fo:block>
                    </fo:table-cell>
				</fo:table-row>
				
				<fo:table-row>
                  	<fo:table-cell>
                        <fo:block padding-top="10pt" font-size="15pt">Сумма платежа</fo:block>
                    </fo:table-cell>
                    <fo:table-cell>
                        <fo:block font-weight="bold" padding-top="10pt" font-size="15pt"><xsl:value-of select="@summa"/></fo:block>
                    </fo:table-cell>
				</fo:table-row>
            </fo:table-body>
          </fo:table>
        </fo:flow>
      </fo:page-sequence>
    </fo:root>
  </xsl:template>
</xsl:stylesheet>