/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.kernel.contract.autopayment.client;

import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.util.Calendar;
import java.util.GregorianCalendar;
import javax.swing.JScrollPane;
import javax.swing.border.Border;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableModel;
import ru.bitel.bgbilling.client.common.BGControlPanelPages;
import ru.bitel.bgbilling.client.common.BGTitleBorder;
import ru.bitel.bgbilling.client.common.BGUPanel;
import ru.bitel.bgbilling.client.common.BGUTable;
import ru.bitel.bgbilling.client.common.ClientContext;
import ru.bitel.bgbilling.client.common.table.renderer.DecimalTableCellRenderer;
import ru.bitel.bgbilling.client.common.table.renderer.HorizontalAlignmentTableCellRenderer;
import ru.bitel.bgbilling.kernel.contract.autopayment.client.ContractAutopaymentMethods;
import ru.bitel.bgbilling.kernel.contract.autopayment.common.bean.Autopayment;
import ru.bitel.bgbilling.kernel.contract.autopayment.common.bean.AutopaymentMode;
import ru.bitel.common.TimeUtils;
import ru.bitel.common.Utils;
import ru.bitel.common.client.AbstractBGUPanel;
import ru.bitel.common.client.table.BGTableModel;
import ru.bitel.common.model.SearchResult;

public class ContractAutopaymantLogPanel
extends BGUPanel {
    private ContractAutopaymentMethods contractAutopaymentMethods = null;
    private BGControlPanelPages pagePanel = new BGControlPanelPages();
    private ModeLogTableModel modeLogTableModel = new ModeLogTableModel();
    private BGUTable modeLogTable = new BGUTable((TableModel)((Object)this.modeLogTableModel));

    public ContractAutopaymantLogPanel(ContractAutopaymentMethods contractAutopaymentMenhods) {
        this.contractAutopaymentMethods = contractAutopaymentMenhods;
    }

    protected void jbInit() throws Exception {
        this.pagePanel.addPropertyChangeListener(e -> this.performAction("refresh"));
        this.setLayout(new GridBagLayout());
        this.setBorder((Border)new BGTitleBorder("\u0418\u0441\u0442\u043e\u0440\u0438\u044f \u0438\u0437\u043c\u0435\u043d\u0435\u043d\u0438\u0439 \u0440\u0435\u0436\u0438\u043c\u0430"));
        this.add((Component)this.pagePanel, new GridBagConstraints(0, 0, 1, 1, 1.0, 0.0, 13, 0, new Insets(0, 5, 5, 5), 0, 0));
        this.add(new JScrollPane((Component)this.modeLogTable), new GridBagConstraints(0, 1, 1, 1, 1.0, 1.0, 10, 1, new Insets(0, 5, 5, 5), 0, 0));
    }

    protected void initActions() {
        new AbstractBGUPanel.BGActionRefresh((AbstractBGUPanel)this, e -> {
            SearchResult<Autopayment> searchResult = this.contractAutopaymentMethods.searchAutopaymentList(((ClientContext)this.getContext()).getContractId(), this.pagePanel.getPage());
            if (searchResult != null) {
                this.pagePanel.setPage(searchResult.getPage());
                this.modeLogTableModel.setData(searchResult.getList());
            }
        });
    }

    class ModeLogTableModel
    extends BGTableModel<Autopayment> {
        private int weekDay;
        private int monthDay;

        public ModeLogTableModel() {
            super(ModeLogTableModel.class.getName());
        }

        protected void initColumns() {
            this.addColumnId();
            this.addColumn("\u041f\u0435\u0440\u0438\u043e\u0434", 300, 300, 300, "period", true, (TableCellRenderer)HorizontalAlignmentTableCellRenderer.CENTER());
            this.addColumn("\u0420\u0435\u0436\u0438\u043c", 200, 200, -1, "mode", true, (TableCellRenderer)HorizontalAlignmentTableCellRenderer.CENTER());
            this.addColumn("\u0414\u0435\u043d\u044c", 100, 100, 100, "modeDay", false, (TableCellRenderer)HorizontalAlignmentTableCellRenderer.RIGHT());
            this.addColumn("\u0421\u0443\u043c\u043c\u0430", 100, 100, 100, "sum", true, (TableCellRenderer)DecimalTableCellRenderer.DEFAULT());
            this.addColumn("BindingId", 200, 200, -1, "accessToken", true, (TableCellRenderer)HorizontalAlignmentTableCellRenderer.CENTER());
        }

        public Object getValue(Autopayment value, int column) throws Exception {
            String identifier = this.getIdentifier(column);
            if ("modeDay".equals(identifier)) {
                if (value.getMode().getCode() == AutopaymentMode.WEEK.getCode()) {
                    int day = Utils.parseInt((String)this.getParameter(value.getModeData(), "autopayment.mode.week.day"), (int)this.weekDay);
                    GregorianCalendar calendar = new GregorianCalendar();
                    calendar.set(7, day);
                    return TimeUtils.format((Calendar)calendar, (String)"EEEE");
                }
                if (value.getMode().getCode() == AutopaymentMode.MONTH.getCode()) {
                    return Utils.parseInt((String)this.getParameter(value.getModeData(), "autopayment.mode.month.day"), (int)this.monthDay);
                }
                return "";
            }
            return super.getValue((Object)value, column);
        }

        protected String getParameter(String parameters, String key) {
            String value = "";
            if (parameters != null) {
                for (String pair : parameters.split("\n")) {
                    if (!pair.startsWith(key)) continue;
                    value = pair.substring(key.length() + 1).trim();
                    break;
                }
            }
            return value;
        }

        public void setWeekDay(int weekDay) {
            this.weekDay = weekDay;
        }

        public void setMonthDay(int monthDay) {
            this.monthDay = monthDay;
        }
    }
}

