<?xml version="1.0" encoding="UTF-8"?>

<xsl:stylesheet
	xmlns:xsl="http://www.w3.org/1999/XSL/Transform"
	version="1.0">

<xsl:output method="html" encoding="UTF-8" indent="yes"/>

<xsl:template match="/">
   <html>
   <head>
   <meta http-equiv="content-type" content="text/html; charset=UTF-8" />
   </head>
    <body>
   <center>
     <xsl:call-template name="head"/><br/>
		<xsl:for-each select="/data/table">
			<xsl:choose>
				<xsl:when test="@type = 1"><xsl:call-template name="table_point"/>
				</xsl:when>
				<xsl:otherwise><xsl:call-template name="table_rule"/>
				</xsl:otherwise>
			</xsl:choose>
		</xsl:for-each>
		<br/>
     <xsl:call-template name="sums"/>
   </center>
    </body>
    </html>
</xsl:template>

<xsl:template name="head">
    <xsl:for-each select="/data/table">
         <h2><xsl:value-of select="@reportTitle"/><br/>
         Контракт:&#160;<xsl:value-of select="@contractTitle"/>(<xsl:value-of select="@comment"/>)
         </h2>
         Период с: <xsl:value-of select="@date1"/> по <xsl:value-of select="@date2"/>
    </xsl:for-each>
</xsl:template>

<xsl:template name="table_point">
<table width="100%" border="1" cellspacing="0" cellpadding="3">
     <tr bgcolor="#f0f0f0">
         <td>Пойнт</td>
         <td>Количество сессий</td>
         <td>Время[в секундах]</td>
         <td>Время окр.[в секундах]</td>
         <td>Сумма</td>
     </tr>
     <xsl:for-each select="/data/table/data/row">
         <tr bgcolor="#ffffff">
             <td><xsl:value-of select="@item"/></td>
             <td><xsl:value-of select="@number"/></td>
             <td><xsl:value-of select="@time"/></td>
             <td><xsl:value-of select="@time_round"/></td>
             <td><xsl:value-of select="@cost"/></td>
         </tr>
     </xsl:for-each>
</table>
</xsl:template>

<xsl:template name="table_rule">
<table width="100%" border="1" cellspacing="0" cellpadding="3">
     <tr bgcolor="#f0f0f0">
         <td>Правило</td>
         <td>Количество сессий</td>
         <td>Время[в секундах]</td>
         <td>Сумма</td>
     </tr>
     <xsl:for-each select="/data/table/data/row">
         <tr bgcolor="#ffffff">
             <td><xsl:value-of select="@item"/></td>
             <td><xsl:value-of select="@number"/></td>
             <td><xsl:value-of select="@time"/></td>
             <td><xsl:value-of select="@cost"/></td>
         </tr>
     </xsl:for-each>
</table>
</xsl:template>

<xsl:template name="sums">
    Итого [в секундах]:&#160;<xsl:value-of select="/data/table/@total_time"/>&#160;
    Итого окр. [в секундах]:&#160;<xsl:value-of select="/data/table/@total_time_round"/>&#160;
    Итого [в рублях]:&#160;<xsl:value-of select="/data/table/@total_cost"/>&#160;
</xsl:template>

</xsl:stylesheet>
