package ru.bitel.bgbilling.modules.tv.dyn.lfstrm;

import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.json.JSONObject;
import ru.bitel.common.Utils;

import jakarta.servlet.http.HttpServletRequest;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.util.Arrays;
import java.util.List;

public class LifeStreamRequestParser
{
    private static final Logger logger = LogManager.getLogger();

    private boolean isUpsaleV3;
    private int moduleId;
    private String accountId;
    // ИНТЕГРАЦИОННЫЕ id продукта. Т.е. по нему надо найти еще у нас наш id продукта
    private String oldProductId;
    private String newProductId;

    //параметры только для upsale v3
    private String login;
    private String trialDays;
    private String qsTransactionId;

    // если true - add-subscription, false - replace-subscription
    private boolean isAddSubscription = false;
    // если commit - запрос на смену подписки, если ensure - то запрос возможности подписки
    private boolean isCommit = false;

    public LifeStreamRequestParser( int moduleId, String[] path, HttpServletRequest request )
    throws IOException
    {
        this.moduleId = moduleId;
        this.isUpsaleV3 = path.length > 5 && path[5].equals( "v3" );
        if( isUpsaleV3 )
            upsaleV3ParseProcessing( path, request );
        else
            defaultParseProcessing( request );
    }

    private void upsaleV3ParseProcessing( String[] path, HttpServletRequest request )
    {
        logger.debug( "PathInfo: " + Arrays.toString( path) );

        List<String> pathParts = Arrays.asList( path );
        this.isAddSubscription = pathParts.contains( "add-subscription" );
        this.isCommit = pathParts.contains( "commit" );

        // ID аккаунта на стороне ТВ-платформы
        this.accountId = request.getParameter( "accountId" );
        // Логин абонента
        this.login = request.getParameter( "accountLogin" );
        //интеграционный id подключаемого продукта
        this.newProductId = request.getParameter( "newOfferId" );
        //в случае, аесли это смена подписки на другой продукт, то здесь интеграциооный id уже активного продукта
        this.oldProductId = request.getParameter( "oldOfferId" );
        // Целое число суток для бесплатного пробного периода
        this.trialDays = request.getParameter( "trialDays" );
        // ID процесса на стороне ТВ-платформы
        this.qsTransactionId = request.getParameter( "qsTransactionId" );

        logger.debug( "RequestParameters: " + String.format( "%s, %s, %s, %s, %s",
                                                             accountId, login, newProductId,
                                                             trialDays, qsTransactionId,
                                                             isAddSubscription ? "isAddSubscription" : "replaceSubscription",
                                                             isCommit ? "isCommit" : "ensure" ) );
    }

    private void defaultParseProcessing( HttpServletRequest request )
    throws IOException
    {
        JSONObject requestJson = new JSONObject( new String( Utils.readByBlock( request.getInputStream() ), StandardCharsets.UTF_8 ) );
        this.accountId = requestJson.optString( "id" );
        this.newProductId = requestJson.optString( "offerId" );
    }

    public String getAccountId()
    {
        return accountId;
    }

    public String getLogin()
    {
        return login;
    }

    public String getOldProductId()
    {
        return oldProductId;
    }

    public String getNewProductId()
    {
        return newProductId;
    }

    public String getTrialDays()
    {
        return trialDays;
    }

    public String getQsTransactionId()
    {
        return qsTransactionId;
    }

    public boolean isAddSubscription()
    {
        return isAddSubscription;
    }

    public boolean isCommit()
    {
        return isCommit;
    }

    public int getModuleId()
    {
        return moduleId;
    }

    public boolean isUpsaleV3()
    {
        return isUpsaleV3;
    }
}