/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.client.common.list.renderer;

import java.awt.Color;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import javax.swing.BorderFactory;
import javax.swing.DefaultListCellRenderer;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.border.Border;
import ru.bitel.common.model.IdTitle;

public class TitleIdListCellRenderer
extends DefaultListCellRenderer {
    @Override
    public Component getListCellRendererComponent(JList<?> list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
        Border border = BorderFactory.createEmptyBorder(1, 5, 1, 5);
        JLabel component = (JLabel)super.getListCellRendererComponent(list, value, index, isSelected, cellHasFocus);
        component.setBorder(border);
        component.setFont(component.getFont().deriveFont(1, component.getFont().getSize2D() * 1.25f));
        JLabel idLabel = null;
        if (value instanceof IdTitle) {
            idLabel = new JLabel("#" + ((IdTitle)value).getId());
            idLabel.setBorder(BorderFactory.createEmptyBorder(1, 10, 1, 5));
            idLabel.setBackground(component.getBackground());
            idLabel.setForeground(Color.LIGHT_GRAY);
            idLabel.setFont(idLabel.getFont().deriveFont(2, idLabel.getFont().getSize2D() * 0.9f));
            idLabel.setOpaque(true);
            component.setText(((IdTitle)value).getGuiTitle());
        }
        JPanel panel = new JPanel(new GridBagLayout());
        panel.add((Component)component, new GridBagConstraints(-1, 0, 1, 1, 1.0, 0.0, 10, 2, new Insets(0, 0, 0, 0), 0, 0));
        if (idLabel != null) {
            panel.add((Component)idLabel, new GridBagConstraints(-1, 0, 1, 1, 0.0, 0.0, 10, 3, new Insets(0, 0, 0, 0), 0, 0));
        }
        panel.setOpaque(false);
        return panel;
    }
}

