/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.modules.voice.client.directory.costmap;

import au.com.bytecode.opencsv.CSVWriter;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.io.File;
import java.io.FileOutputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import javax.swing.ButtonGroup;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import ru.bitel.bgbilling.client.common.BGButton;
import ru.bitel.bgbilling.client.common.BGFileChooser;
import ru.bitel.bgbilling.client.common.BGTextField;
import ru.bitel.bgbilling.client.common.BGToolTip;
import ru.bitel.bgbilling.client.common.BGUPanel;
import ru.bitel.bgbilling.modules.voice.client.directory.costmap.VoiceCostMapEditorForm;
import ru.bitel.bgbilling.modules.voice.common.bean.VoiceCostMapItem;
import ru.bitel.common.TimeUtils;
import ru.bitel.common.Utils;
import ru.bitel.common.client.AbstractBGUPanel;
import ru.bitel.common.client.BGButtonPanel;

public class VoiceCostMapExportPanel
extends BGUPanel {
    private VoiceCostMapEditorForm parentPanel;
    private BGButton chooseFileButton;
    private BGTextField fileNameTextField;
    private JRadioButton onlySelectedItemsMode;
    private JRadioButton selectedItemSubTreeMode;
    private JRadioButton allItemMode;
    private BGButtonPanel buttonPanel = new BGButtonPanel(new BGButtonPanel.ButtonItem[]{new BGButtonPanel.ButtonItem("\u042d\u043a\u0441\u043f\u043e\u0440\u0442", "export"), BGButtonPanel.CLOSE});
    private File exportFile;

    public VoiceCostMapExportPanel(VoiceCostMapEditorForm parent) {
        super((LayoutManager)new GridBagLayout());
        this.parentPanel = parent;
    }

    protected void jbInit() throws Exception {
        this.fileNameTextField = new BGTextField();
        this.chooseFileButton = new BGButton("...");
        this.onlySelectedItemsMode = new JRadioButton("\u0412\u044b\u0433\u0440\u0443\u0436\u0430\u0442\u044c \u0442\u043e\u043b\u044c\u043a\u043e \u0432\u044b\u0431\u0440\u0430\u043d\u043d\u044b\u0435 \u044d\u043b\u0435\u043c\u0435\u043d\u0442\u044b");
        this.selectedItemSubTreeMode = new JRadioButton("\u0412\u044b\u0433\u0440\u0443\u0436\u0430\u0442\u044c \u0432\u044b\u0431\u0440\u0430\u043d\u043d\u044b\u0435 + \u043f\u043e\u0434\u0434\u0435\u0440\u0435\u0432\u044c\u044f");
        this.allItemMode = new JRadioButton("\u0412\u044b\u0433\u0440\u0443\u0437\u0438\u0442\u044c \u0432\u0441\u0435 \u0434\u0435\u0440\u0435\u0432\u043e");
        ButtonGroup group = new ButtonGroup();
        group.add(this.onlySelectedItemsMode);
        group.add(this.selectedItemSubTreeMode);
        group.add(this.allItemMode);
        this.allItemMode.setSelected(true);
        this.fileNameTextField.setPromptText("\u0412\u044b\u0431\u0435\u0440\u0438\u0442\u0435 \u0444\u0430\u0439\u043b, \u0432 \u043a\u043e\u0442\u043e\u0440\u044b\u0439 \u0431\u0443\u0434\u0443\u0442 \u044d\u043a\u0441\u043f\u043e\u0440\u0442\u0438\u0440\u043e\u0432\u0430\u043d\u044b \u044d\u043b\u0435\u043c\u0435\u043d\u0442\u044b \u043a\u0430\u0440\u0442\u044b \u0446\u0435\u043d, \u0441 \u043f\u043e\u043c\u043e\u0449\u044c\u044e \u043a\u043d\u043e\u043f\u043a\u0438 '...' \u0441\u043f\u0440\u0430\u0432\u0430.");
        this.fileNameTextField.setEditable(false);
        this.buttonPanel.getButton("export").setEnabled(false);
        JPanel filePanel = new JPanel(new GridBagLayout());
        filePanel.add((Component)new JLabel("\u0412\u044b\u0431\u0435\u0440\u0438\u0442\u0435 \u0444\u0430\u0439\u043b \u043d\u0430\u0437\u043d\u0430\u0447\u0435\u043d\u0438\u044f"), new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(3, 3, 3, 3), 0, 0));
        filePanel.add((Component)this.fileNameTextField, new GridBagConstraints(1, 0, 1, 1, 1.0, 0.0, 17, 2, new Insets(3, 0, 3, 3), 0, 0));
        filePanel.add((Component)this.chooseFileButton, new GridBagConstraints(2, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(3, 0, 3, 3), 0, 0));
        JPanel radioPanel = new JPanel(new GridBagLayout());
        radioPanel.add((Component)this.onlySelectedItemsMode, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 3, 3, 3), 0, 0));
        radioPanel.add((Component)this.selectedItemSubTreeMode, new GridBagConstraints(1, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 0, 3, 3), 0, 0));
        radioPanel.add((Component)this.allItemMode, new GridBagConstraints(2, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 0, 3, 3), 0, 0));
        this.add(filePanel, new GridBagConstraints(0, 0, 1, 1, 1.0, 0.0, 17, 2, new Insets(0, 0, 0, 0), 0, 0));
        this.add(radioPanel, new GridBagConstraints(0, 1, 1, 1, 1.0, 0.0, 17, 0, new Insets(0, 0, 0, 0), 0, 0));
        this.add((Component)this.buttonPanel, new GridBagConstraints(0, 10, 1, 1, 1.0, 0.0, 13, 0, new Insets(0, 0, 3, 3), 0, 0));
        this.buttonPanel.addActionListener(l -> this.performAction(l.getActionCommand()));
        this.chooseFileButton.addActionListener(e -> {
            BGFileChooser chooser = new BGFileChooser((Component)this.chooseFileButton);
            if (chooser.showOpenDialog((Component)this.chooseFileButton) == 0) {
                this.exportFile = chooser.getSelectedFile();
                this.fileNameTextField.setText(this.exportFile.getPath());
            }
        });
        this.fileNameTextField.getDocument().addDocumentListener(new DocumentListener(){

            @Override
            public void removeUpdate(DocumentEvent e) {
                this.processContent(e);
            }

            @Override
            public void insertUpdate(DocumentEvent e) {
                this.processContent(e);
            }

            @Override
            public void changedUpdate(DocumentEvent e) {
                this.processContent(e);
            }

            private void processContent(DocumentEvent e) {
                VoiceCostMapExportPanel.this.buttonPanel.getButton("export").setEnabled(e.getDocument().getLength() > 0);
            }
        });
    }

    protected void initActions() {
        new AbstractBGUPanel.DefaultAction("export", "\u042d\u043a\u0441\u043f\u043e\u0440\u0442"){

            public void actionPerformedImpl(ActionEvent e) throws Exception {
                List costMapItemsForExport = new ArrayList();
                if (VoiceCostMapExportPanel.this.onlySelectedItemsMode.isSelected()) {
                    costMapItemsForExport = VoiceCostMapExportPanel.this.parentPanel.getCostMapItemTableModel().getSelectedRows();
                } else if (VoiceCostMapExportPanel.this.selectedItemSubTreeMode.isSelected()) {
                    List subtreesRootList = VoiceCostMapExportPanel.this.parentPanel.getCostMapItemTableModel().getSelectedRows();
                    if (!subtreesRootList.isEmpty()) {
                        for (VoiceCostMapItem costMapItem : subtreesRootList) {
                            costMapItemsForExport.addAll(costMapItem.toList());
                        }
                    }
                } else {
                    VoiceCostMapItem root = (VoiceCostMapItem)VoiceCostMapExportPanel.this.parentPanel.getCostMapItemTableModel().getRoot();
                    costMapItemsForExport = root.toList();
                }
                if (costMapItemsForExport.isEmpty()) {
                    BGToolTip.showErrorMessage((JComponent)VoiceCostMapExportPanel.this.buttonPanel.getButton("export"), (String)"\u041d\u0435\u043e\u0431\u0445\u043e\u0434\u0438\u043c\u043e \u0432\u044b\u0431\u0440\u0430\u0442\u044c \u0433\u0435\u043e\u0433\u0440\u0430\u0444\u0438\u0447\u0435\u0441\u043a\u0438\u0435 \u043a\u043e\u0434\u044b \u0432 \u0434\u0435\u0440\u0435\u0432\u0435!", (int)5000);
                    return;
                }
                ArrayList<String[]> costMapItems = new ArrayList<String[]>(costMapItemsForExport.size());
                for (VoiceCostMapItem costMapItem : costMapItemsForExport) {
                    String[] item = new String[]{costMapItem.getCode(), costMapItem.getDestinationTitle(), Utils.maskBlank((String)TimeUtils.formatDate((Date)costMapItem.getDateFrom()), (String)""), Utils.maskBlank((String)TimeUtils.formatDate((Date)costMapItem.getDateTo()), (String)""), Utils.formatBigDecimal((BigDecimal)costMapItem.getItemCost(), (int)5)};
                    costMapItems.add(item);
                }
                try (FileOutputStream fos = new FileOutputStream(VoiceCostMapExportPanel.this.exportFile);
                     OutputStreamWriter writer = new OutputStreamWriter((OutputStream)fos, "UTF-8");
                     CSVWriter csv = new CSVWriter((Writer)writer, '\t');){
                    for (String[] item : costMapItems) {
                        csv.writeNext(item);
                    }
                    csv.flush();
                }
                BGToolTip.showMessage((JComponent)VoiceCostMapExportPanel.this.buttonPanel, (String)("\u0412\u044b\u0433\u0440\u0443\u0436\u0435\u043d\u043e " + costMapItemsForExport.size() + " \u044d\u043b\u0435\u043c\u0435\u043d\u0442\u043e\u0432 \u0432 \u0444\u0430\u0439\u043b " + VoiceCostMapExportPanel.this.exportFile.getName()));
                VoiceCostMapExportPanel.this.parentPanel.setVisibleBottomPanels(false, false);
                VoiceCostMapExportPanel.this.parentPanel.getButtonPanel().setEnabled(true);
            }
        };
        new AbstractBGUPanel.DefaultAction("close", "\u041e\u0442\u043c\u0435\u043d\u0430"){

            public void actionPerformedImpl(ActionEvent e) throws Exception {
                VoiceCostMapExportPanel.this.parentPanel.setVisibleBottomPanels(false, false);
                VoiceCostMapExportPanel.this.parentPanel.getButtonPanel().setEnabled(true);
            }
        };
    }

    public void performActionOpen() {
        this.fileNameTextField.setText("");
        this.allItemMode.setSelected(true);
        this.parentPanel.getButtonPanel().setEnabled(false);
    }
}

