/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.modules.inet.server.runtime;

import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.atomic.AtomicReference;
import ru.bitel.bgbilling.kernel.network.radius.RadiusAttributeSet;
import ru.bitel.bgbilling.kernel.network.radius.RadiusDictionary;
import ru.bitel.bgbilling.modules.inet.common.bean.InetServType;
import ru.bitel.bgbilling.modules.inet.common.bean.enums.DhcpDisableMode;
import ru.bitel.bgbilling.modules.inet.server.runtime.TrafficTypeLinkRuntime;
import ru.bitel.common.ParameterMap;
import ru.bitel.common.Preferences;
import ru.bitel.common.Utils;
import ru.bitel.common.util.MacrosFormat;

public class InetServTypeRuntime {
    public final InetServType inetServType;
    private final ParameterMap config;
    public final AtomicReference<TrafficTypeLinkRuntime> trafficTypeLinkRuntimeRef;
    public final Set<String> realms;
    public final Integer setIdentifier;
    public final Integer setMacAddress;
    public final Integer servDeviceLink;
    public final boolean radiusNoAddress;
    public final boolean dhcpNoAddress;
    public final boolean radiusFramedIp;
    public final boolean radiusSecondFramedIp;
    public final boolean radiusFramedRoute;
    public final boolean radiusDelegetedPrefix;
    public final boolean searchByMac;
    public final boolean searchByAddress;
    public final boolean searchByLogin;
    private final DhcpDisableMode dhcpDisableMode;
    public final boolean radiusSkipStaticAddress;
    public final boolean radiusStaticSubnet;
    private final Map<String, Map<String, String>> radiusParams;
    public final boolean flowStaticSubnet;
    private final Map<String, Macros> servRadiusAttributesMacrosMap;
    public final Boolean passwordVerification;
    public final Integer checkDuplicateSession;
    public final Integer dhcpCheckDuplicateSession;
    public final Boolean checkDuplicateSessionType;
    public final boolean flowActiveFilterIn;
    public final boolean flowActiveFilterOut;
    public Boolean dhcpConnectionCloseOnNew;
    public final Long connectionSuspendTimeout;
    public final Long connectionCloseTimeout;
    public final Long connectionDisableSuspendTimeout;
    public final Long connectionDisableCloseTimeout;
    private final boolean saAutoAccountingEvent;

    public InetServTypeRuntime(InetServType inetServType, AtomicReference<TrafficTypeLinkRuntime> trafficTypeLinkRuntimeRef) {
        this.inetServType = inetServType;
        this.trafficTypeLinkRuntimeRef = trafficTypeLinkRuntimeRef;
        this.config = new Preferences(this.inetServType.getConfig(), "\n");
        String realms = this.config.get("radius.realm", null);
        this.realms = Utils.notBlankString((String)realms) ? Utils.toSet((String)realms) : null;
        String setIdentifier = this.config.get("serv.identifier.auto", null);
        this.setIdentifier = Utils.notBlankString((String)setIdentifier) ? Integer.valueOf(Utils.parseInt((String)setIdentifier, (int)0)) : null;
        String setMacAddress = this.config.get("serv.macAddress.auto", null);
        this.setMacAddress = Utils.notBlankString((String)setMacAddress) ? Integer.valueOf(Utils.parseInt((String)setMacAddress, (int)0)) : null;
        String servDeviceLink = this.config.get("serv.device.link", null);
        this.servDeviceLink = Utils.notBlankString((String)servDeviceLink) ? Integer.valueOf(Utils.parseInt((String)servDeviceLink, (int)0)) : null;
        HashMap<String, Macros> servRadiusAttributesMacrosMap = new HashMap<String, Macros>(8);
        for (Map.Entry e : this.config.subKeyed("serv.radius.realm.").entrySet()) {
            String attributes = ((ParameterMap)e.getValue()).get("attributes", null);
            if (!Utils.notBlankString((String)attributes)) continue;
            servRadiusAttributesMacrosMap.put((String)e.getKey(), new Macros(attributes));
        }
        String attributes = this.config.get("serv.radius.disable.attributes", null);
        if (Utils.notBlankString((String)attributes)) {
            servRadiusAttributesMacrosMap.put("disable", new Macros(attributes));
        }
        this.servRadiusAttributesMacrosMap = servRadiusAttributesMacrosMap.size() > 0 ? servRadiusAttributesMacrosMap : null;
        this.radiusFramedIp = this.config.getInt("serv.radius.framedIp", 0) > 0;
        this.radiusFramedRoute = this.config.getInt("serv.radius.framedRoute", 0) > 0;
        this.radiusDelegetedPrefix = this.config.getInt("serv.radius.delegetedPrefix", this.config.getInt("serv.radius.delegetedIpPrefix", 0)) > 0;
        this.radiusSecondFramedIp = this.config.getInt("serv.radius.secondFramedIp", 0) > 0;
        this.searchByMac = this.config.getInt("serv.search.mac", 1) > 0;
        this.searchByAddress = this.config.getInt("serv.search.address", 0) > 0;
        this.searchByLogin = this.config.getInt("serv.search.login", 0) > 0;
        this.radiusStaticSubnet = this.config.getInt("serv.radius.staticSubnet", 0) > 0;
        this.flowStaticSubnet = this.config.getInt("serv.flow.staticSubnet", 0) > 0;
        this.radiusNoAddress = this.config.getInt("serv.radius.noAddress", 0) > 0;
        this.dhcpNoAddress = this.config.getInt("serv.dhcp.noAddress", 0) > 0;
        this.dhcpDisableMode = DhcpDisableMode.valueOf((int)this.config.getInt("dhcp.disable.mode", -1));
        this.radiusSkipStaticAddress = this.config.getInt("serv.radius.skipStaticAddress", 0) > 0;
        HashMap<String, Map<String, String>> radiusParams = new HashMap<String, Map<String, String>>();
        for (Map.Entry entry : this.config.subKeyed("param.").entrySet()) {
            String[] attributeRealms;
            ParameterMap params = (ParameterMap)entry.getValue();
            String attribute = params.get("attribute", null);
            if (Utils.isBlankString((String)attribute)) continue;
            for (String realm : attributeRealms = params.get("realms", "").trim().split("\\s*,\\s*")) {
                HashMap<String, String> map = (HashMap<String, String>)radiusParams.get(realm);
                if (map == null) {
                    map = new HashMap<String, String>();
                    radiusParams.put(realm, map);
                }
                map.put((String)entry.getKey(), attribute);
            }
        }
        this.radiusParams = radiusParams.size() > 0 ? radiusParams : null;
        String passwordVerification = this.config.get("serv.radius.password.verification", null);
        this.passwordVerification = Utils.notBlankString((String)passwordVerification) ? Boolean.valueOf(Utils.parseInt((String)passwordVerification, (int)1) > 0) : null;
        String string = this.config.get("serv.radius.connection.checkDuplicate", null);
        this.checkDuplicateSession = Utils.notBlankString((String)string) ? Integer.valueOf(Utils.parseInt((String)string, (int)0)) : null;
        String dhcpCheckDuplicateSession = this.config.get("serv.dhcp.connection.checkDuplicate", null);
        this.dhcpCheckDuplicateSession = Utils.notBlankString((String)string) ? Integer.valueOf(Utils.parseInt((String)dhcpCheckDuplicateSession, (int)0)) : null;
        String checkDuplicateSessionType = this.config.get("serv.radius.connection.checkDuplicate.type", null);
        this.checkDuplicateSessionType = Utils.notBlankString((String)checkDuplicateSessionType) ? Boolean.valueOf(Utils.parseInt((String)checkDuplicateSessionType, (int)0) > 0) : null;
        this.flowActiveFilterIn = this.config.getInt("serv.flow.active.filterIn", 0) > 0;
        this.flowActiveFilterOut = this.config.getInt("serv.flow.active.filterOut", 0) > 0;
        String dhcpConnectionCloseOnNew = this.config.get("serv.dhcp.connection.closeOnNew", this.config.get("dhcp.connection.closeOnNew", null));
        this.dhcpConnectionCloseOnNew = Utils.notBlankString((String)dhcpConnectionCloseOnNew) ? Boolean.valueOf(Utils.parseInt((String)dhcpConnectionCloseOnNew, (int)0) > 0) : null;
        long connectionSuspendTimeout = this.config.getLong("serv.connection.suspend.timeout", 0L);
        this.connectionSuspendTimeout = connectionSuspendTimeout > 0L ? Long.valueOf(connectionSuspendTimeout) : null;
        long connectionCloseTimeout = this.config.getLong("serv.connection.close.timeout", 0L);
        this.connectionCloseTimeout = connectionCloseTimeout > 0L ? Long.valueOf(connectionCloseTimeout) : null;
        long connectionDisableSuspendTimeout = this.config.getLong("serv.connection.disable.suspend.timeout", 0L);
        this.connectionDisableSuspendTimeout = connectionDisableSuspendTimeout > 0L ? Long.valueOf(connectionDisableSuspendTimeout) : null;
        long connectionDisableCloseTimeout = this.config.getLong("serv.connection.disable.close.timeout", 0L);
        this.connectionDisableCloseTimeout = connectionDisableCloseTimeout > 0L ? Long.valueOf(connectionDisableCloseTimeout) : null;
        this.saAutoAccountingEvent = this.config.getInt("sa.connection.auto.accountingEvent", 0) > 0;
    }

    public void addRadiusAttributes(String realm, ParameterMap config, RadiusAttributeSet response) {
        String servRadiusAttributes;
        Macros macros;
        if (this.radiusParams != null) {
            Map<String, String> defaultMap = this.radiusParams.get("");
            Map<String, String> realmMap = this.radiusParams.get(realm);
            for (Map.Entry e : config.entrySet()) {
                String key = ((String)e.getKey()).replaceAll("\\.\\d+\\z", "");
                String attribute = realmMap != null ? realmMap.get(key) : null;
                if (attribute == null && defaultMap != null) {
                    attribute = defaultMap.get(key);
                }
                if (attribute == null) continue;
                response.addAttribute(RadiusDictionary.newRadiusAttribute((String)attribute, (String)((String)e.getValue())));
            }
        }
        if (this.servRadiusAttributesMacrosMap != null && (macros = this.servRadiusAttributesMacrosMap.get(realm)) != null && Utils.notBlankString((String)(servRadiusAttributes = macros.format(new StringBuffer(30), config).toString()))) {
            response.addAttributes(RadiusAttributeSet.newRadiusAttributeSet((String)servRadiusAttributes));
        }
    }

    public InetServType getInetServType() {
        return this.inetServType;
    }

    public ParameterMap getConfig() {
        return this.config;
    }

    public boolean isSaAutoAccountingEvent() {
        return this.saAutoAccountingEvent;
    }

    public DhcpDisableMode getDhcpDisableMode() {
        return this.dhcpDisableMode;
    }

    final class Macros
    extends MacrosFormat {
        private final String patternString;

        Macros(String pattern) {
            this.patternString = pattern;
        }

        public StringBuffer format(StringBuffer appendable, Object ... globalArgs) {
            try {
                return super.format(appendable, this.patternString, globalArgs);
            }
            catch (Exception ex) {
                return appendable.append(ex.getMessage());
            }
        }

        protected Object invoke(String macros, Object[] args, Object[] globalArgs) {
            ParameterMap conf = (ParameterMap)globalArgs[0];
            String result = conf.get(macros, null);
            if (result != null) {
                return result;
            }
            return conf.get(macros + ".1", "");
        }
    }
}

