/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.modules.softkey.client;

import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.util.Arrays;
import java.util.List;
import javax.swing.Box;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JScrollPane;
import javax.swing.border.Border;
import ru.bitel.bgbilling.client.common.BGButton;
import ru.bitel.bgbilling.client.common.BGPanel;
import ru.bitel.bgbilling.client.common.BGTitleBorder;
import ru.bitel.bgbilling.client.common.BGUPanel;
import ru.bitel.bgbilling.client.common.BGUTable;
import ru.bitel.bgbilling.client.common.ClientContext;
import ru.bitel.bgbilling.client.util.ClientUtils;
import ru.bitel.bgbilling.modules.softkey.common.bean.SoftkeyProduct;
import ru.bitel.bgbilling.modules.softkey.common.bean.SoftkeyTransaction;
import ru.bitel.bgbilling.modules.softkey.common.bean.SoftkeyTransactionLog;
import ru.bitel.bgbilling.modules.softkey.common.service.SoftkeyService;
import ru.bitel.common.client.AbstractBGUPanel;
import ru.bitel.common.client.BGSwingUtilites;
import ru.bitel.common.client.table.BGTableModel;
import ru.bitel.common.client.table.Column;

public class SoftkeyUserTransactionPanel
extends BGUPanel {
    private BGPanel transactionPanel = null;
    private BGPanel productPanel = null;
    private BGPanel logPanel = null;
    private BGUTable transactionTable = null;
    private BGUTable productTable = null;
    private BGUTable logTable = null;
    private BGTableModel<SoftkeyTransaction> transactionModel = null;
    private BGTableModel<SoftkeyProduct> productModel = null;
    private BGTableModel<SoftkeyTransactionLog> logModel = null;
    private BGButton activateButton = null;
    private BGButton pauseButton = null;
    private BGButton stopButton = null;
    private BGButton continueButton = null;
    private JLabel totalTransactionAmount = null;
    private JLabel totalAmount = null;

    protected void jbInit() {
        this.transactionModel = new BGTableModel<SoftkeyTransaction>("SoftkeyTransaction"){

            protected void initColumns() {
                this.addColumn("\u041d\u0430\u0437\u0432\u0430\u043d\u0438\u0435", -1, -1, -1, "optionTitle", true);
                this.addColumn("\u0421\u0442\u0430\u0442\u0443\u0441", -1, 200, 200, "statusTitle", true);
                this.addColumn("\u0414\u0430\u0442\u0430 \u0443\u0441\u0442\u0430\u043d\u043e\u0432\u043a\u0438 \u0441\u0442\u0430\u0442\u0443\u0441\u0430", Column.DateTime.class, -1, 200, 200, "dt", true);
                this.addColumn("\u041a\u043e\u043b\u0438\u0447\u0435\u0441\u0442\u0432\u043e", -1, 200, 200, "subscribeCount");
                this.addColumn("\u0421\u0442\u043e\u0438\u043c\u043e\u0441\u0442\u044c \u043f\u043e\u0434\u043f\u0438\u0441\u043a\u0438 \u0437\u0430 1 \u0434\u0435\u043d\u044c", -1, 200, 200, "subscribeAmount");
            }
        };
        this.transactionTable = new BGUTable(this.transactionModel);
        this.transactionTable.setSelectionMode(0);
        this.transactionTable.getSelectionModel().addListSelectionListener(e -> {
            if (!e.getValueIsAdjusting()) {
                this.performAction("GETLOG");
            }
        });
        this.productModel = new BGTableModel<SoftkeyProduct>("SoftkeyProduct"){

            protected void initColumns() {
                this.addColumn("\u041d\u0430\u0437\u0432\u0430\u043d\u0438\u0435", -1, -1, -1, "subscribeName", true);
                this.addColumn("\u0421\u0442\u043e\u0438\u043c\u043e\u0441\u0442\u044c 1 \u043b\u0438\u0446\u0435\u043d\u0437\u0438\u0438", -1, -1, -1, "amount");
            }
        };
        this.productTable = new BGUTable(this.productModel);
        this.productTable.setSelectionMode(0);
        this.logModel = new BGTableModel<SoftkeyTransactionLog>("logModel"){

            protected void initColumns() {
                this.addColumn("\u0421\u0442\u0430\u0442\u0443\u0441", -1, -1, -1, "status");
                this.addColumn("\u0414\u0430\u0442\u0430 \u0438\u0437\u043c\u0435\u043d\u0435\u043d\u0438\u044f", -1, -1, -1, "logDate");
            }
        };
        this.logTable = new BGUTable(this.logModel);
        this.transactionPanel = new BGPanel();
        this.transactionPanel.setLayout((LayoutManager)new GridBagLayout());
        this.transactionPanel.setBorder((Border)new BGTitleBorder("\u0418\u043c\u0435\u044e\u0449\u0438\u0435\u0441\u044f \u043f\u043e\u0434\u043f\u0438\u0441\u043a\u0438"));
        this.productPanel = new BGPanel();
        this.productPanel.setLayout((LayoutManager)new GridBagLayout());
        this.productPanel.setBorder((Border)new BGTitleBorder("\u0414\u043e\u0441\u0442\u0443\u043f\u043d\u044b\u0435 \u043f\u043e\u0434\u043f\u0438\u0441\u043a\u0438"));
        this.logPanel = new BGPanel();
        this.logPanel.setLayout((LayoutManager)new GridBagLayout());
        this.logPanel.setBorder((Border)new BGTitleBorder("\u0418\u0441\u0442\u043e\u0440\u0438\u044f \u0438\u0437\u043c\u0435\u043d\u0435\u043d\u0438\u0439 \u043f\u043e\u0434\u043f\u0438\u0441\u043a\u0438"));
        this.activateButton = new BGButton("\u0410\u043a\u0442\u0438\u0432\u0438\u0440\u043e\u0432\u0430\u0442\u044c");
        this.pauseButton = new BGButton("\u041f\u0440\u0438\u043e\u0441\u0442\u0430\u043d\u043e\u0432\u0438\u0442\u044c");
        this.stopButton = new BGButton("\u041f\u0440\u0435\u043a\u0440\u0430\u0442\u0438\u0442\u044c");
        this.continueButton = new BGButton("\u0412\u043e\u0437\u043e\u0431\u043d\u043e\u0432\u0438\u0442\u044c");
        this.activateButton.setEnabled(false);
        this.pauseButton.setEnabled(false);
        this.stopButton.setEnabled(false);
        this.continueButton.setEnabled(false);
        this.totalAmount = new JLabel();
        this.totalTransactionAmount = new JLabel();
        this.setLayout(new GridBagLayout());
        this.add((Component)this.transactionPanel, new GridBagConstraints(0, 0, 1, 1, 1.0, 1.0, 11, 1, new Insets(5, 5, 5, 5), 0, 0));
        this.add((Component)this.productPanel, new GridBagConstraints(0, 1, 1, 1, 1.0, 1.0, 11, 1, new Insets(5, 5, 5, 5), 0, 0));
        BGPanel buttonPanel = new BGPanel();
        buttonPanel.setLayout((LayoutManager)new GridBagLayout());
        buttonPanel.add((Component)this.pauseButton, (Object)new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 17, 1, new Insets(5, 5, 5, 5), 0, 0));
        buttonPanel.add((Component)this.continueButton, (Object)new GridBagConstraints(1, 0, 1, 1, 0.0, 0.0, 17, 1, new Insets(5, 5, 5, 5), 0, 0));
        buttonPanel.add((Component)this.stopButton, (Object)new GridBagConstraints(2, 0, 1, 1, 0.0, 0.0, 17, 1, new Insets(5, 5, 5, 5), 0, 0));
        buttonPanel.add(Box.createHorizontalGlue(), (Object)new GridBagConstraints(3, 0, 1, 1, 1.0, 1.0, 17, 1, new Insets(5, 5, 5, 5), 0, 0));
        BGPanel logPanel = new BGPanel();
        logPanel.setLayout((LayoutManager)new GridBagLayout());
        logPanel.add((Component)BGSwingUtilites.wrapBorder((JComponent)new JScrollPane((Component)this.logTable), (String)"\u0418\u0441\u0442\u043e\u0440\u0438\u044f \u0438\u0437\u043c\u0435\u043d\u0435\u043d\u0438\u0439"), (Object)new GridBagConstraints(0, 0, 1, 1, 1.0, 1.0, 17, 1, new Insets(5, 5, 5, 5), 0, 0));
        this.transactionPanel.add((Component)buttonPanel, (Object)new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 17, 1, new Insets(5, 5, 5, 5), 0, 0));
        this.transactionPanel.add((Component)new JScrollPane((Component)this.transactionTable), (Object)new GridBagConstraints(0, 1, 1, 1, 1.0, 1.0, 11, 1, new Insets(5, 5, 5, 5), 0, 0));
        this.transactionPanel.add((Component)logPanel, (Object)new GridBagConstraints(0, 2, 1, 1, 1.0, 1.0, 11, 1, new Insets(5, 5, 5, 5), 0, 0));
        buttonPanel = new BGPanel();
        buttonPanel.setLayout((LayoutManager)new GridBagLayout());
        buttonPanel.add((Component)this.activateButton, (Object)new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 17, 1, new Insets(5, 5, 5, 5), 0, 0));
        buttonPanel.add(Box.createHorizontalGlue(), (Object)new GridBagConstraints(1, 0, 1, 1, 1.0, 1.0, 17, 1, new Insets(5, 5, 5, 5), 0, 0));
        this.productPanel.add((Component)buttonPanel, (Object)new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 17, 1, new Insets(5, 5, 5, 5), 0, 0));
        this.productPanel.add((Component)new JScrollPane((Component)this.productTable), (Object)new GridBagConstraints(0, 1, 1, 1, 1.0, 1.0, 17, 1, new Insets(5, 5, 5, 5), 0, 0));
        this.activateButton.addActionListener(e -> this.performAction("ACTIVATE"));
        this.pauseButton.addActionListener(e -> this.performAction("PAUSE"));
        this.continueButton.addActionListener(e -> this.performAction("CONTINUE"));
        this.stopButton.addActionListener(e -> this.performAction("STOP"));
    }

    protected void initActions() {
        new AbstractBGUPanel.BGActionRefresh((AbstractBGUPanel)this, e -> {
            SoftkeyTransaction transaction = ((SoftkeyService)((ClientContext)this.getContext()).getPort(SoftkeyService.class)).getTransactionByCid(((ClientContext)this.getContext()).getContractId(), -1);
            if (transaction == null) {
                this.pauseButton.setEnabled(false);
                this.stopButton.setEnabled(false);
                this.continueButton.setEnabled(false);
                this.activateButton.setEnabled(true);
                this.totalTransactionAmount.setText("0.00 \u0440.");
                this.transactionModel.getRows().clear();
                this.logModel.getRows().clear();
                this.transactionTable.updateUI();
                this.transactionTable.repaint();
            } else {
                this.processButtons(transaction.getStatus());
                List<SoftkeyTransaction> list = Arrays.asList(transaction);
                this.transactionModel.setData(list);
            }
            List productList = ((SoftkeyService)((ClientContext)this.getContext()).getPort(SoftkeyService.class)).getProductList();
            if (productList != null) {
                this.productModel.setData(productList);
            } else {
                this.totalAmount.setText("0.00 \u0440.");
            }
        });
        new AbstractBGUPanel.DefaultAction("GETLOG", "\u041f\u0440\u043e\u0441\u043c\u043e\u0442\u0440\u0435\u0442\u044c \u0438\u0441\u0442\u043e\u0440\u0438\u044e \u043f\u043e\u0434\u043f\u0438\u0441\u043a\u0438"){

            public void actionPerformedImpl(ActionEvent e) throws Exception {
                SoftkeyTransaction transaction = (SoftkeyTransaction)SoftkeyUserTransactionPanel.this.transactionModel.getSelectedRow();
                if (transaction != null) {
                    int transactionId = transaction.getId();
                    List transactionLog = ((SoftkeyService)((ClientContext)SoftkeyUserTransactionPanel.this.getContext()).getPort(SoftkeyService.class)).getTransactionLog(transactionId);
                    SoftkeyUserTransactionPanel.this.logModel.setData(transactionLog);
                }
            }
        };
        new AbstractBGUPanel.DefaultAction("ACTIVATE", "\u0410\u043a\u0442\u0438\u0432\u0438\u0440\u043e\u0432\u0430\u0442\u044c \u043f\u043e\u0434\u043f\u0438\u0441\u043a\u0443"){

            public void actionPerformedImpl(ActionEvent e) throws Exception {
                if (SoftkeyUserTransactionPanel.this.productTable.getSelectedRow() >= 0) {
                    SoftkeyProduct product = (SoftkeyProduct)SoftkeyUserTransactionPanel.this.productModel.getSelectedRow();
                    int optionId = product.getSubscribeId();
                    int cid = ((ClientContext)SoftkeyUserTransactionPanel.this.getContext()).getContractId();
                    int count = 1;
                    ((SoftkeyService)((ClientContext)SoftkeyUserTransactionPanel.this.getContext()).getPort(SoftkeyService.class)).activate(cid, count, optionId);
                    SoftkeyUserTransactionPanel.this.performAction("refresh");
                } else {
                    ClientUtils.showErrorMessageDialog((String)"\u0412\u044b\u0431\u0435\u0440\u0438\u0442\u0435 \u0441\u0442\u0440\u043e\u043a\u0443!");
                }
            }
        };
        new AbstractBGUPanel.DefaultAction("PAUSE", "\u041f\u0440\u0438\u043e\u0441\u0442\u0430\u043d\u043e\u0432\u0438\u0442\u044c \u043f\u043e\u0434\u043f\u0438\u0441\u043a\u0443"){

            public void actionPerformedImpl(ActionEvent e) throws Exception {
                SoftkeyTransaction transaction = (SoftkeyTransaction)SoftkeyUserTransactionPanel.this.transactionModel.getSelectedRow();
                if (transaction != null) {
                    int optionId = transaction.getOptionId();
                    int contractId = transaction.getContractId();
                    ((SoftkeyService)((ClientContext)SoftkeyUserTransactionPanel.this.getContext()).getPort(SoftkeyService.class)).pause(contractId, optionId);
                    SoftkeyUserTransactionPanel.this.performAction("refresh");
                }
            }
        };
        new AbstractBGUPanel.DefaultAction("CONTINUE", "\u0412\u043e\u0437\u043e\u0431\u043d\u043e\u0432\u0438\u0442\u044c \u043f\u043e\u0434\u043f\u0438\u0441\u043a\u0443"){

            public void actionPerformedImpl(ActionEvent e) throws Exception {
                SoftkeyTransaction transaction = (SoftkeyTransaction)SoftkeyUserTransactionPanel.this.transactionModel.getSelectedRow();
                if (transaction != null) {
                    int optionId = transaction.getOptionId();
                    int contractId = transaction.getContractId();
                    ((SoftkeyService)((ClientContext)SoftkeyUserTransactionPanel.this.getContext()).getPort(SoftkeyService.class)).continueSubscription(contractId, optionId);
                    SoftkeyUserTransactionPanel.this.performAction("refresh");
                }
            }
        };
        new AbstractBGUPanel.DefaultAction("STOP", "\u041f\u0440\u0435\u043a\u0440\u0430\u0442\u0438\u0442\u044c \u043f\u043e\u0434\u043f\u0438\u0441\u043a\u0443"){

            public void actionPerformedImpl(ActionEvent e) throws Exception {
                SoftkeyTransaction transaction = (SoftkeyTransaction)SoftkeyUserTransactionPanel.this.transactionModel.getSelectedRow();
                if (transaction != null) {
                    int optionId = transaction.getOptionId();
                    int contractId = transaction.getContractId();
                    ((SoftkeyService)((ClientContext)SoftkeyUserTransactionPanel.this.getContext()).getPort(SoftkeyService.class)).stop(contractId, optionId);
                    SoftkeyUserTransactionPanel.this.performAction("refresh");
                }
            }
        };
        new AbstractBGUPanel.DefaultAction("TEST", "Test"){

            public void actionPerformedImpl(ActionEvent e) throws Exception {
                ((SoftkeyService)((ClientContext)SoftkeyUserTransactionPanel.this.getContext()).getPort(SoftkeyService.class)).getSubscribeStatus(((ClientContext)SoftkeyUserTransactionPanel.this.getContext()).getContractId());
            }
        };
    }

    private void processButtons(int transactionStatus) {
        switch (transactionStatus) {
            case 1: {
                this.activateButton.setEnabled(false);
                this.continueButton.setEnabled(false);
                this.pauseButton.setEnabled(true);
                this.stopButton.setEnabled(true);
                break;
            }
            case 2: {
                this.activateButton.setEnabled(false);
                this.continueButton.setEnabled(true);
                this.pauseButton.setEnabled(false);
                this.stopButton.setEnabled(true);
                break;
            }
            case 3: {
                this.activateButton.setEnabled(true);
                this.continueButton.setEnabled(false);
                this.pauseButton.setEnabled(false);
                this.stopButton.setEnabled(false);
            }
        }
    }
}

