/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.modules.reports.client.constructor;

import bitel.billing.module.services.ServiceConfigTabbedPanel;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.function.Consumer;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.SwingUtilities;
import org.bushe.swing.event.EventBus;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import ru.bitel.bgbilling.client.common.BGSplitPaneNoBorder;
import ru.bitel.bgbilling.client.util.ClientUtils;
import ru.bitel.bgbilling.common.BGMessageException;
import ru.bitel.bgbilling.kernel.dynamic.client.DynamicClassChooser;
import ru.bitel.bgbilling.kernel.dynamic.common.service.DynamicCodeService;
import ru.bitel.bgbilling.modules.reports.client.constructor.CreatedReportEvent;
import ru.bitel.bgbilling.modules.reports.client.constructor.FilterDialog;
import ru.bitel.bgbilling.modules.reports.client.constructor.FilterPanel;
import ru.bitel.bgbilling.modules.reports.client.constructor.GenerateReportOptions;
import ru.bitel.bgbilling.modules.reports.client.constructor.ReportFieldsTabelPanel;
import ru.bitel.bgbilling.modules.reports.client.constructor.ReportFilterListPanel;
import ru.bitel.bgbilling.modules.reports.client.constructor.ViewXmlReportPanel;
import ru.bitel.bgbilling.modules.reports.client.constructor.VisualReportDetail;
import ru.bitel.bgbilling.modules.reports.client.include.ReportFilter;
import ru.bitel.bgbilling.modules.reports.client.include.ReportFilterCache;
import ru.bitel.bgbilling.modules.reports.client.include.ReportFilterParameterName;
import ru.bitel.bgbilling.modules.reports.common.service.ReportService;
import ru.bitel.common.Utils;
import ru.bitel.common.XMLUtils;
import ru.bitel.common.client.BGSwingUtilites;

public class ReportConstructorPanel
extends ServiceConfigTabbedPanel {
    private final JTextField reportTitle = new JTextField();
    private final JTextField reportFileName = new JTextField();
    private DynamicClassChooser dynamicClassChooser;
    private final ReportFieldsTabelPanel reportFieldsTabelPanel = new ReportFieldsTabelPanel();
    private ReportFilterListPanel reportFilterListPanel = null;
    private final JButton generateReport = new JButton("\u0421\u0433\u0435\u043d\u0435\u0440\u0438\u0440\u043e\u0432\u0430\u0442\u044c \u043e\u0442\u0447\u0435\u0442");
    private final JButton createReport = new JButton("\u0421\u043e\u0437\u0434\u0430\u0442\u044c \u043e\u0442\u0447\u0435\u0442");
    private ViewXmlReportPanel viewXmlReportPanel = null;
    private VisualReportDetail visualReportDetail = null;
    private GenerateReportOptions generateReportOptions;
    private JCheckBox scroll = new JCheckBox("\u0414\u043e\u0431\u0430\u0432\u0438\u0442\u044c \u0441\u043a\u0440\u043e\u043b\u043b\u0438\u043d\u0433?");
    private boolean inited = false;
    private Consumer<Void> reloadXmlReportDataListener = v -> {
        try {
            Document doc = this.viewXmlReportPanel.generateDocumentFromXmlSource();
            if (doc == null) {
                this.visualReportDetail.clear();
                return;
            }
            Element reportEl = doc.getDocumentElement();
            if (reportEl == null || !reportEl.getNodeName().equals("report")) {
                this.visualReportDetail.clear();
                return;
            }
            this.removeReportFiltersListener(reportEl);
            this.removeReportFieldsListener(reportEl);
            this.viewXmlReportPanel.setDocument(doc);
            this.viewXmlReportPanel.setRootElement(reportEl);
            this.visualReportDetail.buildUI(doc, reportEl);
        }
        catch (Exception ex) {
            ClientUtils.showErrorMessageDialog((Throwable)ex);
        }
    };

    public ReportConstructorPanel() {
        super("ReportConstructorPanel");
    }

    public void setData() {
        if (this.inited) {
            return;
        }
        this.setLayout(new GridBagLayout());
        this.reportFilterListPanel = new ReportFilterListPanel();
        this.dynamicClassChooser = new DynamicClassChooser(true);
        this.viewXmlReportPanel = new ViewXmlReportPanel(this.reloadXmlReportDataListener);
        this.visualReportDetail = new VisualReportDetail();
        JPanel rightPanel = new JPanel(new GridBagLayout());
        rightPanel.add((Component)new BGSplitPaneNoBorder(1, (Component)((Object)this.viewXmlReportPanel), (Component)this.visualReportDetail, 700L), new GridBagConstraints(0, 0, 1, 1, 1.0, 1.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
        rightPanel.add((Component)this.createReport, new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 12, 0, new Insets(3, 3, 3, 3), 0, 0));
        this.add((Component)new BGSplitPaneNoBorder(1, (Component)new JScrollPane(this.createReportConfiguratePanel(), 22, 31), (Component)rightPanel, 550L), new GridBagConstraints(0, 0, 1, 1, 1.0, 1.0, 18, 1, new Insets(0, 3, 3, 3), 0, 0));
        this.dynamicClassChooser.setNewClass(true);
        this.dynamicClassChooser.setNewClassPrefix("ru.bitel.bgbilling.modules.report.");
        this.dynamicClassChooser.setIfaceName("ru.bitel.bgbilling.modules.reports.server.report.BGCSVReport$CSVFillerData");
        this.dynamicClassChooser.addIfaceName("ru.bitel.bgbilling.modules.reports.server.report.BGCSVReport$CSVFillerDataFields");
        this.dynamicClassChooser.performAction("refresh");
        this.generateReport.addActionListener(e -> this.generateReport(true));
        this.createReport.addActionListener(e -> {
            if (ClientUtils.confirm((String)"\u0421\u043e\u0437\u0434\u0430\u0442\u044c \u043e\u0442\u0447\u0435\u0442?", (String)"\u0421\u043e\u0437\u0434\u0430\u043d\u0438\u0435 \u043e\u0442\u0447\u0435\u0442\u0430")) {
                this.createReport();
            }
        });
        this.reportFilterListPanel.getFiltersList().addMouseListener((MouseListener)new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                if (e.getClickCount() == 2 && SwingUtilities.isLeftMouseButton(e)) {
                    ReportFilter filterClassInstance;
                    if (!ReportConstructorPanel.this.checkValidReportFileName(ReportConstructorPanel.this.reportFileName.getText())) {
                        ClientUtils.showErrorMessageDialog((String)"\u0423\u043a\u0430\u0436\u0438\u0442\u0435 \u043d\u0430\u0437\u0432\u0430\u043d\u0438\u0435 \u043e\u0442\u0447\u0435\u0442\u0430");
                        return;
                    }
                    if (Utils.isBlankString((String)ReportConstructorPanel.this.dynamicClassChooser.getSelectedClass())) {
                        ClientUtils.showErrorMessageDialog((String)"\u0423\u043a\u0430\u0436\u0438\u0442\u0435 \u043a\u043b\u0430\u0441\u0441-\u043e\u0431\u0440\u0430\u0431\u043e\u0442\u0447\u0438\u043a \u043e\u0442\u0447\u0435\u0442\u0430");
                        return;
                    }
                    ReportFilter selectedFilter = (ReportFilter)ReportConstructorPanel.this.reportFilterListPanel.getFiltersList().getSelectedValue();
                    if (selectedFilter != null && (filterClassInstance = ReportFilterCache.getInstance().getFilterInstanceClass(selectedFilter.getClass().getName())) != null) {
                        new FilterDialog(ReportConstructorPanel.this, new FilterPanel(filterClassInstance), ReportConstructorPanel.this.reportFilterListPanel);
                    }
                }
            }
        });
        this.inited = true;
    }

    private void removeReportFiltersListener(Element el) throws Exception {
        Iterator<FilterPanel> filterPanelIterator = this.reportFilterListPanel.getSelectedFilters().iterator();
        while (filterPanelIterator.hasNext()) {
            String parameterName;
            FilterPanel filterPanel = filterPanelIterator.next();
            ReportFilter selectedFilter = filterPanel.getReportFilter();
            ArrayList elements = new ArrayList();
            XMLUtils.selectElements((Node)el, (String)("//" + selectedFilter.getFilterTitle())).forEach(e -> elements.add(e));
            HashMap<String, Element> filtersInReport = new HashMap<String, Element>();
            for (Element e1 : elements) {
                filtersInReport.put(e1.getAttribute("name"), el);
            }
            Set parameterNames = filterPanel.getParameterFields().stream().filter(f -> f.getField().getAnnotation(ReportFilterParameterName.class) != null).map(f -> {
                try {
                    return new String((String)f.getField().get(selectedFilter));
                }
                catch (Exception ignored) {
                    return "";
                }
            }).collect(Collectors.toSet());
            Element elementWithThisParameterName = null;
            Iterator iterator = parameterNames.iterator();
            while (iterator.hasNext() && (elementWithThisParameterName = (Element)filtersInReport.get(parameterName = (String)iterator.next())) == null) {
            }
            if (elementWithThisParameterName != null) continue;
            filterPanelIterator.remove();
        }
    }

    private void removeReportFieldsListener(Element el) throws Exception {
        ArrayList<String> mustRemoveKeys = new ArrayList<String>();
        Map<String, String> fields = this.reportFieldsTabelPanel.getFields();
        block0: for (Map.Entry<String, String> entry : fields.entrySet()) {
            boolean mustRemove = true;
            for (Element field : XMLUtils.selectElements((Node)el, (String)"/report/fields/*")) {
                if (!field.getAttribute("id").equals(entry.getKey()) || !field.getAttribute("title").equals(entry.getValue())) continue;
                mustRemove = false;
                continue block0;
            }
            if (!mustRemove) continue;
            mustRemoveKeys.add(entry.getKey());
        }
        mustRemoveKeys.forEach(key -> fields.remove(key));
        this.reportFieldsTabelPanel.setData(fields);
    }

    private JPanel createReportConfiguratePanel() {
        JPanel configuratePanel = new JPanel(new GridBagLayout());
        BGSwingUtilites.wrapBorder((JPanel)configuratePanel, (String)"\u041d\u0430\u0441\u0442\u0440\u043e\u0439\u043a\u0430 \u043f\u0430\u0440\u0430\u043c\u0435\u0442\u0440\u043e\u0432 \u043e\u0442\u0447\u0435\u0442\u0430");
        GridBagConstraints constraints = new GridBagConstraints(0, -1, 1, 1, 0.0, 0.0, 18, 2, new Insets(0, 3, 3, 3), 0, 0);
        configuratePanel.add((Component)new JLabel("\u041d\u0430\u0437\u0432\u0430\u043d\u0438\u0435 \u043e\u0442\u0447\u0435\u0442\u0430"), constraints);
        configuratePanel.add((Component)this.reportTitle, constraints);
        configuratePanel.add((Component)new JLabel("\u0418\u043c\u044f \u0444\u0430\u0439\u043b\u0430 \u043e\u0442\u0447\u0435\u0442\u0430(\u043b\u0430\u0442\u0438\u043d\u0438\u0446\u0435\u0439)"), constraints);
        configuratePanel.add((Component)this.reportFileName, constraints);
        configuratePanel.add((Component)new JLabel("\u041a\u043b\u0430\u0441\u0441-\u043e\u0431\u0440\u0430\u0431\u043e\u0442\u0447\u0438\u043a \u043e\u0442\u0447\u0435\u0442\u0430"), constraints);
        configuratePanel.add((Component)this.dynamicClassChooser, constraints);
        constraints.weighty = 1.0;
        constraints.fill = 1;
        configuratePanel.add((Component)this.reportFieldsTabelPanel, constraints);
        constraints.weighty = 0.0;
        constraints.fill = 2;
        configuratePanel.add((Component)((Object)this.reportFilterListPanel), new GridBagConstraints(0, -1, 1, 1, 1.0, 1.0, 18, 1, new Insets(0, 3, 3, 3), 0, 0));
        configuratePanel.add((Component)this.scroll, constraints);
        configuratePanel.add((Component)this.generateReport, constraints);
        return configuratePanel;
    }

    public void newItem() {
        this.reportTitle.setText("");
        this.reportFileName.setText("");
        this.dynamicClassChooser.clearSelection();
        this.reportFieldsTabelPanel.clear();
        this.reportFilterListPanel.getSelectedFilters().clear();
        this.viewXmlReportPanel.clear();
        this.scroll.setSelected(false);
    }

    public void setReport(GenerateReportOptions options) {
        if (options == null) {
            return;
        }
        this.setData();
        this.reportTitle.setText(options.getReportTitle());
        this.reportFileName.setText(options.getReportFileName());
        this.dynamicClassChooser.setSelectedItem(options.getProcessingClass());
        this.reportFieldsTabelPanel.setData(options.getFields());
        this.reportFilterListPanel.setSelectedFilters(options.getFilters());
        this.scroll.setSelected(options.isNeedScroll());
        this.generateReport(false);
    }

    public void generateReport(boolean needReportProcessingClass) {
        String reportName = this.reportTitle.getText();
        if (Utils.isBlankString((String)reportName)) {
            ClientUtils.showErrorMessageDialog((String)"\u0423\u043a\u0430\u0436\u0438\u0442\u0435 \u043d\u0430\u0437\u0432\u0430\u043d\u0438\u0435 \u043e\u0442\u0447\u0435\u0442\u0430");
            return;
        }
        String reportFileName = this.reportFileName.getText();
        if (Utils.isBlankString((String)reportFileName) || !this.checkValidReportFileName(reportFileName)) {
            ClientUtils.showErrorMessageDialog((String)"\u041d\u0430\u0437\u0432\u0430\u043d\u0438\u0435 \u0444\u0430\u0439\u043b\u0430 \u043d\u0435 \u0434\u043e\u043b\u0436\u043d\u043e \u0431\u044b\u0442\u044c \u043f\u0443\u0441\u0442\u044b\u043c \u0438 \u0434\u043e\u043b\u0436\u043d\u043e \u0441\u043e\u0441\u0442\u043e\u044f\u0442\u044c \u0442\u043e\u043b\u044c\u043a\u043e \u0438\u0437 \u043b\u0430\u0442\u0438\u043d\u0441\u043a\u0438\u0445 \u0431\u0443\u043a\u0432");
            return;
        }
        String selectedProcessingClass = this.dynamicClassChooser.getSelectedClass();
        if (needReportProcessingClass && Utils.isBlankString((String)selectedProcessingClass)) {
            ClientUtils.showErrorMessageDialog((String)"\u041d\u0435 \u0437\u0430\u0434\u0430\u043d \u043a\u043b\u0430\u0441\u0441-\u043e\u0431\u0440\u0430\u0431\u043e\u0442\u0447\u0438\u043a \u043e\u0442\u0447\u0435\u0442\u0430");
            return;
        }
        reportFileName = this.normalizeTitle(reportFileName);
        this.generateReportOptions = GenerateReportOptions.builder().setReportTitle(reportName).setReportFileName(reportFileName).setProcessingClass(selectedProcessingClass).setFilters(this.reportFilterListPanel.getSelectedFilters()).setFields(this.reportFieldsTabelPanel.getFields()).setNeedScroll(this.scroll.isSelected()).build();
        try {
            this.viewXmlReportPanel.setData(this.generateReportOptions);
            this.visualReportDetail.buildUI(this.viewXmlReportPanel.getDocument(), this.viewXmlReportPanel.getRootElement());
        }
        catch (Exception ex) {
            ClientUtils.showErrorMessageDialog((Throwable)ex);
        }
    }

    private boolean checkValidReportFileName(String fileName) {
        return Pattern.compile("[\\p{IsLatin}_(.rep)(.xml)(0-9)]+").matcher(fileName).matches();
    }

    private String normalizeTitle(String title) {
        if (((String)title).endsWith(".rep.xml")) {
            return title;
        }
        title = ((String)title).endsWith(":rep:xml") ? ((String)title).replace(":rep:xml", ".rep.xml") : (((String)title).endsWith(".xml") ? (String)title + ".rep.xml" : (String)title + ".rep.xml");
        return title;
    }

    private void createReport() {
        this.generateReport(true);
        String xmlData = this.viewXmlReportPanel.getXmlData();
        if (this.generateReportOptions == null || Utils.isBlankString((String)xmlData)) {
            ClientUtils.showErrorMessageDialog((String)"\u041e\u0442\u0447\u0435\u0442 \u043d\u0435 \u0431\u044b\u043b \u0441\u0433\u0435\u043d\u0435\u0440\u0438\u0440\u043e\u0432\u0430\u043d!");
            return;
        }
        String processingClass = this.generateReportOptions.getProcessingClass();
        if (Utils.isBlankString((String)processingClass)) {
            ClientUtils.showErrorMessageDialog((String)"\u041d\u0435 \u0437\u0430\u0434\u0430\u043d \u043a\u043b\u0430\u0441\u0441-\u043e\u0431\u0440\u0430\u0431\u043e\u0442\u0447\u0438\u043a \u043e\u0442\u0447\u0435\u0442\u0430");
            return;
        }
        String customReportPackage = Utils.maskBlank((String)processingClass.substring(0, processingClass.lastIndexOf(".")), (String)"/");
        String reportXmlClassName = customReportPackage + "." + this.generateReportOptions.getReportFileName().replace(".rep.xml", ":rep:xml");
        try {
            if (((ReportService)this.getContext().getPort(ReportService.class, this.getModuleId())).checkReportExists(this.generateReportOptions.getReportFileName())) {
                throw new BGMessageException("\u0422\u0430\u043a\u043e\u0439 \u043a\u043b\u0430\u0441\u0441 \u0443\u0436\u0435 \u0441\u0443\u0449\u0435\u0441\u0442\u0432\u0443\u0435\u0442 \u0432 \u0434\u0438\u0440\u0435\u043a\u0442\u043e\u0440\u0438\u0438 \u0441\u0435\u0440\u0432\u0435\u0440\u0430 \u0431\u0438\u043b\u043b\u0438\u043d\u0433\u0430. \u0423\u043a\u0430\u0436\u0438\u0442\u0435 \u0434\u0440\u0443\u0433\u043e\u0435 \u043d\u0430\u0437\u0432\u0430\u043d\u0438\u0435 \u0434\u043b\u044f \u0444\u0430\u0439\u043b\u0430.");
            }
            DynamicCodeService dynamicCodeService = (DynamicCodeService)this.getContext().getPort(DynamicCodeService.class, 0);
            dynamicCodeService.compile(this.generateReportOptions.getProcessingClass());
            if (dynamicCodeService.isClassExists(reportXmlClassName) && !ClientUtils.confirm((String)"\u0424\u0430\u0439\u043b \u043e\u0442\u0447\u0435\u0442\u0430 \u0441 \u0442\u0430\u043a\u0438\u043c \u0438\u043c\u0435\u043d\u0435\u043c \u0443\u0436\u0435 \u0441\u0443\u0449\u0435\u0441\u0442\u0432\u0443\u0435\u0442 \u0432 \u0434\u0438\u043d\u0430\u043c\u0438\u0447\u0435\u0441\u043a\u043e\u043c \u043a\u043e\u0434\u0435. \u041f\u0435\u0440\u0435\u0437\u0430\u043f\u0438\u0441\u0430\u0442\u044c?", (String)"\u0412\u043d\u0438\u043c\u0430\u043d\u0438\u0435")) {
                return;
            }
            dynamicCodeService.updateSource(reportXmlClassName, xmlData);
            dynamicCodeService.compile(reportXmlClassName);
            EventBus.publish((Object)new CreatedReportEvent());
            ClientUtils.showMessageDialog((Object)"\u041e\u0442\u0447\u0435\u0442 \u0431\u044b\u043b \u0441\u043e\u0437\u0434\u0430\u043d!\n\u0414\u043b\u044f \u043f\u0440\u043e\u0441\u043c\u043e\u0442\u0440\u0430 \u043f\u0435\u0440\u0435\u0439\u0434\u0438\u0442\u0435 \u043d\u0430 \u0432\u043a\u043b\u0430\u0434\u043a\u0443 \u0441 \u043e\u0442\u0447\u0435\u0442\u0430\u043c\u0438");
        }
        catch (Exception e) {
            ClientUtils.showErrorMessageDialog((Throwable)e);
        }
    }
}

