/*
 * Decompiled with CFR 0.152.
 */
package bitel.billing.server.util.telnet;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;

public class TelnetInputStream
extends InputStream {
    public static final int IAC = 255;
    public static final int SE = 240;
    public static final int NOP = 241;
    public static final int DM = 242;
    public static final int BREAK = 243;
    public static final int IP = 244;
    public static final int AO = 245;
    public static final int AYT = 246;
    public static final int EC = 247;
    public static final int EL = 248;
    public static final int GA = 249;
    public static final int SB = 250;
    public static final int WILL = 251;
    public static final int WONT = 252;
    public static final int DO = 253;
    public static final int DONT = 254;
    public static final int OPTION_TERMINAL = 24;
    private InputStream input = null;
    private OutputStream output = null;

    public TelnetInputStream(InputStream input, OutputStream output) {
        this.input = input;
        this.output = output;
    }

    @Override
    public int read() throws IOException {
        int b = -1;
        while (this.input.available() > 0) {
            int symbol = this.input.read();
            if (symbol == 255) {
                if (this.input.available() <= 0) break;
                int command = this.input.read();
                if (command != 255) {
                    if (this.input.available() <= 0) break;
                    int option = this.input.read();
                    if (command == 250) {
                        this.readSubption();
                    }
                    this.proccessCommand(command, option);
                    continue;
                }
            }
            b = symbol;
            break;
        }
        return b;
    }

    private void readSubption() throws IOException {
        int b = -1;
        while (b != 240) {
            b = this.input.read();
        }
    }

    private void proccessCommand(int command, int option) throws IOException {
        switch (command) {
            case 251: {
                this.output.write(255);
                this.output.write(254);
                this.output.write(option);
                break;
            }
            case 253: {
                if (option == 24) {
                    this.output.write(255);
                    this.output.write(251);
                    this.output.write(option);
                    break;
                }
                this.output.write(255);
                this.output.write(252);
                this.output.write(option);
                break;
            }
            case 250: {
                this.output.write(255);
                this.output.write(250);
                this.output.write(24);
                this.output.write(0);
                this.output.write("dumb".getBytes());
                this.output.write(255);
                this.output.write(240);
                break;
            }
        }
    }

    @Override
    public int available() throws IOException {
        return this.input.available();
    }
}

