/*
 * Decompiled with CFR 0.152.
 */
package bitel.billing.server.tariff;

import bitel.billing.server.tariff.CacheEntry;
import bitel.billing.server.tariff.TariffModuleTree;
import bitel.billing.server.tariff.TariffTreeBuilder;
import java.util.Vector;
import ru.bitel.bgbilling.kernel.base.server.logger.BGLogger;

public class TariffTreesCache
extends BGLogger {
    private static TariffTreesCache _cache;
    private Vector<CacheEntry> _cacheEntries = new Vector();

    public static TariffTreesCache getCache() {
        if (_cache == null) {
            _cache = new TariffTreesCache();
        }
        return _cache;
    }

    private TariffTreesCache() {
    }

    public synchronized TariffModuleTree getTreeFromCache(TariffTreeBuilder ttb, int treeID, int mid) {
        CacheEntry entry;
        int i;
        TariffModuleTree result = null;
        for (i = 0; i < this._cacheEntries.size(); ++i) {
            entry = this._cacheEntries.get(i);
            if (!entry.isCoincide(treeID, mid)) continue;
            TariffModuleTree moduleTree = entry.getTariffModuleTree();
            if (moduleTree.isActual(ttb)) {
                result = moduleTree;
                if (!this.getLogger().isDebugEnabled()) break;
                this.getLogger().debug("Getting tree from cache [ {} ]", (Object)this._cacheEntries.size());
                break;
            }
            this._cacheEntries.remove(entry);
            if (!this.getLogger().isDebugEnabled()) break;
            this.getLogger().debug("Removing no actual tree [ {} ]", (Object)this._cacheEntries.size());
            break;
        }
        for (i = 0; i < this._cacheEntries.size(); ++i) {
            entry = this._cacheEntries.get(i);
            if (!entry.isOld()) continue;
            this._cacheEntries.remove(entry);
            if (!this.getLogger().isDebugEnabled()) continue;
            this.getLogger().debug("Removing old tree [ {} ]", (Object)this._cacheEntries.size());
        }
        return result;
    }

    public void putTreeToCache(TariffModuleTree tree) {
        this._cacheEntries.add(new CacheEntry(tree));
    }

    public String getCacheStatus() {
        return String.valueOf(this._cacheEntries.size());
    }

    public void clearCache() {
        this._cacheEntries.clear();
    }
}

