/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.modules.ipn.server.dlink;

import java.util.ArrayList;
import java.util.Set;
import ru.bitel.bgbilling.modules.ipn.server.Dlink30xx35xxGateWorker;
import ru.bitel.bgbilling.modules.ipn.server.dlink.DlinkUtils;
import ru.bitel.bgbilling.modules.ipn.server.dlink.NextTaker;
import ru.bitel.bgbilling.modules.ipn.server.dlink.PortMask;
import ru.bitel.bgbilling.modules.ipn.server.dlink.UserPortStatus;
import ru.bitel.common.Utils;
import uk.co.westhawk.snmp.stack.AsnInteger;
import uk.co.westhawk.snmp.stack.AsnOctets;
import uk.co.westhawk.snmp.stack.varbind;

public class IPMacBinding35xx
extends NextTaker {
    private String oidBinding;
    private PortMask portMask;
    private Set<String> macSet;

    public IPMacBinding35xx(int model, int subModel, PortMask portMask, Set<String> macSet) {
        this.portMask = portMask;
        this.macSet = macSet;
        if (model == 1) {
            switch (subModel) {
                case 1: 
                case 2: {
                    this.oidBinding = "1.3.6.1.4.1.171.11.64.1.2.7";
                    break;
                }
                case 3: {
                    this.oidBinding = "1.3.6.1.4.1.171.11.64.2.2.7";
                }
            }
        } else if (model == 2) {
            switch (subModel) {
                case 1: {
                    this.oidBinding = "1.3.6.1.4.1.171.11.69.1.2.7";
                    break;
                }
                case 2: {
                    this.oidBinding = "1.3.6.1.4.1.171.11.69.2.2.7";
                    break;
                }
                case 3: {
                    this.oidBinding = "1.3.6.1.4.1.171.11.69.3.2.7";
                    break;
                }
                case 4: {
                    this.oidBinding = "1.3.6.1.4.1.171.11.69.4.2.7";
                }
            }
        }
    }

    public String getTopOid() {
        return this.oidBinding;
    }

    public void bind(UserPortStatus userPort, Dlink30xx35xxGateWorker gateWorker) throws Exception {
        ArrayList<Object[]> pairs = new ArrayList<Object[]>(5);
        String oid = null;
        if (userPort.status.status == 3 && this.macSet.contains(userPort.macAddr)) {
            oid = this.oidBinding + ".2.1.3." + DlinkUtils.convertHexToOid(userPort.ipAddr);
            pairs.add(new Object[]{oid, new AsnInteger(6)});
        }
        if (userPort.status.status != 3 && !this.macSet.contains(userPort.macAddr)) {
            oid = this.oidBinding + ".2.1.3." + DlinkUtils.convertHexToOid(userPort.ipAddr);
            pairs.add(new Object[]{oid, new AsnInteger(4)});
            oid = this.oidBinding + ".2.1.4." + DlinkUtils.convertHexToOid(userPort.ipAddr);
            pairs.add(new Object[]{oid, new AsnOctets(this.portMask.portToMask(userPort.port))});
            oid = this.oidBinding + ".2.1.2." + DlinkUtils.convertHexToOid(userPort.ipAddr);
            pairs.add(new Object[]{oid, new AsnOctets(Utils.hexStringToBytes((String)userPort.macAddr))});
            oid = this.oidBinding + ".2.1.6." + DlinkUtils.convertHexToOid(userPort.ipAddr);
            pairs.add(new Object[]{oid, new AsnInteger(1)});
            oid = this.oidBinding + ".1.1.2." + userPort.port;
            pairs.add(new Object[]{oid, new AsnInteger(2)});
        }
        if (pairs.size() > 0) {
            gateWorker.sendSetPdu(pairs);
        }
    }

    @Override
    public void takeData(PortMask pm, String oid, varbind var) {
        String oidStart = this.oidBinding + ".2.1.2.";
        if (oid.startsWith(oidStart) && var.getValue() instanceof AsnOctets) {
            AsnOctets value = (AsnOctets)var.getValue();
            this.macSet.add(Utils.bytesToString((byte[])value.getBytes()));
        }
    }
}

