/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.modules.cerbercrypt.server.protocol.conax;

import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import ru.bitel.bgbilling.modules.cerbercrypt.server.protocol.conax.ConaxRequest;
import ru.bitel.bgbilling.modules.cerbercrypt.server.protocol.conax.ConaxSubscribeAddRequest;
import ru.bitel.bgbilling.modules.cerbercrypt.server.protocol.conax.ConaxSubscribeCancelRequest;
import ru.bitel.common.TimeUtils;
import ru.bitel.common.util.DebugUtils;

public abstract class ConaxSubscribeRequest
implements ConaxRequest {
    private static String DATE_FORMAT = "yyyyMMddHHmm";
    public static int SUBSCRIBE_ADD = 1;
    public static int SUBSCRIBE_CANCEL = 2;
    private int transactionId;
    private int packetId;
    private Date begin;
    private Date end;
    private boolean isExpress = false;
    private List<Long> cards = new ArrayList<Long>();
    int command;

    public void setTransactionId(int transactionId) {
        this.transactionId = transactionId % 1000000;
    }

    public void setPacketId(int packetId) {
        this.packetId = packetId;
    }

    public void setBegin(Date begin) {
        this.begin = begin;
    }

    public void setEnd(Date end) {
        this.end = end;
    }

    public void setExpress(boolean isExpress) {
        this.isExpress = isExpress;
    }

    public List<Long> getCards() {
        return this.cards;
    }

    public void setCards(List<Long> cards) {
        this.cards = cards;
    }

    @Override
    public String makeFileName() {
        return (this.command == SUBSCRIBE_ADD ? "ps" : (this.command == SUBSCRIBE_CANCEL ? "cs" : "")) + String.format("%1$06d", this.transactionId) + "." + (this.isExpress && this.command == SUBSCRIBE_ADD ? "exp" : "emm");
    }

    @Override
    public String makeRequest() {
        StringBuilder sb = new StringBuilder(512);
        sb.append('U').append("\r\n");
        sb.append(String.format("%1$06d", this.transactionId)).append("\r\n");
        sb.append(String.format("%1$08d", this.packetId)).append("\r\n");
        sb.append(TimeUtils.format((Date)this.begin, (String)DATE_FORMAT)).append("\r\n");
        sb.append(TimeUtils.format((Date)this.end, (String)DATE_FORMAT)).append("\r\n");
        sb.append('U').append("\r\n");
        sb.append(this.isExpress ? "EXP" : "EMM").append("\r\n");
        sb.append('U').append("\r\n");
        sb.append(String.format("%1$05d", this.cards.size())).append("\r\n");
        for (Long card : this.cards) {
            sb.append(String.format("%1$011d", card)).append("\r\n");
        }
        sb.append("ZZZ").append("\r\n");
        return sb.toString();
    }

    public static void main(String[] args) {
        ConaxSubscribeAddRequest request1 = new ConaxSubscribeAddRequest();
        request1.setTransactionId(16827);
        request1.setPacketId(201);
        request1.setBegin(TimeUtils.parseDate((String)"200711010000", (String)DATE_FORMAT));
        request1.setEnd(TimeUtils.parseDate((String)"200808312359", (String)DATE_FORMAT));
        request1.setExpress(false);
        request1.getCards().add(1130000032L);
        request1.getCards().add(1130000045L);
        System.out.println(request1.makeFileName());
        System.out.println(request1.makeRequest());
        ConaxSubscribeCancelRequest request2 = new ConaxSubscribeCancelRequest();
        request2.setTransactionId(16827666);
        request2.setPacketId(201);
        request2.setBegin(TimeUtils.parseDate((String)"200711010000", (String)DATE_FORMAT));
        request2.setEnd(TimeUtils.parseDate((String)"200808312359", (String)DATE_FORMAT));
        request2.setExpress(false);
        request2.getCards().add(1130000032L);
        request2.getCards().add(1130000045L);
        System.out.println(request2.makeFileName());
        System.out.println(request2.makeRequest());
    }

    public String toString() {
        return DebugUtils.dumpObject((Object)this);
    }
}

