/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.modules.bill.server.action;

import bitel.billing.server.ActionConType;
import java.math.BigDecimal;
import java.util.Date;
import java.util.List;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import ru.bitel.bgbilling.modules.bill.common.bean.BillListFilter;
import ru.bitel.bgbilling.modules.bill.common.bean.enums.SortMode;
import ru.bitel.bgbilling.modules.bill.server.action.base.ActionBase;
import ru.bitel.bgbilling.modules.bill.server.bean.Bill;
import ru.bitel.bgbilling.modules.bill.server.bean.BillManager;
import ru.bitel.bgbilling.server.util.UserMap;
import ru.bitel.common.TimeUtils;
import ru.bitel.common.Utils;
import ru.bitel.common.model.Period;

@ActionConType(value=2)
public class ActionBill
extends ActionBase {
    public void doAction() throws Exception {
        BillListFilter billListFilter = new BillListFilter().setMonth(this.getIntParameter("m", -1)).setYear(this.getIntParameter("y", 0)).setPeriod(new Period(TimeUtils.convertStringToDate((String)this.getParameter("from", "")), TimeUtils.convertStringToDate((String)this.getParameter("until", "")))).setAccountId(this.getIntParameter("account_id", 0)).setContractTitle(this.getParameter("contract", "")).setBillNumber(this.getParameter("billNumber", "")).setPackageParamId(this.getPackageParamId()).setPackageId(this.getIntParameter("package", -1)).setDateType(this.getIntParameter("date_type", 0)).setPayedType(this.getIntParameter("payed_type", 0)).setUserType(this.getIntParameter("user_type", 0)).setUnloadType(this.getIntParameter("unload_type", 0)).setTypeIds(Utils.toIntegerList((String)this.getParameter("type", ""))).setContractLabelIds(Utils.toIntegerList((String)this.getParameter("gr", ""))).setContractLabelMode(this.getParameter("gr_mode", "or")).setAddressSortParamId(this.getAddressSortParamId()).setNameSortParam(this.getNameSortParamId()).setPrimarySortMode(this.getIntParameter("sort_mode", SortMode.CONTRACT.getCode())).setSecondarySortMode(this.getIntParameter("secondary_sort_mode", -1)).setPage(this.getPage());
        boolean getXml = Utils.notBlankString((String)this.getParameter("get_xml"));
        boolean forRegister = this.getIntParameter("forRegister", 0) == 1;
        BillManager billManager = new BillManager(this.conSlave, this.mid);
        List<Bill> payBillList = billManager.getBillList(billListFilter, getXml, forRegister);
        Document doc = this.rootNode.getOwnerDocument();
        Element table = this.createElement(this.rootNode, "table");
        Element data = this.createElement(table, "data");
        this.setPageAttribute(table, billListFilter.getPage());
        BigDecimal sum = BigDecimal.ZERO;
        StringBuilder contractAndComment = new StringBuilder();
        for (Bill payBill : payBillList) {
            Element row = this.createElement(data, "row");
            BigDecimal sumBill = payBill.getSumm();
            sum = sum.add(sumBill);
            contractAndComment.setLength(0);
            contractAndComment.append(payBill.getContractTitle());
            if (payBill.getContractComment() != null) {
                contractAndComment.append(" [ ").append(payBill.getContractComment()).append(" ]");
            }
            String user = UserMap.getUser((Integer)payBill.getUserId()).getName();
            row.setAttribute("id", String.valueOf(payBill.getId()));
            row.setAttribute("cid", String.valueOf(payBill.getContractId()));
            row.setAttribute("contract", payBill.getContractTitle());
            row.setAttribute("contract_and_comment", contractAndComment.toString());
            row.setAttribute("number", payBill.getFormatNumber());
            row.setAttribute("create_dt", TimeUtils.formatDate((Date)payBill.getCreateDate()));
            row.setAttribute("pay_dt", TimeUtils.formatDate((Date)payBill.getPayDate()));
            row.setAttribute("summ", Utils.formatBigDecimalSumm((BigDecimal)sumBill));
            row.setAttribute("sum", Utils.formatBigDecimalSumm((BigDecimal)sumBill));
            row.setAttribute("createdby", user);
            row.setAttribute("status", payBill.getStatus() == 0 ? "\u043d\u0435 \u043e\u043f\u043b\u0430\u0447\u0435\u043d" : "\u043e\u043f\u043b\u0430\u0447\u0435\u043d");
            row.setAttribute("unload_status", payBill.getUnloadStatus() == 0 ? "\u043d\u0435 \u0432\u044b\u0433\u0440\u0443\u0436\u0435\u043d" : "\u0432\u044b\u0433\u0440\u0443\u0436\u0435\u043d");
            row.setAttribute("type", String.valueOf(payBill.getTypeId()));
            row.setAttribute("type_title", Utils.maskNull((String)payBill.getTypeTitle()));
            row.setAttribute("payedby", payBill.getPayUid() > 0 ? UserMap.getUser((Integer)payBill.getPayUid()).getName() : "");
            if (forRegister) {
                row.setAttribute("address", Utils.maskNull((String)payBill.getAddress()));
                row.setAttribute("recipient", Utils.maskNull((String)payBill.getRecipient()));
            }
            if (!getXml) continue;
            this.addBillXml(doc, payBill, row);
        }
        table.setAttribute("summ", Utils.formatBigDecimalSumm((BigDecimal)sum));
        table.setAttribute("number", String.valueOf(payBillList.size()));
        this.createElement(this.rootNode, "separator").setAttribute("separator", this.moduleSetup.get("csv.separator", ","));
        this.createElement(this.rootNode, "pay").setAttribute("pay", this.moduleSetup.get("pay", "0"));
    }
}

