/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.kernel.container.web.action;

import jakarta.servlet.http.HttpServletRequest;
import java.util.AbstractMap;
import java.util.AbstractSet;
import java.util.Date;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import ru.bitel.common.ParameterMap;
import ru.bitel.common.TimeUtils;
import ru.bitel.common.Utils;

public class ActionRequest
extends ParameterMap {
    private final HttpServletRequest request;

    public ActionRequest(HttpServletRequest request) {
        this.request = request;
    }

    @Override
    public Set<Map.Entry<String, String>> entrySet() {
        final Set e = this.request.getParameterMap().entrySet();
        return new AbstractSet<Map.Entry<String, String>>(){

            @Override
            public Iterator<Map.Entry<String, String>> iterator() {
                final Iterator iter = e.iterator();
                return new Iterator<Map.Entry<String, String>>(){

                    @Override
                    public boolean hasNext() {
                        return iter.hasNext();
                    }

                    @Override
                    public Map.Entry<String, String> next() {
                        Map.Entry e = (Map.Entry)iter.next();
                        if (e.getValue() instanceof String) {
                            return e;
                        }
                        String[] val = (String[])e.getValue();
                        return new AbstractMap.SimpleEntry<String, Object>((String)e.getKey(), (val != null && val.length > 0 ? val[0] : null));
                    }

                    @Override
                    public void remove() {
                        throw new UnsupportedOperationException();
                    }
                };
            }

            @Override
            public int size() {
                return e.size();
            }
        };
    }

    @Override
    public String get(String key, String def) {
        String result = this.request.getParameter(key);
        if (Utils.isEmptyString(result)) {
            result = def;
        }
        return result;
    }

    public Date getDate(String key, Date def) {
        return this.getDate(key, "dd.MM.yyyy", def);
    }

    public Date getDate(String key, String pattern, Date def) {
        Date date = def;
        try {
            String value = this.get(key, null);
            if (!Utils.isEmptyString(value)) {
                date = TimeUtils.parseDate(value, pattern);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return date;
    }

    public Date getDateTime(String key, Date def) {
        Date date = def;
        try {
            String value = this.get(key, null);
            if (!Utils.isEmptyString(value)) {
                date = TimeUtils.parseDate(value, "dd.MM.yyyy HH:mm:ss");
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return date;
    }
}

