/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.kernel.task.client;

import bitel.billing.module.common.BGComboBox;
import bitel.billing.module.common.BGTextArea;
import java.awt.Color;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import java.util.List;
import javax.swing.BorderFactory;
import javax.swing.DefaultComboBoxModel;
import javax.swing.DefaultListCellRenderer;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTabbedPane;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.SwingUtilities;
import org.json.JSONArray;
import org.json.JSONObject;
import ru.bitel.bgbilling.client.common.BGConfigEditorPane;
import ru.bitel.bgbilling.client.common.BGEditorDialog;
import ru.bitel.bgbilling.client.common.BGUTable;
import ru.bitel.bgbilling.client.common.table.model.ParameterTableModel;
import ru.bitel.bgbilling.client.util.ClientUtils;
import ru.bitel.bgbilling.common.model.KeyValue;
import ru.bitel.bgbilling.kernel.task.client.SchedulerTaskPanel;
import ru.bitel.bgbilling.kernel.task.common.bean.DependentTask;
import ru.bitel.bgbilling.kernel.task.common.bean.TaskStatus;
import ru.bitel.common.Preferences;
import ru.bitel.common.Utils;
import ru.bitel.common.client.BGOptionPane;
import ru.bitel.common.client.BGSwingUtilites;
import ru.bitel.common.client.BGUComboBox;
import ru.bitel.common.client.list.BGUList;
import ru.bitel.common.model.IdTitle;

public class TaskDependentEditor
extends BGEditorDialog<DependentTask> {
    private final BGUComboBox<KeyValue> modules = new BGUComboBox();
    private BGComboBox<TaskStatus> statusComboBox = new BGComboBox();
    private BGUComboBox<IdTitle> priorityComboBox = new BGUComboBox();
    private BGUList<KeyValue> taskList = new BGUList();
    private BGConfigEditorPane params = new BGConfigEditorPane();
    private BGTextArea comment = new BGTextArea(2, 60);
    private SchedulerTaskPanel parentPanel;
    private JTabbedPane tabbedPane = new JTabbedPane();
    private ParameterTableModel parameterTableModel = new ParameterTableModel();
    private List<IdTitle> priorityItems = new ArrayList<IdTitle>();

    public TaskDependentEditor(String title, DependentTask data, SchedulerTaskPanel parent) {
        super(title, data);
        this.parentPanel = parent;
    }

    @Override
    public void doDialogPanel() {
        this.modules.setData(this.parentPanel.modules.stream().map(current -> "-1".equals(current.getKey()) ? new BGUComboBox.Separator(current.getValue()) : new KeyValue(current.getKey(), current.getValue())).toList());
        this.taskList.addListSelectionListener(e -> {
            if (e.getValueIsAdjusting()) {
                this.loadTaskParameters(((KeyValue)this.taskList.getSelectedValue()).getKey(), "");
            }
        });
        this.modules.addItemListener(e -> {
            if (e.getStateChange() == 1) {
                KeyValue keyValue = (KeyValue)this.modules.getSelectedItem();
                if (keyValue != null && keyValue.getKey() != null && !keyValue.getKey().equals("-1")) {
                    try {
                        this.taskList.setData(this.parentPanel.getSchedulerService().getAvailableSchedulerTasks(keyValue.getKey()));
                        ClientUtils.setKeyValueListSelection(this.taskList, ((DependentTask)this.data).getClassName(), null);
                    }
                    catch (Exception ex) {
                        ClientUtils.showErrorMessageDialog(ex);
                    }
                } else {
                    this.taskList.setData(new ArrayList());
                }
            }
        });
        this.priorityItems.add(new IdTitle(0, "\u043f\u0430\u043a\u0435\u0442\u0430"));
        this.priorityItems.addAll(this.parentPanel.priorityItems);
        this.priorityComboBox.setData(this.priorityItems);
        this.statusComboBox.setModel(new DefaultComboBoxModel<TaskStatus>(TaskStatus.values()));
        this.taskList.setSelectionMode(0);
        this.taskList.setCellRenderer(new DefaultListCellRenderer(){

            @Override
            public Component getListCellRendererComponent(JList<?> list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
                JLabel component = (JLabel)super.getListCellRendererComponent(list, value, index, isSelected, cellHasFocus);
                component.setBorder(BorderFactory.createEmptyBorder(0, 5, 0, 5));
                return component;
            }
        });
        this.taskList.setBounds(2, 2, 2, 2);
        this.tabbedPane.add("\u041f\u0430\u0440\u0430\u043c\u0435\u0442\u0440\u044b", this.getParamTablePanel());
        this.tabbedPane.add("\u041a\u043e\u043d\u0444\u0438\u0433", BGSwingUtilites.wrapScrollPane(this.params, 800, 100));
        this.panel.add((Component)this.getTopPanel(), new GridBagConstraints(0, -1, 1, 1, 1.0, 0.0, 10, 2, new Insets(5, 5, 5, 5), 0, 0));
        this.panel.add((Component)BGSwingUtilites.wrapScrollPane(this.taskList, 810, 180), new GridBagConstraints(0, -1, 1, 1, 1.0, 1.0, 10, 1, new Insets(5, 5, 0, 5), 0, 0));
        this.panel.add((Component)this.tabbedPane, new GridBagConstraints(0, -1, 1, 1, 1.0, 1.0, 10, 1, new Insets(2, 5, 0, 5), 0, 0));
        this.panel.add((Component)new JLabel("\u041a\u043e\u043c\u043c\u0435\u043d\u0442\u0430\u0440\u0438\u0439"), new GridBagConstraints(0, -1, 1, 1, 0.0, 0.0, 17, 0, new Insets(5, 10, 0, 5), 0, 0));
        this.panel.add((Component)new JScrollPane(this.comment), new GridBagConstraints(0, -1, 1, 1, 1.0, 1.0, 10, 1, new Insets(2, 5, 10, 5), 0, 0));
        Object moduleId = ((DependentTask)this.data).isPlugin() ? "p" + ((DependentTask)this.data).getModuleId() : String.valueOf(((DependentTask)this.data).getModuleId());
        for (KeyValue keyValue : this.parentPanel.modules) {
            if (!((String)moduleId).equals(keyValue.getKey())) continue;
            this.modules.setSelectedItem(keyValue);
            break;
        }
        for (IdTitle idTitle : this.priorityItems) {
            if (idTitle.getId() != ((DependentTask)this.data).getPriority()) continue;
            this.priorityComboBox.setSelectedItem(idTitle);
            break;
        }
        this.statusComboBox.setSelectedItem((Object)((DependentTask)this.data).getTaskStatus());
        this.params.setText(((DependentTask)this.data).getParams());
        this.comment.setText(((DependentTask)this.data).getComment());
        boolean enabled = ((DependentTask)this.data).getModuleId() == -2;
        this.modules.setEnabled(enabled);
        this.taskList.setEnabled(enabled);
        this.loadTaskParameters(((DependentTask)this.data).getClassName(), ((DependentTask)this.data).getParams());
    }

    private void loadTaskParameters(String className, String config) {
        try {
            Preferences preferences = new Preferences(config, "\n");
            JSONArray array = new JSONArray(this.parentPanel.getSchedulerService().getTaskParameters(className));
            ArrayList<JSONObject> list = new ArrayList<JSONObject>();
            for (int index = 0; index < array.length(); ++index) {
                JSONObject json = array.getJSONObject(index);
                list.add(json.put("value", (Object)preferences.get(json.optString("key"), json.optString("defaultValue"))));
            }
            this.parameterTableModel.setData(list);
        }
        catch (Exception ex) {
            ClientUtils.showErrorMessageDialog(ex);
        }
    }

    private void updateConfigParam(JSONObject json) {
        this.params.setText(Utils.updateConfigParam(this.params.getText(), json.optString("key"), json.optString("value"), json.optString("defaultValue")));
    }

    private JPanel getParamTablePanel() {
        BGUTable table = new BGUTable(this.parameterTableModel);
        table.setSelectionMode(0);
        table.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent event) {
                if (SwingUtilities.isLeftMouseButton(event) && event.getClickCount() == 2) {
                    new ParameterEditor("\u0420\u0435\u0434\u0430\u043a\u0442\u043e\u0440 \u043f\u0430\u0440\u0430\u043c\u0435\u0442\u0440\u0430", (JSONObject)TaskDependentEditor.this.parameterTableModel.getSelectedRow()).open();
                }
            }
        });
        JPanel panel = new JPanel(new GridBagLayout());
        panel.add((Component)BGSwingUtilites.wrapScrollPane(table, 500, 100), new GridBagConstraints(0, -1, 1, 1, 1.0, 1.0, 10, 1, new Insets(2, 2, 2, 2), 0, 0));
        return panel;
    }

    private JPanel getTopPanel() {
        JPanel panel = new JPanel(new GridBagLayout());
        panel.add((Component)new JLabel("\u041c\u043e\u0434\u0443\u043b\u044c: "), new GridBagConstraints(-1, 0, 1, 1, 0.0, 0.0, 10, 2, new Insets(0, 0, 0, 5), 0, 0));
        panel.add(this.modules, new GridBagConstraints(-1, 0, 1, 1, 1.0, 0.0, 10, 2, new Insets(0, 5, 0, 0), 0, 0));
        panel.add((Component)new JLabel("\u0421\u0442\u0430\u0442\u0443\u0441: "), new GridBagConstraints(-1, 0, 1, 1, 0.0, 0.0, 10, 2, new Insets(0, 20, 0, 5), 0, 0));
        panel.add(this.statusComboBox, new GridBagConstraints(-1, 0, 1, 1, 0.0, 0.0, 10, 2, new Insets(0, 5, 0, 0), 0, 0));
        panel.add((Component)new JLabel("\u041f\u0440\u0438\u043e\u0440\u0438\u0442\u0435\u0442: "), new GridBagConstraints(-1, 0, 1, 1, 0.0, 0.0, 10, 2, new Insets(0, 20, 0, 5), 0, 0));
        panel.add(this.priorityComboBox, new GridBagConstraints(-1, 0, 1, 1, 0.0, 0.0, 10, 2, new Insets(0, 5, 0, 0), 0, 0));
        return panel;
    }

    @Override
    public boolean doApply() throws Exception {
        String key;
        String string = key = this.modules.getSelectedItem() != null ? ((KeyValue)this.modules.getSelectedItem()).getKey() : null;
        if (key == null || "-2".equals(key)) {
            ClientUtils.showErrorMessageDialog("\u0412\u044b\u0431\u0435\u0440\u0438\u0442\u0435 \u043c\u043e\u0434\u0443\u043b\u044c");
            return false;
        }
        KeyValue keyValue = (KeyValue)this.taskList.getSelectedValue();
        if (keyValue == null) {
            ClientUtils.showErrorMessageDialog("\u0412\u044b\u0431\u0435\u0440\u0438\u0442\u0435 \u0437\u0430\u0434\u0430\u0447\u0443");
            return false;
        }
        ((DependentTask)this.data).setPlugin(key.startsWith("p"));
        ((DependentTask)this.data).setModuleId(Utils.parseInt(((DependentTask)this.data).isPlugin() ? key.substring(1) : key));
        ((DependentTask)this.data).setTaskStatus(this.statusComboBox.getSelectedItem());
        ((DependentTask)this.data).setClassName(keyValue.getKey());
        ((DependentTask)this.data).setTitle(keyValue.getValue());
        ((DependentTask)this.data).setParams(this.params.getText());
        ((DependentTask)this.data).setPriority(((IdTitle)this.priorityComboBox.getSelectedItem()).getId());
        ((DependentTask)this.data).setComment(this.comment.getText());
        return true;
    }

    @Override
    protected BGOptionPane getBGOptionPane() {
        return new BGOptionPane(this.panel, this.title){

            @Override
            protected void doCancel() {
                TaskDependentEditor.this.data = null;
            }
        };
    }

    class ParameterEditor
    extends BGEditorDialog<JSONObject> {
        private JTextField paramKeyField;
        private JTextField paramValueField;
        private JTextArea paramTitle;

        public ParameterEditor(String title, JSONObject data) {
            super(title, data);
            this.paramKeyField = new JTextField(30);
            this.paramValueField = new JTextField(30);
            this.paramTitle = new JTextArea(3, 30);
        }

        @Override
        public void doDialogPanel() {
            Color bgColor = this.paramKeyField.getBackground();
            this.paramKeyField.setEditable(false);
            this.paramKeyField.setBackground(bgColor);
            this.paramTitle.setEditable(false);
            this.paramTitle.setMargin(new Insets(3, 3, 3, 3));
            this.addFieldV("\u041f\u0430\u0440\u0430\u043c\u0435\u0442\u0440:", this.paramKeyField);
            this.addFieldV("\u0417\u043d\u0430\u0447\u0435\u043d\u0438\u0435:", this.paramValueField);
            this.addFieldV("\u041e\u043f\u0438\u0441\u0430\u043d\u0438\u0435:", BGSwingUtilites.wrapScrollPane(this.paramTitle, 500, 100));
            this.paramKeyField.setText(((JSONObject)this.data).optString("key"));
            this.paramValueField.setText(((JSONObject)this.data).optString("value"));
            this.paramTitle.setText("\u0417\u043d\u0430\u0447\u0435\u043d\u0438\u0435 \u043f\u043e \u0443\u043c\u043e\u043b\u0447\u0430\u043d\u0438\u044e: " + ((JSONObject)this.data).optString("defaultValue") + "\n\n" + ((JSONObject)this.data).optString("title"));
        }

        @Override
        public boolean doApply() throws Exception {
            ((JSONObject)this.data).put("value", (Object)this.paramValueField.getText());
            TaskDependentEditor.this.updateConfigParam((JSONObject)this.data);
            TaskDependentEditor.this.parameterTableModel.fireTableDataChanged();
            return true;
        }
    }
}

