/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.kernel.contract.pattern.client;

import bitel.billing.module.services.ServiceEditorListPanel;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.util.List;
import javax.swing.JPanel;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import ru.bitel.bgbilling.client.common.BGPanel;
import ru.bitel.bgbilling.client.util.ClientUtils;
import ru.bitel.bgbilling.common.bean.Request;
import ru.bitel.common.XMLUtils;

public class PatternModuleServicePanel
extends BGPanel {
    private int moduleId = -1;
    private JPanel editPanel = null;
    private ServiceEditorListPanel listPanel = new ServiceEditorListPanel();

    public PatternModuleServicePanel(int moduleId) {
        this.moduleId = moduleId;
        this.jbInit();
    }

    public void setMid(int moduleId) {
        this.moduleId = moduleId;
    }

    public int getMid() {
        return this.moduleId;
    }

    private void jbInit() {
        this.setLayout(new GridBagLayout());
        this.add((Component)this.getEditPanel(), new GridBagConstraints(0, 1, 1, 1, 1.0, 1.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
    }

    public void setData(Element pattern) throws Exception {
        Request request = new Request();
        request.setModule("contract");
        request.setAction("ModuleServices");
        request.setModuleId(this.moduleId);
        request.setAttribute("treeMode", "true");
        Document doc = this.getDocument(request);
        if (ClientUtils.checkStatus(doc)) {
            Node treeNode = XMLUtils.selectNode(doc, "//tree");
            this.listPanel.buildList(treeNode, "");
        }
        if (pattern != null) {
            StringBuilder selected = new StringBuilder();
            for (Element itemElement : XMLUtils.selectElements(pattern, "//*[@mid=" + this.moduleId + "]/addServices/item")) {
                selected.append(selected.length() > 0 ? "," : "").append(itemElement.getAttribute("sid"));
            }
            this.listPanel.selectByIds(selected.toString());
        }
    }

    private JPanel getEditPanel() {
        if (this.editPanel == null) {
            this.editPanel = new JPanel();
            this.editPanel.setLayout(new GridBagLayout());
            this.editPanel.add((Component)this.listPanel, new GridBagConstraints(0, 0, 1, 2, 1.0, 1.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
        }
        return this.editPanel;
    }

    public void reset() {
    }

    public void serialise(List<String> list) {
        list.addAll(this.listPanel.getSelectedIdList());
    }

    public void serialise(Element element) {
        Document doc = element.getOwnerDocument();
        Element module = doc.createElement("services");
        element.appendChild(module);
        module.setAttribute("mid", String.valueOf(this.moduleId));
        Element addServices = doc.createElement("addServices");
        module.appendChild(addServices);
        for (String sid : this.listPanel.getSelectedIdList()) {
            Element item = XMLUtils.createElement(addServices, "item");
            item.setAttribute("sid", String.valueOf(sid));
        }
    }
}

