/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.plugins.helpdesk.server.action.web;

import java.math.BigDecimal;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import ru.bitel.bgbilling.kernel.event.EventProcessor;
import ru.bitel.bgbilling.kernel.event.common.QueueEvent;
import ru.bitel.bgbilling.kernel.module.common.bean.User;
import ru.bitel.bgbilling.kernel.module.server.bean.UserManager;
import ru.bitel.bgbilling.plugins.helpdesk.common.bean.Message;
import ru.bitel.bgbilling.plugins.helpdesk.common.bean.PackageContract;
import ru.bitel.bgbilling.plugins.helpdesk.common.bean.Topic;
import ru.bitel.bgbilling.plugins.helpdesk.server.action.WebActionBase;
import ru.bitel.bgbilling.plugins.helpdesk.server.bean.HelpDeskDirectoryManager;
import ru.bitel.bgbilling.plugins.helpdesk.server.bean.PackageManager;
import ru.bitel.bgbilling.plugins.helpdesk.server.bean.TopicManager;
import ru.bitel.bgbilling.plugins.helpdesk.server.bean.event.TopicWillBeCreated;
import ru.bitel.bgbilling.plugins.helpdesk.server.notification.EmailNotification;
import ru.bitel.bgbilling.plugins.helpdesk.server.notification.TelegramNotification;
import ru.bitel.common.Utils;

public class ActionUpdateTopic
extends WebActionBase {
    private Topic topic = null;
    private Message message = null;
    private String error = null;

    public void doAction() throws Exception {
        String packageMode = this.getMode();
        if ("off".equals(packageMode)) {
            this.error = "offMode";
        } else {
            Object topic_title = this.getParameter("topic_title");
            String topicCommCategory = this.getParameter("topic.comm.category", "-2");
            int categoryId = -1;
            int subCategoryId = -2;
            String[] catIds = topicCommCategory.split("_");
            if (catIds.length == 2) {
                categoryId = Utils.parseInt((String)catIds[0], (int)-2);
                subCategoryId = Utils.parseInt((String)catIds[1], (int)-2);
            }
            int round = this.getIntParameter("round", -2);
            String addTextToSubject = this.getParameter("topic.additionalTextToSubject.values");
            String message_body = this.getParameter("message_body");
            if (round == 1) {
                this.eventThrow((String)topic_title, categoryId, subCategoryId, round, message_body);
                return;
            }
            int topic_comm = this.getIntParameter("topic.comm.mode", 0);
            PackageManager packageManager = new PackageManager(this.con, this.plugin);
            boolean packageEnabled = "package".equals(packageMode);
            if (packageEnabled && !packageManager.hasActivePackage(this.cid)) {
                this.error = "activePackageNotFound";
            } else if (topic_title == null || ((String)topic_title).isEmpty()) {
                this.error = "subjectNotEmpty";
            } else if (message_body == null || message_body.trim().isEmpty()) {
                this.error = "bodyNotEmpty";
            } else if (!this.checkCategory(categoryId, subCategoryId)) {
                this.error = "didNotSetCategory";
            } else {
                if (addTextToSubject != null && !addTextToSubject.equals("\u041d\u0435 \u0432\u044b\u0431\u0440\u0430\u043d\u043e")) {
                    topic_title = "[" + addTextToSubject + "] " + (String)topic_title;
                }
                TopicManager topicManager = new TopicManager(this.con, this.plugin);
                this.topic = new Topic();
                this.topic.setContractId(this.cid);
                this.topic.setClosed(false);
                this.topic.setComm(topic_comm);
                this.topic.setCommValue(this.getParameter("topic.comm.value", ""));
                this.topic.setDate(new Date());
                BigDecimal cost = this.plugin.getSetup().getBigDecimal("topic.default.cost." + this.cid, null);
                if (cost == null) {
                    cost = this.plugin.getSetup().getBigDecimal("topic.default.cost", new BigDecimal("0.00"));
                }
                this.topic.setCost(cost);
                this.topic.setTitle((String)topic_title);
                this.topic.setAutoClose(this.plugin.getSetup().getBoolean("topic.avto.closed.default", false));
                this.topic.setCategoryId(categoryId);
                this.topic.setSubcategoryId(subCategoryId);
                TopicWillBeCreated event = new TopicWillBeCreated(this.topic, 2, this.plugin.getPluginUID(), message_body);
                if (!event.isAllowCreate()) {
                    this.dataMap.put("result", false);
                    this.dataMap.put("error", event.getErrorMessage() != null ? event.getErrorMessage() : "\u0421\u043a\u0440\u0438\u043f\u0442 \u043d\u0435 \u0434\u0430\u0435\u0442 \u0441\u043e\u0437\u0434\u0430\u0442\u044c \u0442\u0435\u043c\u0443");
                    return;
                }
                topicManager.updateTopic(this.topic);
                while (packageEnabled) {
                    PackageContract pkg = packageManager.getActivePackageContract(this.cid);
                    if (pkg == null) {
                        this.error = "activePackageNotFound";
                        break;
                    }
                    if (packageManager.updatePackageContractCount(pkg.getId(), pkg.getCountUse(), 1) != 1) continue;
                    topicManager.updateTopicPackage(this.topic.getId(), pkg.getId());
                    break;
                }
                this.message = Message.builder().setTopicId(this.topic.getId()).setBody(message_body).setDateFrom(new Date()).setUserIdFrom(0).build();
                topicManager.updateTopicMessage(this.message);
                TelegramNotification telegramNotification = new TelegramNotification();
                int userId = this.topic.getUserId();
                if (userId > 0) {
                    User user = (User)new UserManager(this.con).get(userId);
                    if (user != null) {
                        EmailNotification.sendMessage(user.getConfigSetup().get("helpdesk.mail", null), this.topic, message_body);
                        telegramNotification.sendMessage(user.getConfigSetup().get("telegram.user.id", null), user.getId(), this.topic, this.message, telegramNotification.getMessageText(this.topic, this.message, null, true));
                    }
                } else {
                    telegramNotification.sendMessage(this.topic, this.message, telegramNotification.getMessageText(this.topic, this.message, null, false));
                }
            }
        }
        this.setData();
    }

    protected void setDataToRequest() throws Exception {
        if (this.error == null) {
            this.dataMap.put("result", true);
            this.dataMap.put("topic", this.topic);
            HashMap<Integer, String> userNameMap = new HashMap<Integer, String>();
            userNameMap.put(this.topic.getUserId(), this.topic.getUserName());
            this.dataMap.put("userNameMap", userNameMap);
        } else {
            this.dataMap.put("result", false);
            this.dataMap.put("error", this.error);
        }
    }

    private void eventThrow(String title, int categoryId, int subCategoryId, int round, String message) throws Exception {
        Topic topic = new Topic();
        topic.setContractId(this.cid);
        topic.setTitle(title);
        topic.setCategoryId(categoryId);
        topic.setSubcategoryId(subCategoryId);
        TopicWillBeCreated event = new TopicWillBeCreated(topic, round, this.plugin.getPluginUID(), message);
        EventProcessor.getInstance().request((QueueEvent)event);
        this.dataMap.put("errorMessage", event.getErrorMessage());
        this.dataMap.put("result", event.isAllowCreate());
    }

    private boolean checkCategory(int categoryId, int subCategoryId) throws Exception {
        HelpDeskDirectoryManager manager = new HelpDeskDirectoryManager(this.con, this.plugin);
        int groupId = manager.getContractGroupId(this.cid);
        Map<Integer, List<Integer>> map = manager.getSubCategoryIds(groupId);
        if (map.size() == 0 && categoryId < 1) {
            return true;
        }
        return map.containsKey(categoryId) && (map.get(categoryId) == null || map.get(categoryId).contains(subCategoryId));
    }
}

