/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.plugins.cashcheck.server;

import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import ru.bitel.bgbilling.common.BGException;
import ru.bitel.bgbilling.kernel.contract.balance.server.event.PaymentEvent;
import ru.bitel.bgbilling.kernel.event.EventListener;
import ru.bitel.bgbilling.kernel.event.EventListenerContext;
import ru.bitel.bgbilling.kernel.event.EventProcessor;
import ru.bitel.bgbilling.kernel.event.common.Event;
import ru.bitel.bgbilling.kernel.plugin.server.inpoint.OnDestroyServer;
import ru.bitel.bgbilling.kernel.plugin.server.inpoint.OnInitServer;
import ru.bitel.bgbilling.plugins.cashcheck.server.bean.AutoprintProcessor;
import ru.bitel.bgbilling.plugins.cashcheck.server.bean.PrinterManager;

public class PluginServerListener
implements OnInitServer,
OnDestroyServer,
EventListener<Event> {
    private static final Logger log = LogManager.getLogger();

    public void onInitServer(String applicationName) {
        PrinterManager.resetCache();
        if (!"server".equals(applicationName)) {
            return;
        }
        try {
            EventProcessor.getInstance().addListener((EventListener)this, PaymentEvent.class);
        }
        catch (BGException e) {
            log.error("error add event listener", (Throwable)e);
        }
    }

    public void onDestroyServer(String applicationName) {
        if (!"server".equals(applicationName)) {
            return;
        }
        try {
            EventProcessor.getInstance().removeListener((EventListener)this);
        }
        catch (BGException e) {
            log.error("error remove event listener", (Throwable)e);
        }
    }

    public void notify(Event event, EventListenerContext ctx) throws BGException {
        PaymentEvent pEvent;
        if (event instanceof PaymentEvent && !(pEvent = (PaymentEvent)event).isEditMode()) {
            AutoprintProcessor.processNewPayment(PrinterManager.PaymentPrintMode.auto, pEvent.getPayment(), ctx.getSetup(), ctx.getConnectionSet().getConnection(), ctx.getConnectionSet().getSlaveConnection());
        }
    }
}

