/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.kernel.customer.client.parameter;

import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.util.Optional;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JTextField;
import ru.bitel.bgbilling.client.common.ClientContext;
import ru.bitel.bgbilling.client.util.ClientUtils;
import ru.bitel.bgbilling.kernel.customer.client.parameter.CustomerParamHistoryDialog;
import ru.bitel.bgbilling.kernel.customer.client.parameter.CustomerParamPanel;
import ru.bitel.bgbilling.kernel.customer.common.bean.Customer;
import ru.bitel.common.client.BGSwingUtilites;

public class CustomerParamTextField
extends JPanel {
    private String title = "";
    private String oldValue = "";
    private final String fieldKey;
    private JTextField textField;
    private final CustomerParamPanel customerParamPanel;

    public CustomerParamTextField(Customer.Keys customerKey, int column, String regexp, CustomerParamPanel customerParamPanel) {
        this(customerKey.description(), column, customerKey.key(), regexp, customerParamPanel);
    }

    public CustomerParamTextField(String title, int column, final String fieldKey, final String regexp, final CustomerParamPanel customerParamPanel) {
        super(new GridBagLayout());
        this.title = title;
        this.textField = new JTextField(column);
        this.fieldKey = fieldKey;
        this.customerParamPanel = customerParamPanel;
        this.add((Component)this.textField, new GridBagConstraints(-1, 0, 1, 1, 1.0, 0.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
        BGSwingUtilites.handleRMouseClicked(this.textField, e -> {
            JPopupMenu popupMenu = new JPopupMenu();
            popupMenu.add("\u041a\u043e\u043f\u0438\u0440\u043e\u0432\u0430\u0442\u044c \u0437\u043d\u0430\u0447\u0435\u043d\u0438\u0435 \u0432 \u0431\u0443\u0444\u0435\u0440 \u043e\u0431\u043c\u0435\u043d\u0430").addActionListener(a -> BGSwingUtilites.clipboardCopy(Optional.ofNullable(this.textField.getText()).orElse("")));
            popupMenu.add("\u0418\u0441\u0442\u043e\u0440\u0438\u044f \u0438\u0437\u043c\u0435\u043d\u0435\u043d\u0438\u044f \u043f\u0430\u0440\u0430\u043c\u0435\u0442\u0440\u0430").addActionListener(a -> new CustomerParamHistoryDialog(title, fieldKey, customerParamPanel));
            popupMenu.show(this.textField, e.getX(), e.getY());
        });
        this.textField.addFocusListener(new FocusListener(){

            @Override
            public void focusLost(FocusEvent e) {
                String text = CustomerParamTextField.this.textField.getText();
                if (((ClientContext)customerParamPanel.getContext()).getCustomerId() > 0 && !CustomerParamTextField.this.oldValue.equals(text)) {
                    if (regexp != null && !text.matches(regexp)) {
                        ClientUtils.showErrorMessageDialog("\u0412\u0432\u0435\u0434\u0435\u043d\u043d\u043e\u0435 \u0437\u043d\u0430\u0447\u0435\u043d\u0438\u0435 \u043d\u0435 \u0441\u043e\u043e\u0442\u0432\u0435\u0442\u0441\u0442\u0432\u0443\u0435\u0442 \u0448\u0430\u0431\u043b\u043e\u043d\u0443 - " + regexp);
                        return;
                    }
                    customerParamPanel.updateCustomerValue(fieldKey, text);
                    CustomerParamTextField.this.oldValue = text;
                }
            }

            @Override
            public void focusGained(FocusEvent e) {
            }
        });
    }

    public void setData() {
        Object object = ((ClientContext)this.customerParamPanel.getContext()).getCustomer().optQuery(this.fieldKey);
        this.oldValue = object == null ? "" : String.valueOf(object);
        this.textField.setText(this.oldValue);
    }

    public String getFieldKey() {
        return this.fieldKey;
    }

    public String getTitle() {
        return this.title;
    }
}

