/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.modules.ipn.server.bean;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import ru.bitel.bgbilling.modules.ipn.server.bean.GateAddress;
import ru.bitel.common.Utils;
import ru.bitel.oss.kernel.entity.common.bean.AddressStruct;

public class GateAddressManager {
    protected int mid = -1;
    protected Connection con;

    public GateAddressManager(Connection con, int mid) {
        this.mid = mid;
        this.con = con;
    }

    public GateAddress getAddreeesByGateId(int gateId) {
        GateAddress result = null;
        try {
            String query = "SELECT * FROM ipn_gate_address_" + this.mid + "AS address WHERE gid=?";
            PreparedStatement ps = this.con.prepareStatement(query);
            ps.setInt(1, gateId);
            ResultSet rs = ps.executeQuery();
            if (rs.next()) {
                result = new GateAddress();
                result.setGateId(gateId);
                GateAddressManager.loadFromResultSet(rs, result);
            }
            rs.close();
            ps.close();
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        return result;
    }

    @Deprecated
    public GateAddress getAddreeesByGateID(int gateId) {
        return this.getAddreeesByGateId(gateId);
    }

    public static void loadFromResultSet(ResultSet rs, GateAddress gateAddress) throws SQLException {
        gateAddress.setId(rs.getInt("address.id"));
        gateAddress.setHouseId(rs.getInt("address.hid"));
        gateAddress.setFrac(rs.getString("address.frac"));
        gateAddress.setPod(rs.getInt("address.pod"));
        gateAddress.setFloor(rs.getInt("address.floor"));
        gateAddress.setAddress(rs.getString("address.address"));
    }

    public void updateAddress(int gateID, GateAddress address) {
        String query = null;
        PreparedStatement ps = null;
        try {
            if (address.getHouseId() < 0) {
                query = "DELETE FROM ipn_gate_address_" + this.mid + "  WHERE gid=?";
                ps = this.con.prepareStatement(query);
                ps.setInt(1, gateID);
                ps.executeUpdate();
                return;
            }
            query = "UPDATE ipn_gate_address_" + this.mid + " SET hid=?,  frac=?, pod=?, floor=?, address=?  WHERE gid=?";
            ps = this.con.prepareStatement(query);
            this.setParamsToPS(gateID, address, ps);
            if (ps.executeUpdate() == 0) {
                ps.close();
                query = "INSERT INTO ipn_gate_address_" + this.mid + " SET hid=?, frac=?, pod=?, floor=?, address=?, gid=?";
                ps = this.con.prepareStatement(query);
                this.setParamsToPS(gateID, address, ps);
                ps.executeUpdate();
            }
            ps.close();
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    private void setParamsToPS(int gateID, GateAddress address, PreparedStatement ps) throws SQLException {
        ps.setInt(1, address.getHouseId());
        ps.setString(2, address.getFrac());
        ps.setInt(3, address.getPod());
        ps.setInt(4, address.getFloor());
        ps.setString(5, address.getAddress());
        ps.setInt(6, gateID);
    }

    public AddressStruct getAddressStruct(GateAddress address) {
        AddressStruct addressStruct = new AddressStruct();
        try {
            ResultSet rs;
            String query = "SELECT aarea.title as area, acity.title as city,  ahouse.frac as frac, ahouse.house as house, ahouse.box_index as idx,  aquarter.title as quarter,  astreet.title as street  FROM address_house as ahouse  LEFT JOIN address_area as aarea ON ahouse.areaid = aarea.id LEFT JOIN address_street as astreet ON ahouse.streetid = astreet.id LEFT JOIN address_city as acity ON astreet.cityid = acity.id LEFT JOIN address_quarter as aquarter ON ahouse.quarterid = aquarter.id WHERE ahouse.id = " + address.getHouseId();
            if (!Utils.isEmptyString((String)address.getFrac())) {
                query = query + " AND ahouse.frac = ?";
            }
            PreparedStatement ps = this.con.prepareStatement(query);
            if (!Utils.isEmptyString((String)address.getFrac())) {
                ps.setString(1, address.getFrac());
            }
            if ((rs = ps.executeQuery()).next()) {
                addressStruct.setArea(rs.getString("area"));
                addressStruct.setCity(rs.getString("city"));
                if (address.getFloor() >= 0) {
                    addressStruct.setFloor(String.valueOf(address.getFloor()));
                }
                addressStruct.setFrac(rs.getString("frac"));
                addressStruct.setHouse(rs.getString("house"));
                addressStruct.setIndex(rs.getString("idx"));
                if (address.getPod() >= 0) {
                    addressStruct.setPod(String.valueOf(address.getPod()));
                }
                addressStruct.setQuarter(rs.getString("quarter"));
                addressStruct.setStreet(rs.getString("street"));
            }
            rs.close();
            ps.close();
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        return addressStruct;
    }
}

