/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.plugins.documents.server.bean.pattern;

import java.sql.Connection;
import java.util.List;
import java.util.Map;
import ru.bitel.bgbilling.common.BGIllegalArgumentException;
import ru.bitel.bgbilling.plugins.documents.common.bean.Document;
import ru.bitel.bgbilling.plugins.documents.common.bean.DocumentPattern;
import ru.bitel.bgbilling.plugins.documents.common.bean.SupportedFileFormat;
import ru.bitel.bgbilling.plugins.documents.server.bean.pattern.DocumentProcessor;
import ru.bitel.bgbilling.plugins.documents.server.bean.pattern.DocxDocumentProcessor;
import ru.bitel.bgbilling.plugins.documents.server.bean.pattern.OdtDocumentProcessor;
import ru.bitel.bgbilling.plugins.documents.server.bean.pattern.XlsxDocumentProcessor;

public class DocumentProcessorFactory {
    private static DocumentProcessorFactory instance;

    private DocumentProcessorFactory() {
    }

    public static DocumentProcessorFactory getInstance() {
        if (instance == null) {
            instance = new DocumentProcessorFactory();
        }
        return instance;
    }

    public DocumentProcessor getProcessor(Connection con, Document document, DocumentPattern pattern, SupportedFileFormat fileFormat, Map<String, Object> variableData, Map<String, List<Map<String, String>>> tableData) throws BGIllegalArgumentException {
        return switch (fileFormat) {
            case SupportedFileFormat.DOCX -> new DocxDocumentProcessor(con, document, pattern, variableData, tableData);
            case SupportedFileFormat.XLSX -> new XlsxDocumentProcessor(con, document, pattern, variableData);
            case SupportedFileFormat.ODT -> new OdtDocumentProcessor(con, document, pattern, variableData, tableData);
            default -> throw new BGIllegalArgumentException();
        };
    }
}

