/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.modules.rscm.server.tariff.tree;

import java.math.BigDecimal;
import ru.bitel.bgbilling.kernel.tariff.server.tree.DefaultTariffTreeNode;
import ru.bitel.bgbilling.modules.rscm.server.tariff.RscmServiceCost;
import ru.bitel.bgbilling.modules.rscm.server.tariff.RscmTariffContext;
import ru.bitel.bgbilling.modules.rscm.server.tariff.RscmTariffRequest;
import ru.bitel.common.ParameterMap;

public class ServiceUnitCostTariffTreeNode
extends DefaultTariffTreeNode<RscmTariffRequest, RscmTariffContext> {
    private final BigDecimal cost;
    private final String costMode;
    private final BigDecimal divisor;
    private final int tariffVarId;

    public ServiceUnitCostTariffTreeNode(int id, ParameterMap parameterMap) {
        super(id, parameterMap);
        this.cost = parameterMap.getBigDecimal("cost", BigDecimal.ZERO);
        this.divisor = parameterMap.getBigDecimal("col", BigDecimal.ONE);
        this.costMode = parameterMap.get("costMode", "const");
        this.tariffVarId = parameterMap.getInt("tariffVarId", 0);
        if (this.getLogger().isDebugEnabled()) {
            this.getLogger().debug("cost = {}; divisor = {}; costMode = {}; tariffVarId = {}", new Object[]{this.cost, this.divisor, this.costMode, this.tariffVarId});
        }
    }

    protected int executeImpl(Long treeNodeId, RscmTariffRequest tariffRequest, RscmTariffContext tariffContext) {
        BigDecimal inCost = this.cost;
        this.getLogger().debug("inCost = {}; costMode = {}; divisor = {}", new Object[]{inCost, this.costMode, this.divisor});
        if ("var".equals(this.costMode)) {
            String value = tariffRequest.getContractTariffVarValue(this.tariffVarId);
            this.getLogger().debug("value = {}; tariffVarId = {}", (Object)value, (Object)this.tariffVarId);
            if (value != null) {
                inCost = new BigDecimal(value);
                this.getLogger().debug("inCost = {}", (Object)inCost);
            }
        }
        ((RscmServiceCost)tariffRequest.serviceCost).divisor = this.divisor;
        ((RscmServiceCost)tariffRequest.serviceCost).setCost(inCost);
        tariffRequest.setAccepted(true);
        return 1;
    }
}

