/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.apps.cashcheck.frk.driver.zsp101frk;

import java.util.Map;
import jssc.SerialPortList;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import ru.bitel.bgbilling.apps.cashcheck.frk.driver.ICashCheckDriver;
import ru.bitel.bgbilling.apps.cashcheck.frk.driver.zsp101frk.PrinterSp101frkErrorException;
import ru.bitel.bgbilling.apps.cashcheck.frk.driver.zsp101frk.Sp101frkPrinter;
import ru.bitel.bgbilling.apps.cashcheck.frk.server.NotImplementedException;
import ru.bitel.bgbilling.apps.cashcheck.frk.server.PrinterConnectException;
import ru.bitel.bgbilling.apps.cashcheck.frk.utils.SerialParameters;

public class Driver
implements ICashCheckDriver {
    private SerialParameters serialParameters = new SerialParameters();
    private int oneByteTimeout = -1;
    private static final Logger logger = LogManager.getLogger();

    @Override
    public void init(Map<String, String> config) {
        if (config.containsKey("portName")) {
            this.serialParameters.setPortName(config.get("portName"));
        }
        if (config.containsKey("baudRate")) {
            this.serialParameters.setBaudRate(config.get("baudRate"));
        }
        this.serialParameters.setFlowControlIn(0);
        this.serialParameters.setFlowControlOut(0);
        this.serialParameters.setDatabits(8);
        this.serialParameters.setStopbits(1);
        this.serialParameters.setParity(0);
        this.oneByteTimeout = 200;
    }

    @Override
    public void touchDriver() {
        StringBuilder sb = new StringBuilder();
        String[] portNames = SerialPortList.getPortNames();
        sb.append("available serial ports:\n");
        for (String portName : portNames) {
            sb.append(portName).append("\n");
        }
        if (portNames.length <= 0) {
            sb.append("not available com ports!\n");
        }
        logger.debug(sb.toString());
        int[] baudrates = new int[]{4800, 9600, 14400, 19200, 38400, 57600, 115200};
        int[] flowcontrolins = new int[]{0};
        int[] flowcontrolouts = new int[]{0};
        int[] databits = new int[]{8};
        int[] stopbits = new int[]{1};
        int[] paritys = new int[]{0};
        SerialParameters portParam = new SerialParameters();
        Sp101frkPrinter printer = new Sp101frkPrinter(portParam, this.oneByteTimeout, 0L, logger);
        for (String comport : portNames) {
            portParam.setPortName(comport);
            for (int baudRate : baudrates) {
                portParam.setBaudRate(baudRate);
                for (int flowControlIn : flowcontrolins) {
                    portParam.setFlowControlIn(flowControlIn);
                    for (int flowControlOut : flowcontrolouts) {
                        portParam.setFlowControlOut(flowControlOut);
                        for (int databit : databits) {
                            portParam.setDatabits(databit);
                            for (int stopbit : stopbits) {
                                portParam.setStopbits(stopbit);
                                for (int parity : paritys) {
                                    portParam.setParity(parity);
                                    sb = new StringBuilder();
                                    sb.append(portParam.getPortName()).append(",BR:").append(portParam.getBaudRateString()).append(",DB:").append(portParam.getDatabitsString()).append(",SB:").append(portParam.getStopbitsString()).append(",P:").append(portParam.getParityString());
                                    String result = printer._touch();
                                    sb.append(" -> ").append(result).append("\n");
                                    logger.debug(sb.toString());
                                }
                            }
                        }
                    }
                }
            }
        }
    }

    @Override
    public synchronized void buzzer(String operatorPass) throws NotImplementedException {
        throw new NotImplementedException();
    }

    @Override
    public synchronized void printtext(String ... parameters) throws PrinterSp101frkErrorException, PrinterConnectException, NotImplementedException {
        throw new NotImplementedException();
    }

    @Override
    public synchronized String name(String operatorPass) throws NotImplementedException {
        throw new NotImplementedException();
    }

    @Override
    public synchronized String status(String operatorPass) throws NotImplementedException {
        throw new NotImplementedException();
    }

    @Override
    public synchronized void xreport(String adminPass) throws NotImplementedException {
        throw new NotImplementedException();
    }

    @Override
    public synchronized void divreport(String adminPass) throws NotImplementedException {
        throw new NotImplementedException();
    }

    @Override
    public synchronized void zreport(String adminPass) throws NotImplementedException {
        throw new NotImplementedException();
    }

    @Override
    public synchronized String check(String ... parameters) throws NotImplementedException {
        throw new NotImplementedException();
    }

    @Override
    public synchronized String checkreturn(String ... parameters) throws NotImplementedException {
        throw new NotImplementedException();
    }

    @Override
    public synchronized String closecheck_fix(String adminPass, String summa) throws NotImplementedException {
        throw new NotImplementedException();
    }

    @Override
    public void continueprint(String pass) throws NotImplementedException {
        throw new NotImplementedException();
    }

    @Override
    public String purecommand(String operatorPass, String command) throws NotImplementedException {
        throw new NotImplementedException();
    }

    @Override
    public void repeatcheck(String operatorPass) throws NotImplementedException {
        throw new NotImplementedException();
    }

    @Override
    public synchronized void cancelcheck(String pass) throws NotImplementedException {
        throw new NotImplementedException();
    }

    @Override
    public void shutdown() {
    }

    @Override
    public String getStatus() {
        return "portName=" + this.serialParameters.getPortName() + ", baudRate = " + this.serialParameters.getBaudRate();
    }

    @Override
    public void openday(String pass) throws NotImplementedException {
        throw new NotImplementedException();
    }
}

