package ru.bitel.bgbilling.modules.sorm.dyn.service;

import java.util.List;

import jakarta.jws.WebService;
import ru.bitel.bgbilling.kernel.container.managed.ServerContext;
import ru.bitel.bgbilling.kernel.container.service.server.AbstractService;
import ru.bitel.bgbilling.kernel.module.common.bean.BGModule;
import ru.bitel.bgbilling.kernel.module.server.ModuleCache;
import ru.bitel.bgbilling.kernel.task.common.bean.LightweightTaskData;
import ru.bitel.bgbilling.kernel.task.common.service.SchedulerService;
import ru.bitel.common.Utils;

// В конфигурации сервера прописать
// dynservice:CustomSormService=CustomSormServiceImpl

// http://localhost:8080/bgbilling/executer/json/ru.bitel.bgbilling.modules.sorm.service/CustomSormService
//Тело запроса
//{"method" : "startUpload",
//"user" :{ "user" : "User", "pswd" : "1234567" },
//"params" : {
//"moduleId": "??", "schedullerTaskId": "??"
//} }
@WebService(endpointInterface = "CustomSormService")
public class CustomSormServiceImpl
    extends AbstractService
    implements CustomSormService
{
    @Override
    public String startUpload( int moduleId, int schedullerTaskId )
        throws Exception
    {
        if( moduleId <= 0 )
        {
            String text = "Не верно указан ID модуля";
            getLogger().error( text );
            return text;
        }

        if( schedullerTaskId <= 0 )
        {
            String text =  "Не верно указана ID задачи планировщика";
            getLogger().error( text );
            return text;
        }

        BGModule module = ModuleCache.getInstance().getModulesList().stream().filter( m -> m.getId() == moduleId ).findAny().orElse( null );
        if( module == null || !module.getName().equals( "sorm" ) )
        {
            String text = "Не найден модуль СОРМ для переданного ID=" + moduleId;
            getLogger().error( text );
            return text;
        }

        ServerContext serverContext = ServerContext.get();
        SchedulerService schedulerService = serverContext.getService( SchedulerService.class, 0 );
        List<LightweightTaskData> tasks = schedulerService.getSchedulerTasks( String.valueOf( moduleId ) );
        if( Utils.isEmptyCollection(tasks) )
        {
            String text = "Не найдено задач для модуля ID=" + moduleId;
            getLogger().error( text );
            return text;
        }

        LightweightTaskData sormTask = tasks.stream()
                                            .filter( task -> task.getModuleId() == moduleId && task.getId() == schedullerTaskId )
                                            .findAny()
                                            .orElse( null );
        if( sormTask == null )
        {
            String text = "Не найдено задачи на выгрузку с ID=" + schedullerTaskId;
            getLogger().error( text );
            return text;
        }

        getLogger().info( "Запуск задачи: " + sormTask.getTitle() );

        schedulerService.immediateRun( sormTask );

        return "Успешно запустили выгрузку модуля СОРМ с ID=" + moduleId + " Для задачи: " + sormTask.getTitle();
    }
}
