/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.oss.systems.inventory.resource.server.bean;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import ru.bitel.bgbilling.common.BGException;
import ru.bitel.bgbilling.server.util.ServerUtils;
import ru.bitel.common.TimeUtils;
import ru.bitel.common.dao.AbstractDao;
import ru.bitel.common.model.Page;
import ru.bitel.common.model.Result;
import ru.bitel.oss.systems.inventory.resource.common.bean.PhoneResourceSubscription;

public class PhoneResourceSubscriptionDao
extends AbstractDao<PhoneResourceSubscription> {
    public PhoneResourceSubscriptionDao(Connection con, int moduleId) {
        super(con, moduleId, "inv_phone_resource_subscription");
    }

    protected PhoneResourceSubscription getFromRS(ResultSet rs) throws SQLException, BGException {
        PhoneResourceSubscription result = new PhoneResourceSubscription();
        result.setId(rs.getInt("id"));
        result.setPhoneResourseId(rs.getInt("phoneResId"));
        result.setPhone(rs.getLong("phone"));
        result.setDateFrom((Date)rs.getDate("dateFrom"));
        result.setDateTo((Date)rs.getDate("dateTo"));
        result.setSubscriberId(rs.getInt("subscriberId"));
        result.setSubscriberTitle(rs.getString("subscriberTitle"));
        return result;
    }

    protected void updateImpl(PhoneResourceSubscription b) throws BGException, SQLException {
        PreparedStatement ps;
        if (b.getId() <= 0) {
            ps = this.con.prepareStatement("INSERT INTO " + this.tableName + " (phoneResId, phone, dateFrom, dateTo,  subscriberId, subscriberTitle) VALUES (?,?,?,?,?,?)", 1);
        } else {
            ps = this.con.prepareStatement("UPDATE " + this.tableName + " SET phoneResId=?, phone=?, dateFrom=?, dateTo=?,  subscriberId=?, subscriberTitle=? WHERE id=?");
            ps.setInt(7, b.getId());
        }
        ps.setLong(1, b.getPhoneResourseId());
        ps.setLong(2, b.getPhone());
        ps.setDate(3, TimeUtils.convertDateToSqlDate((Date)b.getDateFrom()));
        ps.setDate(4, TimeUtils.convertDateToSqlDate((Date)b.getDateTo()));
        ps.setInt(5, b.getSubscriberId());
        ps.setString(6, b.getSubscriberTitle());
        ps.executeUpdate();
        if (b.getId() <= 0) {
            b.setId(ServerUtils.lastInsertId(ps));
        }
        ps.close();
    }

    public Set<Integer> subscribedPnones(int phoneResourceId, Date dateFrom, Date dateTo) throws BGException {
        try {
            HashSet<Integer> result = new HashSet<Integer>(128);
            PreparedStatement ps = this.con.prepareStatement("SELECT phone FROM " + this.tableName + " WHERE phoneResId=? AND (dateFrom IS NULL OR ? IS NULL OR dateFrom<=?) AND (dateTo IS NULL OR ? IS NULL OR dateTo>=?)");
            int idx = 1;
            ps.setInt(idx++, phoneResourceId);
            ps.setDate(idx++, TimeUtils.convertDateToSqlDate((Date)dateTo));
            ps.setDate(idx++, TimeUtils.convertDateToSqlDate((Date)dateTo));
            ps.setDate(idx++, TimeUtils.convertDateToSqlDate((Date)dateFrom));
            ps.setDate(idx++, TimeUtils.convertDateToSqlDate((Date)dateFrom));
            ResultSet rs = ps.executeQuery();
            while (rs.next()) {
                result.add(rs.getInt(1));
            }
            rs.close();
            ps.close();
            return result;
        }
        catch (SQLException e) {
            throw new BGException((Throwable)e);
        }
    }

    public List<PhoneResourceSubscription> list(int phoneResourceId, Date dateFrom, Date dateTo, long phone) throws BGException {
        return this.list("phoneResId=? AND (dateFrom IS NULL OR ? IS NULL OR dateFrom<=?) AND (dateTo IS NULL OR ? IS NULL OR dateTo>=?) AND phone = ? ", "id", new Object[]{phoneResourceId, dateTo, dateTo, dateFrom, dateFrom, phone});
    }

    public List<PhoneResourceSubscription> list(int phoneResourceId, Date dateFrom, Date dateTo) throws BGException {
        return this.list("phoneResId=? AND (dateFrom IS NULL OR ? IS NULL OR dateFrom<=?) AND (dateTo IS NULL OR ? IS NULL OR dateTo>=?)", "id", new Object[]{phoneResourceId, dateTo, dateTo, dateFrom, dateFrom});
    }

    public Result<PhoneResourceSubscription> list(int phoneResourceId, Date dateFrom, Date dateTo, Page page) throws BGException {
        return this.list(page, "phoneResId=? AND (dateFrom IS NULL OR ? IS NULL OR dateFrom<=?) AND (dateTo IS NULL OR ? IS NULL OR dateTo>=?)", "phone", new Object[]{phoneResourceId, dateTo, dateTo, dateFrom, dateFrom});
    }

    public int deleteBySubscriberId(int subscriberId) throws Exception {
        return this.delete("subscriberId=?", new Object[]{subscriberId});
    }
}

