/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.kernel.directory.tariff.common;

import java.util.List;
import ru.bitel.bgbilling.client.common.ClientContext;
import ru.bitel.bgbilling.kernel.directory.tariff.common.Directory;
import ru.bitel.common.Utils;
import ru.bitel.common.model.IdTitle;

public class TariffDirectory<K extends IdTitle>
implements Directory {
    private final Class<K> directoryClass;
    private final String type;
    private String name = "";
    private ru.bitel.bgbilling.kernel.directory.api.common.bean.Directory<K> directory;

    public TariffDirectory(Class<K> directoryClass, String type) {
        this.directoryClass = directoryClass;
        this.type = type;
    }

    @Override
    public void init(int moduleId) throws Exception {
        if (Utils.isBlankString((String)this.type) || this.type.equals("kernel")) {
            moduleId = 0;
        }
        ClientContext context = new ClientContext(null, moduleId, 0, 0, "");
        this.directory = context.getDirectory(this.directoryClass, moduleId);
    }

    @Override
    public String getValue(int code) throws Exception {
        IdTitle value = (IdTitle)this.directory.get(code);
        return value != null ? value.getTitle() : null;
    }

    public K get(int id) throws Exception {
        return (K)((IdTitle)this.directory.get(id));
    }

    public List<K> list() throws Exception {
        return this.directory.list();
    }

    @Override
    public int addValue(String value) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void removeValue(int code) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void renameValue(int code, String newName) {
        throw new UnsupportedOperationException();
    }

    @Override
    public List<IdTitle> getItems() throws Exception {
        return this.directory.list();
    }

    @Override
    public int getCode(String title) throws Exception {
        IdTitle value = (IdTitle)this.directory.get(title);
        return value.getId();
    }

    @Override
    public void setName(String value) {
        this.name = value;
    }

    @Override
    public String getName() {
        return this.name;
    }
}

