/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.modules.ipn.server.bean;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import ru.bitel.bgbilling.modules.ipn.server.CalculateAddressRange;
import ru.bitel.bgbilling.modules.ipn.server.bean.ServiceFinder;
import ru.bitel.common.TimeUtils;

public class AddressRangeFinder {
    private static final Logger log = LogManager.getLogger((String)"dataloader");
    private Map<Integer, List<CalculateAddressRange>> ifaceMap = new HashMap<Integer, List<CalculateAddressRange>>();

    public AddressRangeFinder(ServiceFinder defaultFinder, Map<Integer, ServiceFinder> finderMap, int source, Connection con, int mid, Calendar date) {
        this.getAddressRangeList(defaultFinder, finderMap, con, mid, date, source);
    }

    private void getAddressRangeList(ServiceFinder defaultFinder, Map<Integer, ServiceFinder> finderMap, Connection con, int mid, Calendar date, int sourceID) {
        String query = null;
        PreparedStatement ps = null;
        try {
            query = "SELECT user_source.iface, user_range.id, user_range.cid,user_range.addr1, user_range.port1,user_range.addr2, user_range.port2, user_range.plan_id, user_range.pers_plan_id  FROM ipn_user_source_" + mid + " AS user_source INNER JOIN ipn_user_range_" + mid + " AS user_range ON user_source.aid=user_range.id WHERE user_source.source_id=? AND ( user_range.date1 IS NULL OR user_range.date1<=? ) AND ( user_range.date2 IS NULL OR user_range.date2>=? ) ORDER BY user_range.addr1, user_range.port1";
            ps = con.prepareStatement(query);
            ps.setInt(1, sourceID);
            ps.setDate(2, TimeUtils.convertCalendarToSqlDate((Calendar)date));
            ps.setDate(3, TimeUtils.convertCalendarToSqlDate((Calendar)date));
            ResultSet rs = ps.executeQuery();
            while (rs.next()) {
                List<CalculateAddressRange> list;
                ServiceFinder personalFinder;
                ServiceFinder serviceFinder;
                CalculateAddressRange ar = new CalculateAddressRange();
                ar.iface = rs.getInt(1);
                ar.id = rs.getInt(2);
                ar.cid = rs.getInt(3);
                ar.address1 = rs.getLong(4);
                ar.port1 = rs.getInt(5);
                ar.address2 = rs.getLong(6);
                ar.port2 = rs.getInt(7);
                int planId = rs.getInt(8);
                int persPlanId = rs.getInt(9);
                ar.serviceFinder = planId <= 0 ? defaultFinder : ((serviceFinder = finderMap.get(planId)) != null ? serviceFinder : new ServiceFinder(planId, Collections.emptyList()));
                if (persPlanId > 0 && (personalFinder = finderMap.get(persPlanId)) != null) {
                    ar.personalServiceFinder = personalFinder;
                }
                if ((list = this.ifaceMap.get(ar.iface)) == null) {
                    list = new ArrayList<CalculateAddressRange>(100);
                    this.ifaceMap.put(ar.iface, list);
                }
                list.add(ar);
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    public CalculateAddressRange findAddressRange(long addr, int port, int iface) {
        CalculateAddressRange result = null;
        List<CalculateAddressRange> list = this.ifaceMap.get(iface);
        if (list != null) {
            result = this.findAddressRange(list, addr, port, iface);
        }
        if (result == null) {
            list = this.ifaceMap.get(-1);
            if (log.isDebugEnabled()) {
                log.debug("Find any iface list");
            }
            if (list != null) {
                result = this.findAddressRange(list, addr, port, iface);
            }
        }
        return result;
    }

    private CalculateAddressRange findAddressRange(List<CalculateAddressRange> list, long addr, int port, int iface) {
        CalculateAddressRange result = null;
        Range range = null;
        if (list.size() > 20) {
            range = this.getTruncedAddressRanges(list, addr);
        } else {
            range = new Range();
            range.start = 0;
            range.end = list.size() - 1;
        }
        if (log.isDebugEnabled()) {
            log.debug("addr=" + addr + "; range.start=" + range.start + "; range.end=" + range.end);
        }
        for (int i = range.start; i <= range.end; ++i) {
            CalculateAddressRange ar = list.get(i);
            if (ar.address1 > addr || ar.address2 < addr) continue;
            result = ar;
            break;
        }
        return result;
    }

    private Range getTruncedAddressRanges(List<CalculateAddressRange> addressRangeList, long addr) {
        Range result = new Range();
        result.start = 0;
        result.end = addressRangeList.size() - 1;
        int pos = result.start;
        CalculateAddressRange range = null;
        CalculateAddressRange rangeStart = null;
        CalculateAddressRange rangeEnd = null;
        if (addressRangeList.size() == 0) {
            result.end = -1;
        } else {
            rangeStart = addressRangeList.get(result.start);
            rangeEnd = addressRangeList.get(result.end);
            if (rangeStart.address1 > addr || rangeEnd.address2 < addr) {
                result.end = -1;
            } else {
                boolean intervUmensh = false;
                if (result.end > 1) {
                    do {
                        pos = (result.end + result.start) / 2;
                        rangeStart = addressRangeList.get(result.start);
                        rangeEnd = addressRangeList.get(result.end);
                        range = addressRangeList.get(pos);
                        intervUmensh = false;
                        if (range.address1 <= addr && rangeStart.address1 < range.address1) {
                            result.start = pos;
                            intervUmensh = true;
                        }
                        if (range.address2 < addr || rangeEnd.address2 <= range.address2) continue;
                        result.end = pos;
                        intervUmensh = true;
                    } while (intervUmensh);
                }
            }
        }
        return result;
    }

    class Range {
        public int start = -1;
        public int end = -1;

        Range() {
        }
    }
}

