/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.modules.hd.server.task;

import java.io.IOException;
import java.sql.Connection;
import java.util.Date;
import java.util.Map;
import java.util.Properties;
import org.apache.commons.net.whois.WhoisClient;
import org.json.JSONObject;
import ru.bitel.bgbilling.common.BGException;
import ru.bitel.bgbilling.common.BGMessageException;
import ru.bitel.bgbilling.kernel.task.server.TaskBase;
import ru.bitel.bgbilling.modules.hd.common.bean.Zone;
import ru.bitel.bgbilling.modules.hd.server.bean.ZoneDAO;
import ru.bitel.bgbilling.modules.hd.server.task.WhoisServers;
import ru.bitel.bgbilling.modules.hd.server.task.domainParser.DomainParserBase;
import ru.bitel.bgbilling.server.util.ServerUtils;
import ru.bitel.common.Utils;

public class TaskUpdateWhoisData
extends TaskBase {
    private int whoisPort = -1;
    private Properties p = null;

    protected boolean initTask() {
        this.whoisPort = this.taskSetup.getInt("whois.port", 43);
        return true;
    }

    protected void executeTask() {
        Connection con = this.setup.getDBConnectionFromPool();
        ZoneDAO zoneDAO = new ZoneDAO(con, this.moduleId);
        this.a(zoneDAO);
        ServerUtils.closeConnection((Connection)con);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void a(ZoneDAO zoneDAO) {
        try {
            this.p = new Properties();
            this.p.load(TaskUpdateWhoisData.class.getResourceAsStream("whois.properties"));
        }
        catch (IOException ex) {
            this.logError(ex);
        }
        for (int zoneId : zoneDAO.getZoneIdListByWhoisLastUpdate(this.taskSetup.get("zone.mask", "\\.RU$"), this.taskSetup.getInt("update.count.max", 10))) {
            Zone zone = null;
            WhoisData whoisData = new WhoisData();
            do {
                zone = zoneDAO.getZoneById(zoneId);
                if (whoisData.dataMap == null) {
                    this.getLogger().info("Zone = " + zone.getZone());
                    try {
                        String[] str = zone.getZone().split("\\u002E");
                        String domain = str[str.length - 1].toLowerCase();
                        String whoisServer = this.getWhoisServer(domain, zone.getZone());
                        String className = this.getClassName(whoisServer);
                        this.getWhoisData(whoisData, whoisServer, this.whoisPort, zone.getZonePunycode(), className);
                    }
                    catch (IOException ex) {
                        this.getLogger().error("Zone = " + zone.getZone(), (Throwable)ex);
                        break;
                    }
                    catch (BGException e) {
                        this.getLogger().error("Zone = " + zone.getZone(), (Throwable)e);
                        continue;
                    }
                    catch (Exception e) {
                        this.getLogger().error("Zone = " + zone.getZone(), (Throwable)e);
                        continue;
                    }
                    if (!whoisData.dataMap.isEmpty()) {
                        JSONObject jsonObject = new JSONObject();
                        for (Map.Entry<String, String> entry : whoisData.dataMap.entrySet()) {
                            jsonObject.put(entry.getKey(), (Object)entry.getValue());
                            zone.updateConfigValue("whois." + entry.getKey(), entry.getValue());
                        }
                        zone.updateConfigValue("whois", jsonObject.toString());
                    }
                    if (whoisData.registrar != null) {
                        zone.setRegistrar(whoisData.registrar);
                    }
                    if (whoisData.freeDate != null) {
                        zone.setFreeDate(whoisData.freeDate);
                    }
                }
                zone.setWhoisLastUpdate(new Date());
            } while (!zoneDAO.updateZone(zone, zone.getLastUpdate()));
            ZoneDAO zoneDAO2 = zoneDAO;
            synchronized (zoneDAO2) {
                try {
                    zoneDAO.wait((long)this.taskSetup.getInt("update.time.delay", 5) * 1000L);
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
            }
        }
    }

    public String getDescription() {
        return this.defaultDescription + "\u041c\u043e\u0434\u0443\u043b\u044c HD. \u0417\u0430\u0434\u0430\u0447\u0430 \u043e\u0431\u043d\u043e\u0432\u043b\u0435\u043d\u0438\u044f Whois \u0434\u0430\u043d\u043d\u044b\u0445";
    }

    private String getWhoisServer(String domain, String zoneName) throws BGMessageException {
        String whoisServer = null;
        whoisServer = this.taskSetup.get("redirect." + zoneName.toLowerCase(), null);
        if (!(Utils.notBlankString((String)whoisServer) || Utils.notBlankString((String)(whoisServer = this.taskSetup.get(domain, null))) || Utils.notBlankString((String)(whoisServer = WhoisServers.getWhoisServer(zoneName))))) {
            throw new BGMessageException("\u0414\u043b\u044f \u0437\u043e\u043d\u044b: " + zoneName + " whois \u0441\u0435\u0440\u0432\u0435\u0440 \u043d\u0435 \u043d\u0430\u0439\u0434\u0435\u043d!");
        }
        return whoisServer;
    }

    private String getClassName(String whoisServer) throws BGMessageException {
        String className = this.taskSetup.get(whoisServer, null);
        if (!Utils.notBlankString((String)className) && !Utils.notBlankString((String)(className = this.p.getProperty(whoisServer, null)))) {
            className = "ru.bitel.bgbilling.modules.hd.server.task.domainParser.DefaultDomainParser";
        }
        return className;
    }

    private void getWhoisData(WhoisData whoisData, String whoisHost, int whoisPort, String host, String className) throws IOException, BGException {
        WhoisClient whoisClient = null;
        try {
            whoisClient = new WhoisClient();
            String params = null;
            boolean redirect = true;
            while (redirect) {
                this.getLogger().info("whoisClient.connect to " + whoisHost + " on port " + whoisPort);
                whoisClient.connect(whoisHost, whoisPort);
                if (whoisClient.isConnected()) {
                    params = whoisClient.query(host);
                    DomainParserBase parser = (DomainParserBase)Utils.newInstance((String)className, DomainParserBase.class);
                    this.getLogger().info("parser = " + parser);
                    if (parser != null) {
                        whoisData.dataMap = parser.parseDomain(params);
                        this.getLogger().info("dataMap = " + whoisData.dataMap);
                        if (!whoisData.dataMap.isEmpty()) {
                            whoisData.registrar = parser.getRegistrar(whoisData.dataMap);
                            whoisData.freeDate = parser.getFreeData(whoisData.dataMap);
                        }
                        String whoisRedirect = parser.getWhoisRedirect(whoisData.dataMap);
                        this.getLogger().info("whoisRedirect = " + whoisRedirect);
                        if (!Utils.notBlankString((String)whoisRedirect)) {
                            redirect = false;
                            continue;
                        }
                        className = this.getClassName(whoisRedirect);
                        whoisHost = whoisRedirect;
                        continue;
                    }
                    this.getLogger().error("host = " + host + "; className = " + className + " -> parser is null!");
                    continue;
                }
                redirect = false;
            }
        }
        catch (IOException ex) {
            throw ex;
        }
        finally {
            whoisClient.disconnect();
        }
    }

    class WhoisData {
        Map<String, String> dataMap;
        Date freeDate;
        String registrar;
        String whoisRedirect;

        WhoisData() {
        }
    }
}

