/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.modules.hd.server.action;

import org.w3c.dom.Element;
import ru.bitel.bgbilling.common.BGIllegalArgumentException;
import ru.bitel.bgbilling.modules.hd.server.action.base.ActionBase;
import ru.bitel.bgbilling.modules.hd.server.bean.CPDomain;
import ru.bitel.bgbilling.modules.hd.server.bean.CPDomainManager;
import ru.bitel.bgbilling.modules.hd.server.bean.CPHost;
import ru.bitel.bgbilling.modules.hd.server.bean.CPHostManager;
import ru.bitel.bgbilling.modules.hd.server.bean.CPHosting;
import ru.bitel.bgbilling.modules.hd.server.bean.CPHostingManager;
import ru.bitel.bgbilling.modules.hd.server.bean.CPNs;
import ru.bitel.bgbilling.modules.hd.server.bean.CPNsManager;
import ru.bitel.bgbilling.modules.hd.server.bean.ContractPackage;
import ru.bitel.bgbilling.modules.hd.server.bean.ContractPackageManager;
import ru.bitel.common.Utils;

public class ActionContractPackageGet
extends ActionBase {
    public void doAction() throws Exception {
        int id = this.getIntParameter("id", -1);
        if (id <= 0 || this.mid <= 0) {
            throw new BGIllegalArgumentException();
        }
        ContractPackageManager packageManager = new ContractPackageManager(this.con, this.mid);
        CPDomainManager domainManager = new CPDomainManager(this.con, this.mid);
        CPNsManager nsManager = new CPNsManager(this.con, this.mid);
        CPHostManager hostManager = new CPHostManager(this.con, this.mid);
        CPHostingManager hostingManager = new CPHostingManager(this.con, this.mid);
        ContractPackage contractPackage = packageManager.getContractPackage(id);
        if (contractPackage != null) {
            Element packageEl = this.createElement(this.rootNode, "contract_package");
            packageEl.setAttribute("status", String.valueOf(contractPackage.getStatus()));
            CPDomain domain = domainManager.getDomain(id);
            if (domain != null) {
                Element domainEl = this.createElement(packageEl, "domain");
                packageEl.setAttribute("domain_name", domain.getDomain());
                domainEl.setAttribute("name", domain.getDomain());
                domainEl.setAttribute("admin_mail", domain.getAdminMail());
                for (String[] record : domain.getRecords()) {
                    domainEl.setAttribute("record_" + record[0], record[1]);
                }
            }
            if (Utils.notBlankString((String)contractPackage.getNsDomain())) {
                Element nsEl = this.createElement(packageEl, "ns");
                nsEl.setAttribute("domain", contractPackage.getNsDomain());
                for (CPNs ns : nsManager.getPackageNsList(id)) {
                    Element server = this.createElement(nsEl, "server");
                    server.setAttribute("name", ns.getName());
                }
            }
            Element hostListEl = this.createElement(packageEl, "records");
            for (CPHost host : hostManager.getHostList(id)) {
                Element hostEl = this.createElement(hostListEl, "record");
                hostEl.setAttribute("name", host.getHost());
                hostEl.setAttribute("type", host.getAddr());
                hostEl.setAttribute("value", host.getAddr());
            }
            CPHosting hosting = hostingManager.getHosting(id);
            if (hosting != null) {
                Element hostingEl = this.createElement(packageEl, "hosting");
                for (String host : hosting.getHostList()) {
                    Element hostEl = this.createElement(hostingEl, "host");
                    hostEl.setAttribute("name", host);
                }
            }
            Element adminComment = this.createElement(packageEl, "admin_comment");
            this.stringToLines(adminComment, contractPackage.getAdminComment());
        }
    }
}

