/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.plugins.documents.server.bean;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.util.Date;
import java.util.List;
import ru.bitel.bgbilling.common.BGException;
import ru.bitel.bgbilling.plugins.documents.common.bean.Document;
import ru.bitel.bgbilling.server.util.ServerUtils;
import ru.bitel.common.TimeUtils;
import ru.bitel.common.Utils;
import ru.bitel.common.dao.AbstractDao;
import ru.bitel.common.model.Period;

public class DocumentDao
extends AbstractDao<Document> {
    public DocumentDao(Connection con) {
        super(con, -1, "documents");
    }

    protected void updateImpl(Document document) throws BGException, SQLException {
        boolean update = document.getId() > 0;
        String query = (update ? "UPDATE " : "INSERT INTO ") + this.tableName + " SET title=?, cid=?, journal_id=?, type=?, status_id=?, comment=?, last_modify_date=NOW(), user=?, pattern_id=?, show_in_lk=?" + (update ? " WHERE id=?" : ", secret=?, create_date=NOW()");
        try (PreparedStatement ps = this.con.prepareStatement(query, 1);){
            int index = 1;
            ps.setString(index++, document.getTitle());
            ps.setInt(index++, document.getContractId());
            ps.setInt(index++, document.getJournalId());
            ps.setInt(index++, document.getTypeId());
            ps.setInt(index++, document.getStatusId());
            ps.setString(index++, document.getComment());
            ps.setInt(index++, document.getUserId());
            ps.setInt(index++, document.getPatternId());
            ps.setBoolean(index++, document.isShowInLK());
            if (update) {
                ps.setInt(index++, document.getId());
            } else {
                document.setFileSecret(this.getSecret((int)(Math.random() * 1000.0)));
                ps.setString(index++, document.getFileSecret());
            }
            ps.executeUpdate();
            if (document.getId() <= 0) {
                document.setId(ServerUtils.lastInsertId((PreparedStatement)ps));
            }
        }
    }

    public List<Document> getDocumentList(int contractId, String title, Period period) throws BGException {
        List result;
        PreparedStatement ps;
        String query = "SELECT * FROM " + this.tableName + " WHERE cid=?";
        if (Utils.notBlankString((String)title)) {
            query = query + " AND title LIKE ?";
        }
        if (period != null) {
            if (period.getDateFrom() != null) {
                query = query + " AND (? IS NULL OR create_date >= ?)";
            }
            if (period.getDateTo() != null) {
                query = query + " AND (? IS NULL OR create_date <= ?)";
            }
        }
        query = query + " ORDER BY id";
        try {
            ps = this.con.prepareStatement(query);
            try {
                int index = 1;
                ps.setInt(index++, contractId);
                if (Utils.notBlankString((String)title)) {
                    ps.setString(index++, "%" + title + "%");
                }
                if (period != null) {
                    if (period.getDateFrom() != null) {
                        ps.setTimestamp(index++, TimeUtils.convertDateToTimestamp((Date)period.getDateFrom()));
                        ps.setTimestamp(index++, TimeUtils.convertDateToTimestamp((Date)period.getDateFrom()));
                    }
                    if (period.getDateTo() != null) {
                        ps.setTimestamp(index++, TimeUtils.convertDateToTimestamp((Date)period.getDateTo()));
                        ps.setTimestamp(index++, TimeUtils.convertDateToTimestamp((Date)period.getDateTo()));
                    }
                }
                try (ResultSet rs = ps.executeQuery();){
                    result = this.getListFromRS(rs);
                }
            }
            finally {
                if (ps != null) {
                    ps.close();
                }
            }
        }
        catch (SQLException e) {
            throw new BGException(e.getMessage(), (Throwable)e);
        }
        try {
            ps = this.con.prepareStatement("SELECT `status` FROM `documents_status_log` WHERE `id_document`=? ORDER BY `date` DESC LIMIT 1");
            try {
                for (Document document : result) {
                    if (document.getStatusId() != 0) continue;
                    ps.setInt(1, document.getId());
                    ResultSet rs = ps.executeQuery();
                    try {
                        while (rs.next()) {
                            document.setStatusId(rs.getInt("status"));
                        }
                    }
                    finally {
                        if (rs == null) continue;
                        rs.close();
                    }
                }
            }
            finally {
                if (ps != null) {
                    ps.close();
                }
            }
        }
        catch (SQLException ex) {
            throw new BGException((Throwable)ex);
        }
        return result;
    }

    public void deleteDocument(int id) throws Exception {
        this.deleteImpl(id);
    }

    public int getDocumentOwnerId(int documentId) throws BGException {
        int result = -1;
        String query = "SELECT cid FROM " + this.tableName + " WHERE id=?";
        try (PreparedStatement ps = this.con.prepareStatement(query);){
            ps.setInt(1, documentId);
            ResultSet rs = ps.executeQuery();
            while (rs.next()) {
                result = rs.getInt(1);
            }
            rs.close();
        }
        catch (SQLException e) {
            this.processException(e);
        }
        return result;
    }

    public Document getDocument(int id) throws BGException {
        try {
            return (Document)this.getById(id);
        }
        catch (SQLException e) {
            throw new BGException((Throwable)e);
        }
    }

    protected Document getFromRS(ResultSet rs) throws SQLException, BGException {
        return Document.builder().setId(rs.getInt("id")).setTitle(rs.getString("title")).setContractId(rs.getInt("cid")).setJournalId(rs.getInt("journal_id")).setTypeId(rs.getInt("type")).setComment(rs.getString("comment")).setCreateDate(TimeUtils.convertTimestampToDate((Timestamp)rs.getTimestamp("create_date"))).setLastModifyDate(TimeUtils.convertTimestampToDate((Timestamp)rs.getTimestamp("last_modify_date"))).setStatusId(rs.getInt("status_id")).setUserId(rs.getInt("user")).setPatternId(rs.getInt("pattern_id")).setShowInLK(rs.getBoolean("show_in_lk")).setFileSecret(rs.getString("secret")).build();
    }

    public String updateDocumentSecret(int documentId) throws BGException {
        String secret = this.getSecret(documentId);
        try (PreparedStatement ps = this.con.prepareStatement("UPDATE " + this.tableName + " SET secret=? WHERE id=?");){
            ps.setString(1, secret);
            ps.setInt(2, documentId);
            ps.executeUpdate();
        }
        catch (SQLException e) {
            throw new BGException((Throwable)e);
        }
        return secret;
    }

    private String getSecret(int documentId) {
        Object secret = String.valueOf(documentId) + String.valueOf(System.currentTimeMillis());
        secret = Utils.getDigest((String)secret, (String)"UTF-8", (String)"SHA256").toLowerCase();
        return ((String)secret).substring(0, 10);
    }
}

