/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.modules.phone.server;

import java.util.Calendar;
import ru.bitel.bgbilling.kernel.admin.mail.server.MailMsg;
import ru.bitel.bgbilling.kernel.admin.mail.server.bean.MailData;
import ru.bitel.bgbilling.kernel.task.server.bean.RunTaskRecalculator;
import ru.bitel.bgbilling.modules.phone.server.mail.MailTaskBalanceSetter;
import ru.bitel.bgbilling.modules.phone.server.task.BalanceSetter;
import ru.bitel.bgbilling.server.util.Setup;
import ru.bitel.common.Preferences;
import ru.bitel.common.TimeUtils;

public class PhoneBalanceSetter
extends RunTaskRecalculator<BalanceSetter> {
    public PhoneBalanceSetter(int moduleId, Calendar dt, String email) {
        super(moduleId, dt, email);
    }

    public void executeTask() {
        try {
            long start = System.currentTimeMillis();
            BalanceSetter calculator = this.createTask();
            calculator.startTask();
            long end = System.currentTimeMillis();
            if (this.email != null) {
                StringBuffer report = new StringBuffer("\u0423\u0441\u0442\u0430\u043d\u043e\u0432\u043a\u0430 \u0431\u0430\u043b\u0430\u043d\u0441\u0430 \u0442\u0435\u043b\u0435\u0444\u043e\u043d\u0438\u0438 \u0437\u0430\u0432\u0435\u0440\u0448\u0435\u043d\u0430\n").append("\u0412\u0440\u0435\u043c\u044f: ").append(TimeUtils.formatDeltaTime((long)((end - start) / 1000L)));
                MailTaskBalanceSetter mailData = new MailTaskBalanceSetter();
                mailData.setModuleId(this.mid);
                mailData.setRecipients(this.email);
                mailData.setSubject("\u0423\u0441\u0442\u0430\u043d\u043e\u0432\u043a\u0430 \u0431\u0430\u043b\u0430\u043d\u0441\u0430 \u0442\u0435\u043b\u0435\u0444\u043e\u043d\u0438\u0438 \u0437\u0430\u0432\u0435\u0440\u0448\u0435\u043d\u0430");
                mailData.addTextPart("text", report.toString());
                new MailMsg((Preferences)this.setup).sendMessage((MailData)mailData);
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    protected BalanceSetter createTask() {
        BalanceSetter calculator = new BalanceSetter();
        calculator.setExecutingTime(this.dt);
        calculator.initTask(Setup.getSetup(), 0, "mid=" + this.mid);
        return calculator;
    }
}

