/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.modules.mobile.server.bean;

import io.jsonwebtoken.Claims;
import io.jsonwebtoken.ExpiredJwtException;
import io.jsonwebtoken.Jws;
import io.jsonwebtoken.JwsHeader;
import io.jsonwebtoken.JwtBuilder;
import io.jsonwebtoken.JwtException;
import io.jsonwebtoken.Jwts;
import io.jsonwebtoken.security.Keys;
import io.jsonwebtoken.security.WeakKeyException;
import jakarta.servlet.http.HttpServletRequest;
import java.security.Key;
import java.sql.Connection;
import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import javax.crypto.SecretKey;
import ru.bitel.bgbilling.common.BGException;
import ru.bitel.bgbilling.common.BGMessageException;
import ru.bitel.bgbilling.kernel.auth.AuthModes;
import ru.bitel.bgbilling.kernel.auth.ModuleUser;
import ru.bitel.bgbilling.kernel.base.server.logger.BGLogger;
import ru.bitel.bgbilling.kernel.contract.api.common.bean.Contract;
import ru.bitel.bgbilling.kernel.contract.api.server.bean.ContractDao;
import ru.bitel.bgbilling.kernel.contract.runtime.ContractRuntime;
import ru.bitel.bgbilling.kernel.contract.runtime.ContractRuntimeMap;
import ru.bitel.bgbilling.modules.mobile.server.api.MobileApi;
import ru.bitel.bgbilling.modules.mobile.server.bean.MobileResultAuthentication;
import ru.bitel.bgbilling.modules.mobile.server.bean.MobileToken;
import ru.bitel.bgbilling.modules.mobile.server.dao.MobileTokenDao;
import ru.bitel.bgbilling.server.util.ModuleSetup;
import ru.bitel.bgbilling.server.util.Setup;
import ru.bitel.common.ParameterMap;
import ru.bitel.common.Utils;

public class MobileAuthentication
extends BGLogger {
    private int moduleId;
    private ModuleSetup moduleSetup;
    private String action;
    private MobileResultAuthentication result = null;

    public MobileAuthentication(int moduleId, ModuleSetup moduleSetup, String action) {
        this.moduleId = moduleId;
        this.action = action;
        this.moduleSetup = moduleSetup;
    }

    /*
     * Loose catch block
     * Enabled aggressive exception aggregation
     */
    public MobileResultAuthentication authentication(HttpServletRequest request, Connection con, Map<String, Object> map) throws BGException {
        block38: {
            SecretKey secretKey;
            this.result = new MobileResultAuthentication();
            if (this.action == null) {
                this.result.setErrorText("didNotSetAction");
                return this.result;
            }
            String key = this.moduleSetup.get("token.signature.key");
            if (Utils.isBlankString((String)key)) {
                this.result.setErrorText("A key signature was not set");
                return this.result;
            }
            try {
                secretKey = Keys.hmacShaKeyFor((byte[])key.getBytes());
            }
            catch (WeakKeyException ex) {
                this.logError(ex);
                this.result.setErrorText("Weak key");
                return this.result;
            }
            try (ContractDao contractDao = new ContractDao(con, -1);){
                MobileTokenDao tokenDao = new MobileTokenDao(con, this.moduleId);
                String accessToken = request.getParameter("ajwt");
                String refreshToken = request.getParameter("rjwt");
                String login = request.getParameter("login");
                String pswd = request.getParameter("pswd");
                if (Utils.isBlankString((String)accessToken) && Utils.isBlankString((String)refreshToken)) {
                    Object authModes;
                    if (Utils.isBlankString((String)login) || Utils.isBlankString((String)pswd)) {
                        this.result.setAccessCode(20);
                        this.result.setErrorText("\u041e\u0442\u0441\u0443\u0442\u0441\u0442\u0432\u0443\u0435\u0442 \u043b\u043e\u0433\u0438\u043d \u0438/\u0438\u043b\u0438 \u043f\u0430\u0440\u043e\u043b\u044c");
                        MobileResultAuthentication mobileResultAuthentication = this.result;
                        return mobileResultAuthentication;
                    }
                    Setup setup = Setup.getSetup();
                    String webAuthModes = setup.get("web.auth.modes");
                    this.getLogger().debug("web.auth.modes={}", (Object)webAuthModes);
                    if (webAuthModes != null) {
                        authModes = new HashMap();
                        AuthModes.loadConfig((Setup)setup, (long)0L, authModes);
                        this.getLogger().debug("authModes={}", authModes);
                        ModuleUser moduleUser = AuthModes.findModuleUserUserByLogin((String)login, (String)"0", authModes);
                        this.getLogger().debug("moduleUser={}", (Object)moduleUser);
                        if (moduleUser != null) {
                            this.result.setContract((Contract)contractDao.get(moduleUser.getContractId()));
                        }
                    } else {
                        this.result.setContract(contractDao.getByTitle(login));
                    }
                    if (this.result.getContract() == null || !this.result.getContract().getPassword().equals(pswd)) {
                        this.result.setAccessCode(21);
                        authModes = this.result;
                        return authModes;
                    }
                    int contractId = this.result.getContract().getId();
                    this.result.setAccessCode(1);
                    int maxActive = this.rangeInt(this.moduleSetup.getInt("token.max.active", 2), 1, 10, 2);
                    int nowActive = tokenDao.getCountTokenActive(contractId);
                    if (nowActive >= maxActive) {
                        tokenDao.deleteTokens(contractId);
                        this.result.setAccessCode(2);
                    }
                    tokenDao.deleteExpiredTokens(contractId);
                    if (!this.checkModuleOnContract(con, contractId)) {
                        this.result.setAccessCode(22);
                        MobileResultAuthentication mobileResultAuthentication = this.result;
                        return mobileResultAuthentication;
                    }
                    String jwsAccess = this.getAccessJWS(secretKey, contractId);
                    String jwsRefresh = this.getRefreshJWS(secretKey, contractId, null, tokenDao);
                    map.put("ajwt", jwsAccess);
                    map.put("rjwt", jwsRefresh);
                } else {
                    int subContractId = Utils.parseInt((String)request.getParameter("subContractId"), (int)-1);
                    if (subContractId > 0 && !this.checkModuleOnContract(con, subContractId)) {
                        this.result.setAccessCode(22);
                        MobileResultAuthentication webAuthModes = this.result;
                        return webAuthModes;
                    }
                    if (Utils.notBlankString((String)refreshToken)) {
                        this.result.setAccessCode(this.checkRefreshToken(request, con, contractDao, tokenDao, secretKey, refreshToken, map, subContractId));
                    } else {
                        Jws jws = Jwts.parser().setSigningKey((Key)secretKey).parseClaimsJws(accessToken);
                        int contractId = (Integer)((Claims)jws.getBody()).get((Object)"cid");
                        if (!this.checkModuleOnContract(con, contractId)) {
                            this.result.setAccessCode(22);
                            MobileResultAuthentication mobileResultAuthentication = this.result;
                            return mobileResultAuthentication;
                        }
                        this.result.setContract((Contract)contractDao.get(contractId));
                        this.result.setErrorText(this.checkSubContract(subContractId, contractDao));
                        if (Utils.notBlankString((String)this.result.getErrorText())) {
                            MobileResultAuthentication mobileResultAuthentication = this.result;
                            return mobileResultAuthentication;
                        }
                        try {
                            this.result.setAccessCode(0);
                        }
                        catch (ExpiredJwtException e) {
                            this.result.setAccessCode(10);
                            MobileResultAuthentication mobileResultAuthentication = this.result;
                            contractDao.close();
                            return mobileResultAuthentication;
                        }
                        catch (JwtException ex) {
                            this.getLogger().error("Access token, token =  " + accessToken + " " + ex.getMessage());
                            this.result.setAccessCode(11);
                            MobileResultAuthentication mobileResultAuthentication = this.result;
                            return mobileResultAuthentication;
                        }
                    }
                }
                if (this.result.getContract() == null) {
                    this.getLogger().error(" Contract is null, token = " + accessToken);
                    this.result.setErrorText("Contract is null");
                    MobileResultAuthentication mobileResultAuthentication = this.result;
                    return mobileResultAuthentication;
                }
                break block38;
                {
                    catch (Throwable throwable) {
                        throw throwable;
                    }
                }
            }
            catch (Exception ex) {
                throw new BGException((Throwable)ex);
            }
        }
        return this.result;
    }

    private boolean checkModuleOnContract(Connection con, int contractId) throws Exception {
        ContractRuntime contractRuntime = ContractRuntimeMap.getInstance().getContractRuntime(con, Integer.valueOf(contractId));
        this.getLogger().debug("checkModuleOnContract for contractId=" + contractId + " => " + contractRuntime);
        return contractRuntime == null ? false : contractRuntime.getModuleIds().contains(this.moduleId);
    }

    private String checkSubContract(int subContractId, ContractDao contractDao) throws BGException {
        if (subContractId > 0) {
            Contract subContract = (Contract)contractDao.get(subContractId);
            if (subContract == null) {
                return "Sub Contract is null";
            }
            if (subContract.isSub() && subContract.getSuperCid() == this.result.getContract().getId()) {
                this.result.setContract(subContract);
                return null;
            }
            return "Sub contracact it's not sub or token incorrect !";
        }
        return null;
    }

    private int checkRefreshToken(HttpServletRequest request, Connection con, ContractDao contractDao, MobileTokenDao tokenDao, SecretKey secretKey, String refreshToken, Map<String, Object> map, int subContractId) throws Exception {
        int accessCode = -1;
        int contractId = -1;
        try {
            Jws jws = Jwts.parser().setSigningKey((Key)secretKey).parseClaimsJws(refreshToken);
            contractId = (Integer)((Claims)jws.getBody()).get((Object)"cid");
            this.result.setContract((Contract)contractDao.get(contractId));
            if (this.result.getContract() != null) {
                int tokenId = Utils.parseInt((String)((JwsHeader)jws.getHeader()).getKeyId(), (int)-1);
                if (tokenId < 1) {
                    accessCode = 13;
                    return accessCode;
                }
                MobileToken refreshMobToken = (MobileToken)tokenDao.get(tokenId);
                if (refreshMobToken == null) {
                    accessCode = 14;
                    return accessCode;
                }
                if ("tokenDeauthorize".equals(this.action)) {
                    this.deauthorizeToken(request, con, tokenDao, tokenId, contractId);
                    accessCode = 4;
                } else {
                    String jwsAccess = this.getAccessJWS(secretKey, contractId);
                    String jwsRefresh = this.getRefreshJWS(secretKey, contractId, refreshMobToken, tokenDao);
                    map.put("ajwt", jwsAccess);
                    map.put("rjwt", jwsRefresh);
                    accessCode = 3;
                    this.checkSubContract(subContractId, contractDao);
                }
            }
        }
        catch (ExpiredJwtException e2) {
            accessCode = 12;
        }
        catch (BGMessageException e) {
            throw e;
        }
        catch (Exception e2) {
            this.getLogger().error("Refresh token, cid =  " + contractId + " " + e2.getMessage());
            accessCode = 13;
        }
        return accessCode;
    }

    private String getAccessJWS(SecretKey secretKey, int contractId) {
        Calendar lifetime = Calendar.getInstance();
        int minutes = this.rangeInt(this.moduleSetup.getInt("token.access.lifetime.minutes", 60), 10, 2880, 60);
        lifetime.add(12, minutes);
        JwtBuilder jwtBuilder = Jwts.builder().setIssuedAt(new Date()).setExpiration(lifetime.getTime());
        return jwtBuilder.claim("cid", (Object)contractId).signWith((Key)secretKey).compact();
    }

    private String getRefreshJWS(SecretKey secretKey, int contractId, MobileToken tokenRefreshOld, MobileTokenDao tokenDao) throws Exception {
        int tokenId;
        Calendar lifetime = Calendar.getInstance();
        int day = this.rangeInt(this.moduleSetup.getInt("token.refresh.lifetime.days", 30), 1, 180, 30);
        lifetime.add(6, day);
        Date lifetimeDate = lifetime.getTime();
        int n = tokenId = tokenRefreshOld != null ? tokenRefreshOld.getId() : -1;
        if (tokenId < 1) {
            MobileToken token = new MobileToken();
            token.setContractId(contractId);
            token.setExpiredDate(lifetimeDate);
            tokenDao.update((Object)token);
            tokenId = token.getId();
        }
        JwtBuilder jwtBuilder = Jwts.builder().setIssuedAt(new Date()).setExpiration(lifetimeDate);
        return jwtBuilder.claim("cid", (Object)contractId).setHeaderParam("kid", (Object)("" + tokenId)).signWith((Key)secretKey).compact();
    }

    private void deauthorizeToken(HttpServletRequest request, Connection con, MobileTokenDao tokenDao, int tokenId, int contractId) throws Exception {
        tokenDao.delete(tokenId);
        String pushToken = request.getParameter("pushToken");
        if (Utils.notBlankString((String)pushToken)) {
            MobileApi mobileApi = new MobileApi((ParameterMap)this.moduleSetup, con, this.moduleId);
            mobileApi.removeLink(contractId, pushToken);
            mobileApi.close();
        }
    }

    private int rangeInt(int value, int min, int max, int defaultValue) {
        if (value > max || value < min) {
            return defaultValue;
        }
        return value;
    }
}

