/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.common.util;

import java.util.ArrayList;
import java.util.List;
import ru.bitel.common.RangeUtils;
import ru.bitel.common.util.CopyOnWriteArrayMap;
import ru.bitel.common.util.Matcher;
import ru.bitel.common.util.Ranger;

public abstract class CopyOnWriteRangeArrayMap<K, V, C extends Comparable<C>>
extends CopyOnWriteArrayMap<K, V> {
    private final Ranger<V, C> ranger;

    public CopyOnWriteRangeArrayMap(Ranger<V, C> ranger, int initialCapacity) {
        super(initialCapacity);
        this.ranger = ranger;
    }

    public CopyOnWriteRangeArrayMap(Ranger<V, C> ranger) {
        this(ranger, 16);
    }

    public V get(K key, C c) {
        Object[] list = (Object[])this.arrayMap.get(key);
        if (list != null) {
            for (Object value : list) {
                if (!RangeUtils.inRange(c, c, (Comparable)this.ranger.getMinValue(value), (Comparable)this.ranger.getMaxValue(value))) continue;
                return (V)value;
            }
        }
        return null;
    }

    public V get(K key, C c, Matcher<V> matcher) {
        Object[] list = (Object[])this.arrayMap.get(key);
        if (list != null) {
            for (Object value : list) {
                if (!RangeUtils.inRange(c, c, (Comparable)this.ranger.getMinValue(value), (Comparable)this.ranger.getMaxValue(value)) || !matcher.matched(value)) continue;
                return (V)value;
            }
        }
        return null;
    }

    public V get(K key, Matcher<V> matcher, C c) {
        Object[] list = (Object[])this.arrayMap.get(key);
        if (list != null) {
            for (Object value : list) {
                if (!matcher.matched(value) || !RangeUtils.inRange(c, c, (Comparable)this.ranger.getMinValue(value), (Comparable)this.ranger.getMaxValue(value))) continue;
                return (V)value;
            }
        }
        return null;
    }

    public List<V> list(K key, C c) {
        ArrayList<Object> result = new ArrayList<Object>();
        Object[] list = (Object[])this.arrayMap.get(key);
        if (list != null) {
            for (Object value : list) {
                if (!RangeUtils.inRange(c, c, (Comparable)this.ranger.getMinValue(value), (Comparable)this.ranger.getMaxValue(value))) continue;
                result.add(value);
            }
        }
        return result;
    }
}

