/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.kernel.network.radius.inspectors;

import bitel.billing.server.processor.NASSession;
import bitel.billing.server.radius.RadiusSetup;
import java.io.IOException;
import java.net.InetAddress;
import java.util.Map;
import java.util.Observer;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import ru.bitel.bgbilling.kernel.network.radius.inspectors.SNMPNasConnectionCheckObserver;
import ru.bitel.bgbilling.kernel.network.radius.inspectors.SNMPNasConnectionInspector;
import ru.bitel.bgbilling.kernel.network.radius.nas.NasConnection;
import ru.bitel.bgbilling.kernel.network.radius.nas.NasConnectionInspector;
import ru.bitel.common.ParameterMap;
import ru.bitel.common.Utils;
import uk.co.westhawk.snmp.pdu.OneGetPdu;
import uk.co.westhawk.snmp.stack.AsnInteger;
import uk.co.westhawk.snmp.stack.AsnObject;
import uk.co.westhawk.snmp.stack.SetPdu;
import uk.co.westhawk.snmp.stack.SnmpContextBasisFace;

public class SNMPNasConnectionInspectorCisco
extends SNMPNasConnectionInspector {
    private static final Logger logger = LogManager.getLogger();
    private final String sessionMode;

    public SNMPNasConnectionInspectorCisco(RadiusSetup setup, InetAddress nasIPAddress, byte[] secret, Map<String, ? extends NasConnection<?>> connection, ParameterMap params, NasConnectionInspector old) throws IOException {
        super(setup, nasIPAddress, secret, connection, params, old);
        this.sessionMode = params.get("session.mode", "hex");
    }

    private String getOidEnd(NASSession session) {
        String result = "";
        if (this.sessionMode.equals("hex")) {
            result = this.getDecSessionId(session.getAcctSessionId().trim());
        } else if (this.sessionMode.startsWith("hex")) {
            int col = Utils.parseInt(this.sessionMode.substring(3));
            result = this.getDecSessionId(session.getAcctSessionId().trim().substring(col));
        } else {
            result = session.getAcctSessionId().trim();
        }
        return result;
    }

    @Override
    protected void sendCheckRequest(NasConnection<?> con) {
        NASSession session = (NASSession)con.getSession();
        try {
            OneGetPdu getPdu = new OneGetPdu((SnmpContextBasisFace)this.context);
            getPdu.addOid(this.snmp_oid_check + "." + this.getOidEnd(session));
            getPdu.addObserver((Observer)new SNMPNasConnectionCheckObserver(this.context.getVersion(), con, this.nasIPAddress));
            getPdu.send();
            session.addLogDebug("SNMP check request: oid " + this.snmp_oid_check + "." + this.getOidEnd(session));
        }
        catch (Exception ex) {
            logger.error(ex.getMessage(), (Throwable)ex);
            session.addLogError("SNMP check request ERROR:  [ SNMP ver." + this.context.getVersion() + ", host=" + this.nasIPAddress + ", msg=" + ex.getMessage() + " ]");
        }
    }

    @Override
    protected long sendKillRequest(NasConnection<?> con) {
        NASSession session = (NASSession)con.getSession();
        try {
            SetPdu setPdu = new SetPdu((SnmpContextBasisFace)this.context);
            setPdu.addOid(this.snmp_oid_kill + "." + this.getOidEnd(session), (AsnObject)new AsnInteger(1));
            setPdu.send();
            session.addLogInfo("SNMP reset request: set " + this.snmp_oid_kill + "." + this.getOidEnd(session) + " i 1");
        }
        catch (Exception ex) {
            logger.error(ex.getMessage(), (Throwable)ex);
            session.addLogError("SNMP reset ERROR [ SNMP ver." + this.context.getVersion() + ", host=" + this.nasIPAddress + ", msg=" + ex.getMessage() + " ]");
        }
        return 0L;
    }
}

