/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.kernel.network.radius;

import bitel.billing.server.contract.bean.Contract;
import java.util.Arrays;
import ru.bitel.bgbilling.kernel.network.radius.RadiusAttribute;
import ru.bitel.bgbilling.kernel.network.radius.RadiusAttributeSet;
import ru.bitel.bgbilling.kernel.network.radius.RadiusListenerWorker;
import ru.bitel.bgbilling.kernel.network.radius.RadiusPacket;
import ru.bitel.bgbilling.kernel.network.radius.RadiusProcessor;
import ru.bitel.bgbilling.kernel.network.radius.RadiusUtils;
import ru.bitel.bgbilling.kernel.network.radius.nas.Nas;
import ru.bitel.common.sql.ConnectionSet;

public class RadiusSession<N extends Nas<?, ?, ?>, P> {
    public final byte[] stateAttribute;
    public final String userName;
    public final RadiusAttribute.RadiusAttributeString userNameAttribute;
    public final P sessionParams;
    public Object login;
    public Contract contract;
    public int errorCode;
    protected volatile long killTime;

    public RadiusSession(byte[] state, String userName, RadiusAttribute.RadiusAttributeString userNameAttribute, P sessionParams) {
        this.stateAttribute = state;
        this.userName = userName;
        this.userNameAttribute = userNameAttribute;
        this.sessionParams = sessionParams;
    }

    public void accessRequest(RadiusProcessor<?, N, P> processor, RadiusListenerWorker<N> req, N nas, RadiusPacket request, RadiusPacket response, ConnectionSet connectionSet, int log_record_id) {
        req.accessCode = this.authentication(processor, req, nas, request, response, connectionSet, log_record_id);
        int errorCode = req.accessCode;
        if (errorCode == 0) {
            response.setCode((byte)2);
        }
    }

    public int authentication(RadiusProcessor<?, N, P> processor, RadiusListenerWorker<N> req, N nas, RadiusPacket request, RadiusPacket response, ConnectionSet connectionSet, int log_record_id) {
        return processor.authentication(req, nas, this, request, response, connectionSet, log_record_id);
    }

    public boolean checkPassword(Nas<?, ?, ?> nas, RadiusAttributeSet request, RadiusAttributeSet response, String openPassw, byte[] secret, byte[] authenticator) {
        return RadiusUtils.checkPassword(nas, openPassw, request, response, secret, authenticator);
    }

    public static final class State {
        public final byte[] state;
        private int hash;

        public State(byte[] state) {
            this.state = state;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj instanceof State) {
                return Arrays.equals(this.state, ((State)obj).state);
            }
            return false;
        }

        public int hashCode() {
            int h = this.hash;
            if (h == 0) {
                this.hash = h = Arrays.hashCode(this.state);
            }
            return h;
        }
    }
}

