/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.kernel.tariff.server.tree.old;

import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import ru.bitel.bgbilling.kernel.tariff.server.tree.old.DefaultTariffTreeNode;
import ru.bitel.bgbilling.kernel.tariff.server.tree.old.TariffRequest;
import ru.bitel.common.Utils;

public class PrefixPartTariffTreeNode
extends DefaultTariffTreeNode {
    private Pattern pattern;
    private int dest;
    private int zone;

    @Override
    public void init(String data, int deep, int nodeID) {
        super.init(data, deep, nodeID);
        Map<String, String> dataHash = this.getDataInHash();
        String prefix = dataHash.get("prefix");
        if (prefix != null) {
            try {
                this.pattern = Pattern.compile("^(" + prefix + ")");
            }
            catch (Exception ex) {
                System.err.println("Error prefix compile: " + prefix);
            }
        }
        this.dest = Utils.parseInt((String)dataHash.get("dest"), (int)0);
        this.zone = Utils.parseInt((String)dataHash.get("zone"), (int)0);
    }

    @Override
    public void processRequest(TariffRequest request) {
        String phone = (String)request.getRequestParam("phone");
        String action = (String)request.getRequestParam("action");
        if (action != null && action.equals("reset")) {
            this.processForChilds(request);
        } else if (phone != null && this.pattern != null && !request.wasAccepted()) {
            Matcher m;
            String phoneRest = (String)request.getRequestParam("phone_rest");
            if (phoneRest == null) {
                phoneRest = phone;
            }
            if ((m = this.pattern.matcher(phoneRest)).find()) {
                String eqPart = m.group(0);
                phoneRest = phoneRest.substring(eqPart.length());
                request.setRequestParam("phone_rest", phoneRest);
                if (this.dest > 0) {
                    request.setResponseParam("dest", this.dest);
                }
                if (this.zone > 0) {
                    request.setResponseParam("zone", this.zone);
                }
                this.processForChilds(request);
                request.setAccepted();
            }
        }
    }
}

