/*
 * Decompiled with CFR 0.152.
 */
package bitel.billing.common.cache;

import bitel.billing.common.cache.CacheDocumentLoader;
import bitel.billing.common.cache.CacheItem;
import jakarta.servlet.ServletContext;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.util.HashMap;
import java.util.Map;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import ru.bitel.bgbilling.kernel.base.server.logger.BGLogger;
import ru.bitel.bgbilling.kernel.module.common.bean.BGInstalledModule;
import ru.bitel.bgbilling.kernel.module.server.ModuleCache;
import ru.bitel.bgbilling.kernel.plugin.common.BGPlugInElement;
import ru.bitel.bgbilling.kernel.plugin.common.BGPluginManagerBase;
import ru.bitel.bgbilling.server.util.Setup;
import ru.bitel.common.XMLUtils;

public class CacheManager
extends BGLogger {
    private static CacheManager cacheManager = null;
    private Map<String, CacheItem> cacheMap = new HashMap<String, CacheItem>();
    private Map<String, String> docLoadersMap = new HashMap<String, String>();
    Setup setup;
    HttpServletRequest request;
    HttpServletResponse response;
    ServletContext servletContext;

    private CacheManager() {
        try {
            this.loadDocLoaders();
        }
        catch (Exception ex) {
            this.logError(ex);
        }
    }

    private void init(Setup setup, HttpServletRequest request, HttpServletResponse response, ServletContext servletContext) {
        this.setup = setup;
        this.request = request;
        this.response = response;
        this.servletContext = servletContext;
    }

    public static CacheManager getCacheManager() {
        if (cacheManager == null) {
            cacheManager = new CacheManager();
        }
        return cacheManager;
    }

    public boolean removeDocument(String key) {
        boolean result = false;
        if (key != null) {
            CacheItem cacheItem = this.cacheMap.remove(key);
            result = cacheItem != null;
        }
        return result;
    }

    private CacheItem getCacheItem(String key, long version) {
        CacheItem cacheItem = this.get(key);
        if (cacheItem == null || !this.checkVersion(cacheItem, version)) {
            this.loadDocument(key, this.setup, this.request, this.response, this.servletContext);
            cacheItem = this.get(key);
        }
        return cacheItem;
    }

    public void getXML(Setup setup, Element rootNode, HttpServletRequest request, HttpServletResponse response, ServletContext servletContext) {
        this.init(setup, request, response, servletContext);
        String dirList = request.getParameter("cache_directory");
        if (dirList != null) {
            String[] dirs = dirList.split(";");
            Element xml = XMLUtils.createElement(rootNode, "cache_directory");
            for (int i = 0; i < dirs.length; ++i) {
                String[] dir = dirs[i].split(":");
                this.loadXML(xml, dir[0], Long.valueOf(dir[1]));
            }
        }
    }

    private void loadXML(Element xml, String key, long version) {
        CacheItem item = this.getCacheItem(key, version);
        if (item != null) {
            Document itemDocument;
            Element docElement = XMLUtils.createElement(xml, "document");
            docElement.setAttribute("key", key);
            docElement.setAttribute("version", String.valueOf(item.getVersion()));
            if (item.getVersion() != version && (itemDocument = item.getDocument()) != null) {
                Document ownerDocument = docElement.getOwnerDocument();
                Node d = ownerDocument.importNode(itemDocument.getFirstChild(), true);
                docElement.appendChild(d);
            }
        }
    }

    private CacheItem loadDocument(String key, Setup setup, HttpServletRequest request, HttpServletResponse response, ServletContext servletContext) {
        CacheItem cacheItem = null;
        String className = null;
        try {
            className = this.docLoadersMap.get(key);
            if (className != null) {
                CacheDocumentLoader loader = (CacheDocumentLoader)((Object)Class.forName(className).getConstructor(new Class[0]).newInstance(new Object[0]));
                Document doc = XMLUtils.newDocument();
                Element rootNode = doc.createElement("data");
                doc.appendChild(rootNode);
                loader.loadDocument(key, setup, rootNode, request, response, servletContext);
                cacheItem = new CacheItem();
                cacheItem.setDocument(doc);
                cacheItem.setKey(key);
                cacheItem.setVersion(System.currentTimeMillis());
                this.put(cacheItem);
            }
        }
        catch (Exception ex) {
            this.logError("Class not found [" + className + "]", ex);
        }
        return cacheItem;
    }

    private void put(CacheItem cacheItem) {
        if (cacheItem != null) {
            this.cacheMap.put(cacheItem.getKey(), cacheItem);
        }
    }

    private CacheItem get(String key) {
        CacheItem cacheItem = null;
        if (key != null) {
            cacheItem = this.cacheMap.get(key);
        }
        return cacheItem;
    }

    private long getVersion(String key) {
        CacheItem cacheItem = this.get(key);
        return this.getVersion(cacheItem);
    }

    private long getVersion(CacheItem cacheItem) {
        long version = -1L;
        if (cacheItem != null) {
            version = cacheItem.getVersion();
        }
        return version;
    }

    public boolean checkVersion(String key, long version) {
        return version == this.getVersion(key);
    }

    public boolean checkVersion(CacheItem cacheItem, long version) {
        return version == this.getVersion(cacheItem);
    }

    private void loadDocLoaders() throws Exception {
        for (BGPlugInElement extension : BGPluginManagerBase.getManager().getExtensions("bitel.billing.common.cache.CacheManager", false)) {
            this.loadDocLoader(extension.getElement());
        }
        for (BGInstalledModule instModule : ModuleCache.getInstance().getInstalledModulesList()) {
            Element extension = instModule.getServerExtensionMap().get("bitel.billing.common.cache.CacheManager");
            if (extension == null) continue;
            this.loadDocLoader(extension);
        }
    }

    private void loadDocLoader(Element element) throws Exception {
        for (Element loader : XMLUtils.selectElements(element, "loader")) {
            String key = loader.getAttribute("key");
            String className = loader.getAttribute("class");
            if (key == null || className == null) continue;
            this.docLoadersMap.put(key, className);
        }
    }
}

