/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.modules.hd.client;

import bitel.billing.module.common.table.BGTable;
import bitel.billing.module.services.ServiceConfigTabbedPanel;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import javax.swing.Box;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.border.Border;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import ru.bitel.bgbilling.client.common.BGMaskTextField;
import ru.bitel.bgbilling.client.common.BGTextField;
import ru.bitel.bgbilling.client.common.BGTitleBorder;
import ru.bitel.bgbilling.client.util.ClientUtils;
import ru.bitel.bgbilling.common.bean.Request;
import ru.bitel.common.XMLUtils;
import ru.bitel.common.client.BGButtonPanelOkCancel;

public class ServiceConfigHostingServer
extends ServiceConfigTabbedPanel {
    private BGTable table = new BGTable();
    private JPanel editPanel = new JPanel(new GridBagLayout());
    private BGTextField title = new BGTextField();
    private BGMaskTextField addr = new BGMaskTextField("                              :     ", ":", new BGMaskTextField.FieldValidator[]{null, new BGMaskTextField.IntegerValidator(0L, Integer.MAX_VALUE)}, new BGMaskTextField.Format[]{new BGMaskTextField.Format(true, 2, 0.0, 0.0, 1, null), null});
    private JTextArea comment = new JTextArea();
    private BGButtonPanelOkCancel okCancel = new BGButtonPanelOkCancel();

    public ServiceConfigHostingServer() {
        try {
            this.jbInit();
        }
        catch (Exception ex) {
            ClientUtils.showErrorMessageDialog((Throwable)ex);
        }
        this.table.setHeader(this.rb_name, this.moduleDoc, "host_server");
    }

    private void jbInit() {
        this.setLayout(new GridBagLayout());
        this.add(new JScrollPane((Component)this.table), new GridBagConstraints(0, 0, 1, 1, 1.0, 1.0, 10, 1, new Insets(5, 5, 5, 5), 0, 0));
        this.editPanel.setBorder((Border)new BGTitleBorder(" \u0420\u0435\u0434\u0430\u043a\u0442\u0438\u0440\u043e\u0432\u0430\u043d\u0438\u0435 "));
        this.add(this.editPanel, new GridBagConstraints(0, 1, 1, 1, 1.0, 0.0, 10, 2, new Insets(0, 0, 0, 0), 0, 0));
        this.editPanel.add((Component)new JLabel("\u041d\u0430\u0437\u0432\u0430\u043d\u0438\u0435:"), new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 13, 0, new Insets(10, 5, 5, 0), 0, 0));
        this.editPanel.add((Component)this.title, new GridBagConstraints(1, 0, 1, 1, 0.0, 0.0, 10, 2, new Insets(10, 5, 5, 0), 0, 0));
        this.editPanel.add((Component)new JLabel("\u0410\u0434\u0440\u0435\u0441:"), new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 13, 0, new Insets(0, 5, 5, 0), 0, 0));
        this.editPanel.add((Component)this.addr, new GridBagConstraints(1, 1, 1, 1, 0.0, 0.0, 10, 2, new Insets(0, 5, 5, 0), 0, 0));
        this.editPanel.add(Box.createVerticalGlue(), new GridBagConstraints(0, 2, 2, 1, 0.0, 1.0, 10, 2, new Insets(0, 5, 5, 0), 0, 0));
        JPanel panel = new JPanel(new GridBagLayout());
        panel.setBorder((Border)new BGTitleBorder(" \u041a\u043e\u043c\u043c\u0435\u043d\u0442\u0430\u0440\u0438\u0439 "));
        panel.add((Component)new JScrollPane(this.comment), new GridBagConstraints(0, 0, 1, 1, 1.0, 1.0, 10, 1, new Insets(0, 5, 5, 5), 0, 0));
        panel.setMinimumSize(new Dimension(100, 120));
        panel.setPreferredSize(new Dimension(100, 120));
        this.editPanel.add((Component)panel, new GridBagConstraints(2, 0, 1, 3, 1.0, 1.0, 17, 1, new Insets(0, 5, 5, 5), 0, 0));
        this.editPanel.add((Component)this.okCancel, new GridBagConstraints(0, 3, 3, 1, 1.0, 0.0, 17, 2, new Insets(0, 5, 5, 5), 0, 0));
        this.table.addMouseListener((MouseListener)new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                if (e.getClickCount() == 2) {
                    ServiceConfigHostingServer.this.editItem();
                }
            }
        });
        this.okCancel.addActionListener(e -> this.stopEdit(e.getActionCommand().equals("ok")));
        this.editPanel.setVisible(false);
        this.editPanel.addComponentListener(new ComponentAdapter(){

            @Override
            public void componentHidden(ComponentEvent e) {
                ServiceConfigHostingServer.this.setData();
            }
        });
    }

    public void setData() {
        Request req = new Request();
        req.setModule(this.module);
        req.setModuleId(this.getModuleId());
        req.setAction("HostingServer");
        Document doc = this.getDocument(req);
        if (ClientUtils.checkStatus((Document)doc)) {
            this.table.updateData(XMLUtils.getNode((Document)doc, (String)"table"));
        }
    }

    public void startEdit() {
        if (this.id != null) {
            Request req = new Request();
            req.setModule(this.module);
            req.setModuleId(this.getModuleId());
            req.setAction("HostingServerGet");
            req.setAttribute("id", this.id);
            Document doc = this.getDocument(req);
            if (ClientUtils.checkStatus((Document)doc)) {
                Element hostingServer = XMLUtils.getElement((Document)doc, (String)"hostingServer");
                this.title.setText(hostingServer.getAttribute("title"));
                this.addr.setText(hostingServer.getAttribute("addr"));
                this.comment.setText(hostingServer.getAttribute("comment"));
            }
        } else {
            this.title.setText("");
            this.addr.setText("");
            this.comment.setText("");
        }
        this.editPanel.setVisible(true);
    }

    public void stopEdit(boolean save) {
        if (save) {
            Request req = new Request();
            req.setModule(this.module);
            req.setModuleId(this.getModuleId());
            req.setAction("HostingServerUpdate");
            req.setAttribute("id", this.id);
            req.setAttribute("title", this.title.getText());
            req.setAttribute("addr", this.addr.getText());
            req.setAttribute("comment", this.comment.getText());
            Document doc = this.getDocument(req);
            if (ClientUtils.checkStatus((Document)doc)) {
                this.editPanel.setVisible(false);
            }
        } else {
            this.editPanel.setVisible(false);
        }
    }

    public void deleteItem() {
        this.id = ClientUtils.getRowId((BGTable)this.table);
        if (this.id != null && JOptionPane.showConfirmDialog(JOptionPane.getRootFrame(), "\u0423\u0434\u0430\u043b\u0438\u0442\u044c \u0445\u043e\u0441\u0442 \u0441\u0435\u0440\u0432\u0435\u0440?", "\u0423\u0434\u0430\u043b\u0435\u043d\u0438\u0435", 0) == 0) {
            Request request = new Request();
            request.setModule(this.module);
            request.setModuleId(this.getModuleId());
            request.setAction("HostingServerDelete");
            request.setAttribute("id", this.id);
            if (ClientUtils.checkStatus((Document)this.getDocument(request))) {
                this.setData();
            }
        }
    }

    public void editItem() {
        this.id = ClientUtils.getRowId((BGTable)this.table);
        if (this.id != null) {
            this.startEdit();
        }
    }

    public void newItem() {
        this.id = null;
        this.startEdit();
    }
}

