/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.modules.gorod.server.bean;

import java.sql.Connection;
import java.sql.Date;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import ru.bitel.bgbilling.modules.gorod.server.bean.GorodParams;
import ru.bitel.bgbilling.modules.gorod.server.bean.Register;
import ru.bitel.bgbilling.modules.gorod.server.bean.RegisterItem;
import ru.bitel.bgbilling.modules.gorod.server.bean.RegisterManager;
import ru.bitel.common.Preferences;
import ru.bitel.common.TimeUtils;
import ru.bitel.common.Utils;

public class RegisterItemManager {
    private Connection con;
    private int mid;
    private GorodParams params;
    private AccountEntry[] groupsAccounts;

    public RegisterItemManager(Connection con, int mid, Preferences moduleSetup) {
        this.con = con;
        this.mid = mid;
        this.params = new GorodParams(moduleSetup);
        ArrayList<AccountEntry> groupsAccounts = new ArrayList<AccountEntry>();
        for (Map.Entry e : moduleSetup.sub("account.gr.").entrySet()) {
            AccountEntry a = new AccountEntry();
            a.groups = Utils.parseLong((String)((String)e.getKey()), (long)0L);
            a.account = Utils.parseInt((String)((String)e.getValue()), (int)0);
            groupsAccounts.add(a);
        }
        this.groupsAccounts = new AccountEntry[groupsAccounts.size()];
        this.groupsAccounts = groupsAccounts.toArray(this.groupsAccounts);
    }

    private int getTagAccount(int tagID) {
        return Utils.parseInt((String)this.params.getTagAccounts().get(String.valueOf(tagID)), (int)0);
    }

    private int getContractGroupAccount(long gr, int defaultAccount) {
        for (AccountEntry e : this.groupsAccounts) {
            if ((gr & e.groups) <= 0L) continue;
            return e.account;
        }
        return defaultAccount;
    }

    public void createRegisterDiff(int fromID, int toID, Calendar date, int tagID) {
        HashMap<Integer, RegisterItem> newRegister = new HashMap<Integer, RegisterItem>();
        for (RegisterItem item : this.getRegisterItems(toID)) {
            newRegister.put(item.contractID, item);
        }
        RegisterManager manager = new RegisterManager(this.con, this.mid);
        Register register3 = new Register();
        register3.setType(3);
        register3.setDate(date);
        register3.setTagId(tagID);
        manager.addRegister(register3);
        int reg3ID = register3.getId();
        Register register9 = new Register();
        register9.setType(9);
        register9.setDate(date);
        register9.setTagId(tagID);
        manager.addRegister(register9);
        int reg9ID = register9.getId();
        try {
            Statement psInsert = null;
            List<RegisterItem> oldRegister = this.getRegisterItems(fromID);
            for (RegisterItem oldItem : oldRegister) {
                RegisterItem newItem = (RegisterItem)newRegister.remove(oldItem.contractID);
                if (newItem == null) {
                    psInsert = this.addRegisterItem(reg9ID, oldItem, (PreparedStatement)psInsert);
                    continue;
                }
                if (newItem.equals(oldItem)) continue;
                psInsert = this.addRegisterItem(reg3ID, newItem, (PreparedStatement)psInsert);
            }
            for (RegisterItem newItem : newRegister.values()) {
                psInsert = this.addRegisterItem(reg3ID, newItem, (PreparedStatement)psInsert);
            }
            if (psInsert != null) {
                psInsert.close();
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public List<RegisterItem> getRegisterItems(int registerID) {
        ArrayList<RegisterItem> result = new ArrayList<RegisterItem>();
        try {
            Statement st = this.con.createStatement();
            ResultSet rs = st.executeQuery("SELECT * FROM gorod_register_item_" + this.mid + " WHERE rid=" + registerID);
            while (rs.next()) {
                RegisterItem item = new RegisterItem();
                item.contractID = rs.getInt("cid");
                item.contract = rs.getString("contract");
                item.fullname = rs.getString("fullname");
                item.address = rs.getString("address");
                item.account = rs.getInt("account");
                item.rest = rs.getFloat("rest");
                result.add(item);
            }
            rs.close();
            st.close();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return result;
    }

    public int getRegisterItemCount(int registerID) {
        int result = 0;
        try {
            Statement st = this.con.createStatement();
            ResultSet rs = st.executeQuery("SELECT COUNT(*) FROM gorod_register_item_" + this.mid + " WHERE rid=" + registerID);
            if (rs.next()) {
                result = rs.getInt(1);
            }
            rs.close();
            st.close();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return result;
    }

    public Register createFullRegister(Calendar date, int tagID) {
        int account = this.getTagAccount(tagID);
        RegisterManager manager = new RegisterManager(this.con, this.mid);
        Register register = manager.getRegister(7, date, tagID);
        if (register != null) {
            manager.deleteRegister(register.getId());
        }
        Register result = new Register();
        result.setType(7);
        result.setDate(date);
        result.setTagId(tagID);
        manager.addRegister(result);
        int rid = result.getId();
        try {
            Object query = null;
            Statement st = this.con.createStatement();
            st.executeUpdate("DROP TABLE IF EXISTS gorod_balance");
            query = "CREATE TABLE gorod_balance( UNIQUE(cid) ) SELECT cid, MAX(yy*12+(mm-1))%12 + 1 AS mm,FLOOR(MAX(yy*12+(mm-1)) / 12) AS yy FROM contract_balance GROUP BY cid";
            st.executeUpdate((String)query);
            query = "SELECT contract.id, contract.title, cpn.val, city.title, street.title, house.house, house.frac, cp.flat, (-(cb.summa1 + cb.summa2 - cb.summa3 - cb.summa4)) AS balance,cp.hid, b.yy, b.mm, contract.gr FROM contract LEFT JOIN contract_parameter_type_1 AS cpn ON contract.id=cpn.cid AND cpn.pid=? LEFT JOIN contract_parameter_type_2 AS cp ON contract.id=cp.cid AND cp.pid=? LEFT JOIN address_house AS house ON cp.hid=house.id LEFT JOIN address_street AS street ON house.streetid=street.id LEFT JOIN address_city AS city ON street.cityid=city.id LEFT JOIN gorod_balance AS b ON contract.id=b.cid LEFT JOIN contract_balance AS cb ON contract.id=cb.cid AND cb.yy=b.yy AND cb.mm=b.mm WHERE contract.date1<=? AND (contract.date2 IS NULL OR ?<=contract.date2) AND contract.gr&?>0 AND contract.del=0 AND contract.id IN ( SELECT t.cid FROM gorod_contract_tag_" + this.mid + " AS t WHERE t.tid=?)";
            PreparedStatement ps = this.con.prepareStatement((String)query);
            Date sqlDate = TimeUtils.convertCalendarToSqlDate((Calendar)date);
            ps.setInt(1, this.params.getParamFullName());
            ps.setInt(2, this.params.getParamAddress());
            ps.setDate(3, sqlDate);
            ps.setDate(4, sqlDate);
            ps.setLong(5, this.params.getGroupMask());
            ps.setInt(6, tagID);
            Statement psInsert = null;
            StringBuffer address = new StringBuffer();
            ResultSet rs = ps.executeQuery();
            while (rs.next()) {
                RegisterItem item = new RegisterItem();
                item.contractID = rs.getInt(1);
                item.contract = rs.getString(2);
                item.fullname = rs.getString(3);
                this.makeAddress(address, rs, item.contractID);
                item.address = address.toString();
                long gr = rs.getLong(13);
                item.account = this.getContractGroupAccount(gr, account);
                item.rest = rs.getFloat(9);
                psInsert = this.addRegisterItem(rid, item, (PreparedStatement)psInsert);
            }
            rs.close();
            ps.close();
            if (psInsert != null) {
                psInsert.close();
            }
            st.executeUpdate("DROP TABLE IF EXISTS gorod_balance");
            st.close();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return result;
    }

    private void makeAddress(StringBuffer address, ResultSet rs, int cid) throws Exception {
        address.setLength(0);
        String city = rs.getString(4);
        String street = rs.getString(5);
        String house = rs.getString(6);
        String fract = rs.getString(7);
        String flat = rs.getString(8);
        if (city != null && street != null && house != null && flat != null) {
            if (this.params.isDropGFromAddress()) {
                city = city.replaceAll("^\\s*\u0433\\.\\s*", "");
            }
            address.append(city);
            address.append(",");
            address.append(street);
            address.append(",");
            address.append(house);
            if (Utils.notEmptyString((String)fract)) {
                if (Character.isDigit(fract.charAt(0))) {
                    address.append("/");
                }
                address.append(fract);
            }
            address.append(",");
            address.append(flat);
        } else {
            address.append(this.params.getDefaultAddress().replace("${cid}", String.valueOf(cid)));
        }
    }

    private PreparedStatement addRegisterItem(int registerID, RegisterItem item, PreparedStatement psInsert) throws Exception {
        if (psInsert == null) {
            String query = "INSERT INTO gorod_register_item_" + this.mid + " SET rid=?, cid=?, contract=?, fullname=?, address=?, account=?, rest=?";
            psInsert = this.con.prepareStatement(query);
        }
        if (Utils.notBlankString((String)item.fullname)) {
            psInsert.setInt(1, registerID);
            psInsert.setInt(2, item.contractID);
            psInsert.setString(3, item.contract);
            psInsert.setString(4, item.fullname);
            psInsert.setString(5, item.address);
            psInsert.setInt(6, item.account);
            psInsert.setFloat(7, item.rest);
            psInsert.executeUpdate();
        }
        return psInsert;
    }

    private class AccountEntry {
        private long groups;
        private int account;

        private AccountEntry() {
        }
    }
}

