#!/bin/bash

cd ${0%${0##*/}}.

. ./setenv.sh

APP_NAME="BGBillingServer"
DATE=`date +"%F_%T"`
REPORT_DIR="/tmp/$DATE"

mkdir $REPORT_DIR

./server_status.sh > "$REPORT_DIR/status"

PID=`ps axwww | grep $APP_NAME  | grep -v grep | awk '{ print $1 }'`
if [ "$PID" -gt "0" ]; then
    echo "Making jstack for pid=$PID"
    $JAVA_HOME/bin/jstack $PID > "$REPORT_DIR/jstack"
else
    echo "Process not found!"
fi

echo "Copy log.."
cp -R ./log "$REPORT_DIR"

echo "${PID}"
