/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.modules.voice.server.service;

import jakarta.annotation.PostConstruct;
import jakarta.jws.WebService;
import java.util.ArrayList;
import java.util.List;
import ru.bitel.bgbilling.common.BGMessageException;
import ru.bitel.bgbilling.kernel.container.service.server.AbstractService;
import ru.bitel.bgbilling.kernel.event.EventProcessor;
import ru.bitel.bgbilling.kernel.event.common.Event;
import ru.bitel.bgbilling.modules.voice.common.bean.VoiceAccountPort;
import ru.bitel.bgbilling.modules.voice.common.bean.VoiceOperAccount;
import ru.bitel.bgbilling.modules.voice.common.bean.VoiceOperAccountSearchParam;
import ru.bitel.bgbilling.modules.voice.common.bean.VoiceOperAccountType;
import ru.bitel.bgbilling.modules.voice.common.event.VoiceOperAccountModifiedEvent;
import ru.bitel.bgbilling.modules.voice.common.service.VoiceOperAccountService;
import ru.bitel.bgbilling.modules.voice.server.bean.VoiceAccountPortDao;
import ru.bitel.bgbilling.modules.voice.server.bean.VoiceOperAccountDao;
import ru.bitel.common.model.Id;
import ru.bitel.common.model.Page;
import ru.bitel.common.model.Period;
import ru.bitel.common.model.SearchResult;

@WebService(endpointInterface="ru.bitel.bgbilling.modules.voice.common.service.VoiceOperAccountService")
public class VoiceOperAccountServiceImpl
extends AbstractService
implements VoiceOperAccountService {
    private VoiceOperAccountDao operAccountDao;
    private VoiceAccountPortDao voiceAccountPortDao;

    @PostConstruct
    private void init() {
        this.operAccountDao = new VoiceOperAccountDao(this.getConnection(), this.moduleId);
        this.voiceAccountPortDao = new VoiceAccountPortDao(this.getConnection(), this.moduleId);
    }

    public List<VoiceOperAccount> voiceOperAccountList(int contractId, Period period) throws Exception {
        return this.operAccountDao.list(contractId, period);
    }

    public VoiceOperAccount voiceOperAccountGet(int accountId) throws Exception {
        VoiceOperAccount voiceOperAccount = (VoiceOperAccount)this.operAccountDao.get(accountId);
        List<VoiceAccountPort> ports = this.voiceAccountPortDao.list(accountId);
        voiceOperAccount.setFromPortList(ports.stream().filter(a -> !a.isOut()).toList());
        voiceOperAccount.setToPortList(ports.stream().filter(a -> a.isOut()).toList());
        return voiceOperAccount;
    }

    public int voiceOperAccountUpdate(VoiceOperAccount account) throws Exception {
        VoiceOperAccount oldAccount = null;
        if (account.getId() > 0) {
            oldAccount = (VoiceOperAccount)this.operAccountDao.get(account.getId());
        }
        if (account.getDeviceId() <= 0) {
            throw new BGMessageException("\u0412\u044b \u0434\u043e\u043b\u0436\u043d\u044b \u0432\u044b\u0431\u0440\u0430\u0442\u044c \u0443\u0441\u0442\u0440\u043e\u0439\u0441\u0442\u0432\u043e");
        }
        this.operAccountDao.update(account);
        this.updatePorts(account, account.getId());
        EventProcessor.getInstance().publishAfterCommit((Event)new VoiceOperAccountModifiedEvent(this.moduleId, account.getContractId(), this.userId, oldAccount, account));
        return account.getId();
    }

    public int voiceOperAccountDelete(int accountId) throws Exception {
        VoiceOperAccount oldAccount = null;
        if (accountId > 0) {
            oldAccount = (VoiceOperAccount)this.operAccountDao.get(accountId);
        }
        int result = this.operAccountDao.delete(accountId);
        EventProcessor.getInstance().publishAfterCommit((Event)new VoiceOperAccountModifiedEvent(this.moduleId, (oldAccount != null ? Integer.valueOf(oldAccount.getContractId()) : null).intValue(), this.userId, oldAccount, null));
        return result;
    }

    public List<VoiceOperAccountType> voiceOperAccountTypeList() throws Exception {
        return this.context.getDirectory(VoiceOperAccountType.class, this.moduleId).list();
    }

    public VoiceOperAccountType voiceOperAccountTypeGet(int accountTypeId) throws Exception {
        return (VoiceOperAccountType)this.context.getDirectory(VoiceOperAccountType.class, this.moduleId).get(accountTypeId);
    }

    public int voiceOperAccountTypeUpdate(VoiceOperAccountType accountType) throws Exception {
        this.context.getDirectory(VoiceOperAccountType.class, this.moduleId).update((Id)accountType);
        return accountType.getId();
    }

    public int voiceOperAccountTypeDelete(int accountTypeId) throws Exception {
        return this.context.getDirectory(VoiceOperAccountType.class, this.moduleId).delete(accountTypeId);
    }

    private void updatePorts(VoiceOperAccount account, int accountId) throws Exception {
        ArrayList<VoiceAccountPort> ports = new ArrayList<VoiceAccountPort>();
        if (!account.getFromPortList().isEmpty()) {
            ports.addAll(account.getFromPortList());
        }
        if (!account.getToPortList().isEmpty()) {
            ports.addAll(account.getToPortList());
        }
        this.voiceAccountPortDao.update(account.getId(), ports);
    }

    public SearchResult<VoiceOperAccount> voiceSearchAccount(VoiceOperAccountSearchParam searchParam, Page page) throws Exception {
        return this.operAccountDao.list(searchParam, page);
    }
}

